package net.db64.homelawnsecurity.mixin;

import com.llamalad7.mixinextras.injector.WrapWithCondition;
import com.llamalad7.mixinextras.sugar.Local;
import net.db64.homelawnsecurity.entity.custom.IPvzEntity;
import net.db64.homelawnsecurity.entity.custom.PlantEntity;
import net.db64.homelawnsecurity.entity.custom.ZombieEntity;
import net.db64.homelawnsecurity.util.IEntityDataSaver;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_5819;
import org.spongepowered.asm.mixin.*;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Debug(export = true)
@Mixin(class_1297.class)
public abstract class EntityMixin implements IEntityDataSaver {
	@Shadow
	public abstract class_2338 getBlockPos();

	@Shadow
	public abstract class_1937 getEntityWorld();

	@Final
	@Shadow
	protected class_5819 random;

	@Unique
	private class_2487 persistentData;

	@Override
	public class_2487 getPersistentData() {
		if (this.persistentData == null) {
			this.persistentData = new class_2487();
		}
		return persistentData;
	}

	@Inject(
		method = "writeData",
		at = @At("HEAD")
	)
	protected void injectWriteMethod(class_11372 view, CallbackInfo ci) {
		if (persistentData != null) {
			view.method_71468(IEntityDataSaver.dataId, class_2487.field_25128, persistentData);
		}
	}

	@Inject(
		method = "readData",
		at = @At("HEAD")
	)
	protected void injectReadMethod(class_11368 view, CallbackInfo ci) {
		persistentData = view.method_71426(IEntityDataSaver.dataId, class_2487.field_25128).orElse(new class_2487());
	}


	// -===-


	@WrapWithCondition(
		method = "pushAwayFrom",
		at = @At(
			value = "INVOKE",
			target = "Lnet/minecraft/entity/Entity;addVelocity(DDD)V",
			ordinal = 0
		)
	)
	private boolean checkForPushThis(class_1297 instance, double deltaX, double deltaY, double deltaZ, @Local(index = 0, argsOnly = true) class_1297 that) {
		class_1297 toHiss = (class_1297) (Object) this; // This should be pushed by that if...
		return (toHiss instanceof ZombieEntity && that instanceof PlantEntity) // This is a zombie being pushed by that plant
			|| (!(toHiss instanceof IPvzEntity) && !(that instanceof IPvzEntity)); // Neither of these are PvZ-related
	}

	@WrapWithCondition(
		method = "pushAwayFrom",
		at = @At(
			value = "INVOKE",
			target = "Lnet/minecraft/entity/Entity;addVelocity(DDD)V",
			ordinal = 1
		)
	)
	private boolean checkForPushThat(class_1297 instance, double deltaX, double deltaY, double deltaZ, @Local(index = 0, argsOnly = true) class_1297 that) {
		class_1297 toHiss = (class_1297) (Object) this; // That should be pushed by this if...
		return (that instanceof ZombieEntity && toHiss instanceof PlantEntity) // That is a zombie being pushed by this plant
			|| (!(that instanceof IPvzEntity) && !(toHiss instanceof IPvzEntity)); // Neither of these are PvZ-related
	}
}
