package net.db64.homelawnsecurity.mixin;

import net.db64.homelawnsecurity.HomeLawnSecurity;
import net.db64.homelawnsecurity.component.BagOfCurrencyComponent;
import net.db64.homelawnsecurity.component.CurrencyComponent;
import net.db64.homelawnsecurity.component.ModDataComponentTypes;
import net.db64.homelawnsecurity.item.ModItems;
import net.db64.homelawnsecurity.item.custom.BagOfCurrencyItem;
import net.db64.homelawnsecurity.item.custom.SeedPacketItem;
import net.minecraft.class_11580;
import net.minecraft.class_1299;
import net.minecraft.class_1799;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_329;
import net.minecraft.class_332;
import net.minecraft.class_5250;
import net.minecraft.class_8824;
import net.minecraft.class_9334;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyVariable;

@Mixin(class_329.class)
public abstract class InGameHudMixin {
	@Shadow
	private class_1799 currentStack;

	@Final
	@Shadow
	private class_310 client;

	@ModifyVariable(
		method = "renderHeldItemTooltip",
		at = @At(
			value = "STORE"
		),
		ordinal = 0
	)
	public class_5250 modifyItemName(class_5250 value, class_332 context) {
		// Seed Packet
		if (currentStack.method_57826(ModDataComponentTypes.SEED_PACKET)) {
			class_5250 entityName = class_2561.method_43473();
			class_2520 customName = null;

			// Custom name
			if (currentStack.method_57826(class_9334.field_49609)) {
				class_11580<class_1299<?>> entityDataComponent = currentStack.method_58694(class_9334.field_49609);
				if (entityDataComponent != null) {
					customName = entityDataComponent.method_72540().method_10580("CustomName");
					if (customName != null && client.field_1687 != null) {
						try {
							entityName = class_2561.method_43473().method_10852(class_8824.field_46597.parse(client.field_1687.method_30349().method_57093(class_2509.field_11560), customName).getOrThrow());
						} catch (Exception e) {
							HomeLawnSecurity.LOGGER.warn("Failed to parse entity custom name {}", customName.method_68658(), e);
						}
					}
				}
			}

			// No custom name
			if (customName == null) {
				class_1299<?> entityType;
				if (currentStack.method_7909() instanceof SeedPacketItem) {
					entityType = ((SeedPacketItem) currentStack.method_7909()).getEntityType(currentStack);
				} else {
					entityType = ((SeedPacketItem) ModItems.SEED_PACKET_PEASHOOTER).getEntityType(currentStack);
				}
				if (entityType != null) {
					entityName = class_2561.method_43473().method_10852(entityType.method_5897());
				}
			}

			value = class_2561.method_43473().method_10852(entityName);
			//HomeLawnSecurity.LOGGER.info(value.toString());
		}

		// Currency
		else if (currentStack.method_57826(ModDataComponentTypes.CURRENCY)) {
			class_5250 currencyText = class_2561.method_43473();
			CurrencyComponent currencyComponent = currentStack.method_58695(ModDataComponentTypes.CURRENCY, new CurrencyComponent(25, "sun"));

			// 25 Sun
			currencyText = currencyText.method_10852(class_2561.method_43469("item.homelawnsecurity.currency.name." + currencyComponent.name(), currencyComponent.amount()));

			value = class_2561.method_43473().method_10852(currencyText);
		}

		// Bag of Currency
		else if (currentStack.method_57826(ModDataComponentTypes.BAG_OF_CURRENCY)) {
			class_5250 currencyText = class_2561.method_43473();
			BagOfCurrencyComponent bagComponent = currentStack.method_58695(ModDataComponentTypes.BAG_OF_CURRENCY, new BagOfCurrencyComponent(25, "sun"));

			// Bag of Sun - 25 Sun
			currencyText = currencyText
				.method_10852(currentStack.method_7964())
				.method_10852(class_2561.method_43471("item.homelawnsecurity.currency.name.separator"))
				.method_10852(class_2561.method_43469("item.homelawnsecurity.currency.name." + bagComponent.name(), bagComponent.amount()));

			value = class_2561.method_43473().method_10852(currencyText);
		}

		return value;
	}
}
