package net.db64.homelawnsecurity.mixin;

import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.ref.LocalRef;
import net.db64.homelawnsecurity.entity.ModDamageTypes;
import net.db64.homelawnsecurity.entity.custom.ZombieEntity;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_3218;
import net.minecraft.class_8111;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(class_1309.class)
public abstract class LivingEntityMixin extends EntityMixin {
	//@Shadow public abstract Iterable<ItemStack> getHandItems();

	@Shadow public abstract class_1799 getMainHandStack();

	@Shadow public abstract class_1799 getOffHandStack();

	@Inject(
		method = "damage",
		at = @At(
			value = "HEAD"
		)
	)
	private void changeZombieAttacksToEating(class_3218 world, class_1282 source, float amount, CallbackInfoReturnable<Boolean> cir, @Local(ordinal = 0, argsOnly = true) LocalRef<class_1282> sourceRef) {
		// If the damage is from a zombie's melee attack...
		//HomeLawnSecurity.LOGGER.info("zombie melee attack check, damage type name: " + sourceRef.get().getName() + ", attacker: " + sourceRef.get().getAttacker());
		if (sourceRef.get().method_49708(class_8111.field_42360) && (sourceRef.get().method_5529() != null && sourceRef.get().method_5529() instanceof ZombieEntity)) {
			// Change the damage type to zombie eat
			//HomeLawnSecurity.LOGGER.info("zombie melee attack.");
			class_1282 sauce = ((class_1297) (Object) this).method_48923().method_48796(ModDamageTypes.ZOMBIE_EAT, sourceRef.get().method_5529());
			sourceRef.set(sauce);
		}
	}
}
