package net.db64.homelawnsecurity.mixin;

import net.db64.homelawnsecurity.component.ModDataComponentTypes;
import net.db64.homelawnsecurity.sound.ModSounds;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_3419;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_1657.class)
public abstract class PlayerEntityMixin extends LivingEntityMixin {
	@Shadow
	private class_1799 selectedItem;

	@Inject(
		method = "tick",
		at = @At(
			value = "HEAD"
		)
	)
	public void makeItemSounds(CallbackInfo ci) {
		class_1937 world = getEntityWorld();
		if (world.method_8608()) {
			class_1799 itemStack = this.getMainHandStack();
			if (!class_1799.method_7973(this.selectedItem, itemStack)) {
				if (itemStack.method_57826(ModDataComponentTypes.SHOVEL)) {
					world.method_55116((class_1657) (Object) this, ModSounds.RANDOM_SHOVEL, class_3419.field_15248, 0.25f, random.method_43057() * 0.4f + 0.8f);
				}
				else if (itemStack.method_57826(ModDataComponentTypes.SEED_PACKET)) {
					world.method_55116((class_1657) (Object) this, ModSounds.RANDOM_SELECT_SEED, class_3419.field_15248, 0.25f, random.method_43057() * 0.4f + 0.8f);
				}
			}
		}
	}
}
