package net.db64.homelawnsecurity.particle.custom;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10017;
import net.minecraft.class_11659;
import net.minecraft.class_11938;
import net.minecraft.class_11942;
import net.minecraft.class_12075;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4604;
import net.minecraft.class_702;
import net.minecraft.class_898;
import java.util.List;

public class EntityParticleRenderer extends class_11938<MarkerParticle> {
	public EntityParticleRenderer(class_702 particleManager) {
		super(particleManager);
	}

	@Override
	public class_11942 method_74276(class_4604 frustum, class_4184 camera, float tickProgress) {
		return new EntityParticleRenderer.Result(
			this.field_62620.stream().map(particle -> EntityParticleRenderer.Instance.create(particle, camera, tickProgress)).toList()
		);
	}

	@Environment(EnvType.CLIENT)
	record Instance(class_10017 entityRenderState, double xOffset, double yOffset, double zOffset) {
		public static EntityParticleRenderer.Instance create(MarkerParticle particle, class_4184 camera, float tickProgress) {
			class_243 vec3d = camera.method_19326();
			return new EntityParticleRenderer.Instance(particle.renderState,
				particle.renderState.field_53325 - vec3d.method_10216(),
				particle.renderState.field_53326 - vec3d.method_10214(),
				particle.renderState.field_53327 - vec3d.method_10215());
		}
	}

	@Environment(EnvType.CLIENT)
	record Result(List<EntityParticleRenderer.Instance> instances) implements class_11942 {
		@Override
		public void submit(class_11659 orderedRenderCommandQueue, class_12075 cameraRenderState) {
			class_4587 matrixStack = new class_4587();
			class_898 entityRenderManager = class_310.method_1551().method_1561();

			for (EntityParticleRenderer.Instance instance : this.instances) {
				entityRenderManager.method_72976(
					instance.entityRenderState, cameraRenderState, instance.xOffset, instance.yOffset, instance.zOffset, matrixStack, orderedRenderCommandQueue
				);
			}
		}
	}
}
