package net.db64.homelawnsecurity.util;

import net.db64.homelawnsecurity.HomeLawnSecurity;
import net.db64.homelawnsecurity.block.ModBlocks;
import net.db64.homelawnsecurity.block.custom.lawn.ILawnBlock;
import net.db64.homelawnsecurity.block.custom.lawn.LawnMarkerBlock;
import net.db64.homelawnsecurity.block.custom.MarkerBlock;
import net.db64.homelawnsecurity.entity.custom.PlantEntity;
import net.db64.homelawnsecurity.entity.custom.ZombieEntity;
import net.db64.homelawnsecurity.entity.custom.other.LawnMowerEntity;
import net.db64.homelawnsecurity.entity.custom.other.TargetZombieEntity;
import net.db64.homelawnsecurity.entity.custom.plant.ILawnPlant;
import net.db64.homelawnsecurity.entity.custom.plant.IPathPlant;
import net.minecraft.class_1314;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;

public class LawnUtil {
	/**
	 * @return If this block can be walked on with the provided path id.
	 */
	public static boolean isWalkable(class_2338 pos, class_1937 world, int entityPathId, boolean isZombie) {
		class_2680 state = world.method_8320(pos);
		class_2680 markerState = world.method_8320(pos.method_10084());
		class_2248 block = state.method_26204();

		if (markerState.method_26204() instanceof MarkerBlock)
			return isWalkableMarker(markerState, entityPathId, isZombie);
		else if (block instanceof ILawnBlock || block == ModBlocks.GARDEN_BLOCK || block == ModBlocks.GRAVEYARD_BLOCK)
			return isWalkableBlock(state, entityPathId, isZombie);
		return false;
	}

	private static boolean isWalkableBlock(class_2680 state, int entityPathId, boolean isZombie) {
		if (isZombie && state.method_26204() == ModBlocks.GARDEN_BLOCK) {
			return true;
		}
		else if (!isZombie && state.method_26204() == ModBlocks.GRAVEYARD_BLOCK) {
			return true;
		}
		else {
			return isCertainPathHelper(state, entityPathId);
		}
	}

	private static boolean isWalkableMarker(class_2680 state, int entityPathId, boolean isZombie) {
		if (isZombie && state.method_26204() == ModBlocks.GARDEN_MARKER) {
			return true;
		}
		else if (!isZombie && state.method_26204() == ModBlocks.GRAVEYARD_MARKER) {
			return true;
		}
		else {
			return isCertainPathHelper(state, entityPathId);
		}
	}

	/**
	 * @return If this block has any path.
	 */
	public static boolean isAnyPath(class_2338 pos, class_1937 world) {
		class_2680 state = world.method_8320(pos);
		class_2680 markerState = world.method_8320(pos.method_10084());

		if (markerState.method_26204() instanceof LawnMarkerBlock) {
			return ILawnBlock.getMainPathId(markerState) != 0;
		}
		else if (state.method_26204() instanceof ILawnBlock) {
			return ILawnBlock.getMainPathId(state) != 0;
		}
		return false;
	}

	/**
	 * @return If this block has a path matching entityPathId.
	 */
	public static boolean isCertainPath(class_2338 pos, class_1937 world, int entityPathId) {
		class_2680 state = world.method_8320(pos);
		class_2680 markerState = world.method_8320(pos.method_10084());

		if (markerState.method_26204() instanceof LawnMarkerBlock) {
			return isCertainPathHelper(markerState, entityPathId);
		}
		else if (state.method_26204() instanceof ILawnBlock) {
			return isCertainPathHelper(state, entityPathId);
		}
		return false;
	}

	private static boolean isCertainPathHelper(class_2680 state, int entityPathId) {
		if (state.method_26204() instanceof ILawnBlock)
			return ILawnBlock.getMainPathId(state) == entityPathId || ILawnBlock.getIntersectingPathId(state) == entityPathId;
		return false;
	}

	/**
	 * @return If this kind of entity can be placed at this spot. Does not check distance from graveyard or if a plant is in the way.
	 */
	public static boolean isPlaceable(class_2338 pos, class_1937 world, Class<? extends class_1314> entityClass) {
		if (TargetZombieEntity.class.isAssignableFrom(entityClass)) {
			return TargetZombieEntity.isPlaceable(pos, world);
		}
		else if (ZombieEntity.class.isAssignableFrom(entityClass)) {
			return ZombieEntity.isPlaceable(pos, world);
		}
		else if (PlantEntity.class.isAssignableFrom(entityClass)) {
			if (ILawnPlant.class.isAssignableFrom(entityClass)) {
				return PlantEntity.isPlaceableLawn(pos, world);
			}
			else if (IPathPlant.class.isAssignableFrom(entityClass)) {
				return PlantEntity.isPlaceablePath(pos, world);
			}
			HomeLawnSecurity.LOGGER.error("We have a plant class ({}) that does not implement any placement interface! This is something ALL plant classes should do...", entityClass.getSimpleName());
		}
		else if (LawnMowerEntity.class.isAssignableFrom(entityClass)) {
			return LawnMowerEntity.isPlaceable(pos, world);
		}
		return true;
	}

	public static int getMainPathId(class_2338 pos, class_1937 world) {
		class_2680 state = world.method_8320(pos);
		class_2680 markerState = world.method_8320(pos.method_10084());

		if (markerState.method_26204() instanceof LawnMarkerBlock) {
			return ILawnBlock.getMainPathId(markerState);
		}
		else if (state.method_26204() instanceof ILawnBlock) {
			return ILawnBlock.getMainPathId(state);
		}
		return 0;
	}

	public static int getIntersectingPathId(class_2338 pos, class_1937 world) {
		class_2680 state = world.method_8320(pos);
		class_2680 markerState = world.method_8320(pos.method_10084());

		if (markerState.method_26204() instanceof LawnMarkerBlock) {
			return ILawnBlock.getIntersectingPathId(markerState);
		}
		else if (state.method_26204() instanceof ILawnBlock) {
			return ILawnBlock.getIntersectingPathId(state);
		}
		return 0;
	}

	public static boolean hasTurf(class_2338 pos, class_1937 world) {
		class_2680 state = world.method_8320(pos);
		class_2680 markerState = world.method_8320(pos.method_10084());

		if (markerState.method_26204() instanceof LawnMarkerBlock) {
			return ILawnBlock.getTurf(markerState);
		}
		else if (state.method_26204() instanceof ILawnBlock) {
			return ILawnBlock.getTurf(state);
		}
		return false;
	}

	public static int getPathTypeAmount() {
		return ILawnBlock.PATH_TYPE_AMOUNT;
	}
}
