/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.io.nbt;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import java.util.EnumSet;
import java.util.Optional;
import journeymap.common.Journeymap;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2359;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2804;
import net.minecraft.class_2808;
import net.minecraft.class_2818;
import net.minecraft.class_2826;
import net.minecraft.class_2841;
import net.minecraft.class_2852;
import net.minecraft.class_2902;
import net.minecraft.class_638;
import net.minecraft.class_6563;
import net.minecraft.class_7522;
import net.minecraft.class_7924;
import org.apache.logging.log4j.Logger;

public class CustomChunkReader {
    private static final Codec<class_2841<class_2680>> BLOCK_STATE_CODEC;
    private static final Logger logger;

    public static ProcessedChunk read(class_638 level, class_1923 chunkPos, class_2487 chunkTag) {
        block8: {
            try {
                if (class_2808.field_12807 != class_2852.method_67685((class_2487)chunkTag).method_12164()) break block8;
                class_2804 lights = null;
                boolean lightOn = chunkTag.method_10577("isLightOn").orElse(false);
                class_2499 sections = (class_2499)chunkTag.method_10554("sections").get();
                int sectionsCount = level.method_32890();
                class_2826[] chunkSections = new class_2826[sectionsCount];
                class_2378 registry = level.method_30349().method_30530(class_7924.field_41236);
                Codec codec = level.method_74142().comp_4790();
                for (int j = 0; j < sections.size(); ++j) {
                    class_2487 section = (class_2487)sections.method_10602(j).get();
                    byte sectionTopY = (Byte)section.method_10571("Y").get();
                    int sectionIndex = level.method_31603((int)sectionTopY);
                    if (sectionIndex >= 0 && sectionIndex < chunkSections.length) {
                        class_2826 chunkSection;
                        class_2841 blockStateContainer = section.method_10545("block_states") ? (class_2841)BLOCK_STATE_CODEC.parse((DynamicOps)class_2509.field_11560, (Object)((class_2520)section.method_10562("block_states").get())).promotePartial(stringx -> CustomChunkReader.logErrors(chunkPos, sectionTopY, stringx)).getOrThrow(class_2852.class_9314::new) : level.method_74142().method_74158();
                        Object biomeContainer = section.method_10545("biomes") ? (class_7522)codec.parse((DynamicOps)class_2509.field_11560, (Object)((class_2520)section.method_10562("biomes").get())).promotePartial(stringx -> CustomChunkReader.logErrors(chunkPos, sectionTopY, stringx)).getOrThrow(class_2852.class_9314::new) : level.method_74142().method_74160();
                        chunkSections[sectionIndex] = chunkSection = new class_2826(blockStateContainer, (class_7522)biomeContainer);
                    }
                    if (!lightOn || !section.method_10545("BlockLight")) continue;
                    byte[] lightsArray = (byte[])section.method_10547("BlockLight").get();
                    lights = new class_2804(lightsArray);
                }
                class_2818 chunkAccess = null;
                class_2487 heightmaps = null;
                EnumSet<class_2902.class_2903> heightmapEnums = null;
                try {
                    chunkAccess = new class_2818((class_1937)level, chunkPos, null, null, null, 0L, chunkSections, null, null);
                    chunkAccess.method_12020(lightOn);
                    Optional heightmapsOptional = chunkTag.method_10562("Heightmaps");
                    heightmapEnums = EnumSet.noneOf(class_2902.class_2903.class);
                    heightmaps = heightmapsOptional.isPresent() ? (class_2487)heightmapsOptional.get() : new class_2487();
                }
                catch (Exception e) {
                    throw new AutoMapChunkReaderException("Error creating LevelChunk during automap", e);
                }
                for (class_2902.class_2903 heightmapTypes : chunkAccess.method_12009().method_12160()) {
                    String key = heightmapTypes.method_12605();
                    if (heightmaps.method_10545(key)) {
                        chunkAccess.method_12037(heightmapTypes, (long[])heightmaps.method_10565(key).get());
                        continue;
                    }
                    heightmapEnums.add(heightmapTypes);
                }
                class_2902.method_16684((class_2791)chunkAccess, heightmapEnums);
                return new ProcessedChunk(chunkAccess, lights);
            }
            catch (Exception e) {
                Journeymap.getLogger().error("Error parsing chunk during automap >>", (Throwable)e);
            }
        }
        return null;
    }

    public static void logErrors(class_1923 chunkPos, int chunkSectionY, String errorMessage) {
        logger.error("Recoverable errors when loading section [{}, {}, {}]: {}", new Object[]{chunkPos.field_9181, chunkSectionY, chunkPos.field_9180, errorMessage});
    }

    static {
        logger = Journeymap.getLogger();
        BLOCK_STATE_CODEC = class_2841.method_44343((Codec)class_2680.field_24734, (class_6563)class_6563.method_74162((class_2359)class_2248.field_10651), (Object)class_2246.field_10124.method_9564());
    }

    static class AutoMapChunkReaderException
    extends RuntimeException {
        public AutoMapChunkReaderException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    public record ProcessedChunk(class_2818 chunk, class_2804 light) {
    }
}

