/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.component.popupscreenbutton.imageselect;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import journeymap.client.ui.component.SearchTextBox;
import journeymap.client.ui.component.popupscreenbutton.PopupButtonScreen;
import journeymap.client.ui.component.popupscreenbutton.colorpicker.ColorPickerButton;
import journeymap.client.ui.component.popupscreenbutton.colorpicker.ColorPickerScreen;
import journeymap.client.ui.component.popupscreenbutton.imageselect.ImageListSlot;
import journeymap.client.ui.component.popupscreenbutton.imageselect.ImageScrollListPane;
import journeymap.client.ui.component.popupscreenbutton.imageselect.ImageSlot;
import journeymap.client.ui.component.widgets.StringWidget;
import net.minecraft.class_11909;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_5244;
import net.minecraft.class_5348;
import net.minecraft.class_7847;
import net.minecraft.class_8021;
import net.minecraft.class_8667;

public class ImageSelectionScreen
extends PopupButtonScreen<Response> {
    private static final int PANE_WIDTH = 200;
    private static final int PANE_HEIGHT = 120;
    private SearchTextBox searchTextBox;
    private final class_2960 initialSelected;
    private ImageSlot selectedSlot;
    private final List<class_2960> icons;
    private final ImageScrollListPane<ImageListSlot> scrollPane;
    private List<ImageListSlot> imageListSlots;
    private List<ImageSlot> imageSlots;
    private int color;
    private String searchText = "";
    private final ImageSlot previewImage;

    public ImageSelectionScreen(class_2561 component, class_2960 initialSelected, List<class_2960> icons, int color) {
        super(component);
        this.field_22789 = class_310.method_1551().method_22683().method_4486();
        this.field_22790 = class_310.method_1551().method_22683().method_4502();
        this.color = color;
        this.icons = icons;
        this.initialSelected = initialSelected;
        this.scrollPane = new ImageScrollListPane(0, 0, 0, 0, 24);
        this.previewImage = new ImageSlot(this.initialSelected, 16, 16, this.color);
        this.imageListSlots = this.buildSlots();
        this.updateColor(this.color);
    }

    public void method_25426() {
        this.layout.method_52738((class_8021)new StringWidget((class_2561)this.method_25440().method_27661().method_27692(class_124.field_1075).method_27692(class_124.field_1073), this.field_22793), class_7847::method_46467);
        this.layout.method_52735(8);
        class_8667 contentLayout = class_8667.method_52741();
        contentLayout.method_52735(8);
        this.layout.method_52736((class_8021)contentLayout);
        class_8667 headerLayout = class_8667.method_52742();
        headerLayout.method_52735(10);
        this.searchTextBox = (SearchTextBox)headerLayout.method_52738((class_8021)new SearchTextBox("", this.field_22793, 70, 15), class_7847::method_46474);
        this.searchTextBox.method_1858(false);
        this.searchTextBox.setFillColor(0, 0.4f);
        this.searchTextBox.method_1863(this::updateSearch);
        headerLayout.method_52736((class_8021)new ColorPickerButton(20, 20, () -> this.color, this::updateWaypointColor));
        headerLayout.method_52738((class_8021)this.previewImage, class_7847::method_46474);
        this.previewImage.setOutline(true);
        contentLayout.method_52736((class_8021)headerLayout);
        class_8667 paneLayout = class_8667.method_52742();
        this.scrollPane.setSlots(this.imageListSlots);
        this.scrollPane.initSlots();
        paneLayout.method_52736(this.scrollPane);
        contentLayout.method_52736((class_8021)paneLayout);
        class_8667 bottomLayout = class_8667.method_52742();
        bottomLayout.method_52735(10);
        bottomLayout.method_52736((class_8021)class_4185.method_46430((class_2561)class_2561.method_43471((String)"jm.waypoint.save"), b -> this.exit(false)).method_46432(this.field_22793.method_27525((class_5348)class_5244.field_41873) + 10).method_46431());
        bottomLayout.method_52736((class_8021)class_4185.method_46430((class_2561)class_5244.field_24335, b -> this.exit(true)).method_46432(this.field_22793.method_27525((class_5348)class_5244.field_24335) + 10).method_46431());
        this.layout.method_52738((class_8021)bottomLayout, class_7847::method_46467);
        this.layout.method_48206(x$0 -> {
            class_339 cfr_ignored_0 = (class_339)this.method_37063((class_364)x$0);
        });
        this.scrollPane.visitSlots(x$0 -> {
            class_339 cfr_ignored_0 = (class_339)this.method_25429((class_364)x$0);
        });
        this.method_48640();
        this.scrollPane.updateSize(200, 120, paneLayout.method_46426(), paneLayout.method_46427());
    }

    private void exit(boolean cancel) {
        this.setResponseAndClose(new Response(this.selectedSlot.getImage(), this.color, cancel));
    }

    private void updateWaypointColor(ColorPickerScreen.ColorPickerResponse colorPickerResponse) {
        if (!colorPickerResponse.canceled()) {
            this.updateColor(colorPickerResponse.color());
        }
    }

    @Override
    protected void method_48640() {
        this.layout.method_48222();
        this.scrollPane.repositionSlots();
        this.scrollPane.updateSize(200, 120, 0, 0);
        super.method_48640();
    }

    private void updateColor(int color) {
        this.color = color;
        this.imageListSlots.forEach(slot -> slot.updateColor(color));
        this.previewImage.setColor(color);
    }

    private List<ImageListSlot> buildSlots() {
        ArrayList<ImageListSlot> slots = new ArrayList<ImageListSlot>();
        int columns = 8;
        ImageListSlot slot = new ImageListSlot();
        if (this.imageSlots == null) {
            this.imageSlots = new ArrayList<ImageSlot>();
            this.icons.forEach(icon -> {
                ImageSlot image = new ImageSlot((class_2960)icon, 16, 16, this.color);
                if (icon.equals((Object)this.initialSelected)) {
                    this.updateSelectedSlot(image);
                }
                this.imageSlots.add(image);
            });
        }
        List<ImageSlot> filteredSlots = this.getFilteredSlots();
        for (int i = 0; i < filteredSlots.size(); ++i) {
            ImageSlot image = filteredSlots.get(i);
            if (i % columns == 0) {
                slot = new ImageListSlot();
                slots.add(slot);
            }
            slot.addImage(image);
        }
        return slots;
    }

    private List<ImageSlot> getFilteredSlots() {
        Stream<Object> stream = this.imageSlots.stream();
        if (this.searchText != null && !this.searchText.isEmpty()) {
            stream = stream.filter(slot -> slot.fileName().toLowerCase().contains(this.searchText.toLowerCase()));
        }
        return stream.sorted(Comparator.comparing(ImageSlot::fileName)).toList();
    }

    private void updateSearch(String searchText) {
        if (!this.searchText.equals(searchText)) {
            this.searchText = searchText;
            this.updateSlots();
        }
    }

    private void updateSlots() {
        this.scrollPane.method_44382(0.0);
        this.scrollPane.visitSlots(x$0 -> this.method_37066((class_364)x$0));
        this.imageListSlots.clear();
        this.imageListSlots = this.buildSlots();
        this.scrollPane.setSlots(this.imageListSlots);
        this.scrollPane.initSlots();
        this.scrollPane.visitSlots(x$0 -> {
            class_339 cfr_ignored_0 = (class_339)this.method_25429((class_364)x$0);
        });
        this.scrollPane.updateSlots();
        this.scrollPane.repositionSlots();
    }

    public boolean method_25402(class_11909 event, boolean doubleClick) {
        Optional slot;
        if (this.scrollPane.method_25405(event.comp_4798(), event.comp_4799()) && (slot = this.scrollPane.method_19355(event.comp_4798(), event.comp_4799())).isPresent()) {
            ImageListSlot clickedSlot = (ImageListSlot)((Object)slot.get());
            Optional<class_364> childSlot = clickedSlot.method_19355(event.comp_4798(), event.comp_4799());
            childSlot.ifPresent(guiEventListener -> this.updateSelectedSlot((ImageSlot)guiEventListener));
        }
        return super.method_25402(event, doubleClick);
    }

    private void updateSelectedSlot(ImageSlot slot) {
        if (this.selectedSlot != null) {
            this.selectedSlot.setOutline(false);
        }
        this.previewImage.setImage(slot.getImage());
        this.selectedSlot = slot;
        slot.setOutline(true);
    }

    public record Response(class_2960 resourceLocation, int color, boolean cancelled) {
    }
}

