/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.option;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import journeymap.client.Constants;
import journeymap.client.properties.ClientCategory;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.texture.TextureCache;
import journeymap.client.ui.component.Slot;
import journeymap.client.ui.component.buttons.Button;
import journeymap.client.ui.dialog.FullscreenActions;
import journeymap.client.ui.option.ButtonListSlot;
import journeymap.client.ui.option.SlotMetadata;
import journeymap.common.properties.catagory.Category;
import net.minecraft.class_11905;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;

public class CategorySlot
extends Slot
implements Comparable<CategorySlot> {
    final class_2960 curseforgeTexutre = TextureCache.CurseForge;
    final class_2960 modrinthTexture = TextureCache.Modrinth;
    class_310 mc = class_310.method_1551();
    SlotMetadata metadata;
    Category category;
    Button button;
    int currentListWidth;
    int currentColumns;
    int currentColumnWidth;
    SlotMetadata masterSlot;
    SlotMetadata currentTooltip;
    List<SlotMetadata> childMetadataList = new LinkedList<SlotMetadata>();
    List<Slot> childSlots = new ArrayList<Slot>();
    protected class_2960 glyphIcon = TextureCache.ARROW_GLYPH;
    protected class_2960 disabledGlyphIcon = TextureCache.X_SPRITE.comp_1604();
    private boolean selected;
    private boolean enabled = true;
    Button cfWebMapDownloadButton;
    Button mdWebMapDownloadButton;

    public CategorySlot(Category category) {
        this.category = category;
        boolean advanced = category == ClientCategory.Advanced || category == ClientCategory.AdvancedMapRendering;
        this.button = new Button(category.getLabel());
        this.cfWebMapDownloadButton = new Button("", button -> FullscreenActions.launchWebMapDownloadWebsite("https://www.curseforge.com/minecraft/mc-mods/journeymap-web-map"));
        this.mdWebMapDownloadButton = new Button("", button -> FullscreenActions.launchWebMapDownloadWebsite("https://modrinth.com/mod/journeymap-web-map"));
        this.metadata = new SlotMetadata(this.button, category.getLabel(), category.getTooltip(), advanced);
        this.updateButtonLabel();
    }

    public CategorySlot add(Slot slot) {
        if (this.enabled) {
            this.childSlots.add(slot);
            this.childMetadataList.addAll(slot.getMetadata());
            for (SlotMetadata slotMetadata : slot.getMetadata()) {
                if (!slotMetadata.isMasterPropertyForCategory()) continue;
                this.masterSlot = slotMetadata;
            }
        }
        return this;
    }

    public void clear() {
        this.childSlots.clear();
    }

    public int size() {
        return this.childSlots.size();
    }

    public void sort() {
        Collections.sort(this.childMetadataList);
    }

    @Override
    public int getColumnWidth() {
        int columnWidth = 100;
        for (Slot slot : this.childSlots) {
            columnWidth = Math.max(columnWidth, slot.getColumnWidth());
        }
        return columnWidth;
    }

    public List<Slot> getChildSlots(int listWidth, int columnWidth) {
        if (!this.selected || !this.enabled) {
            return Collections.EMPTY_LIST;
        }
        int columns = listWidth / (columnWidth + ButtonListSlot.hgap);
        if (columnWidth == this.currentColumnWidth && columns == this.currentColumns || columns == 0) {
            return this.childSlots;
        }
        this.currentListWidth = listWidth;
        this.currentColumnWidth = columnWidth;
        this.currentColumns = columns;
        this.childSlots.clear();
        this.sort();
        ArrayList<SlotMetadata> remaining = new ArrayList<SlotMetadata>(this.childMetadataList);
        while (!remaining.isEmpty()) {
            ButtonListSlot row = new ButtonListSlot(this);
            SlotMetadata.ValueType lastType = null;
            for (int i = 0; i < columns && !remaining.isEmpty(); ++i) {
                SlotMetadata.ValueType thisType = remaining.get((int)0).valueType;
                if (lastType == null && thisType == SlotMetadata.ValueType.Toolbar) {
                    row.addAll(remaining);
                    remaining.clear();
                    break;
                }
                if (lastType != null && lastType != thisType && (thisType == SlotMetadata.ValueType.Toolbar || lastType == SlotMetadata.ValueType.Boolean && remaining.size() > columns - i)) break;
                SlotMetadata column = remaining.remove(0);
                lastType = column.valueType;
                row.add(column);
            }
            row.buttons.setWidths(columnWidth);
            this.childSlots.add(row);
        }
        return this.childSlots;
    }

    public Collection<SlotMetadata> getMetadata() {
        return Arrays.asList(this.metadata);
    }

    public List<SlotMetadata> getAllChildMetadata() {
        return this.childMetadataList;
    }

    public int getCurrentColumns() {
        return this.currentColumns;
    }

    public int getCurrentColumnWidth() {
        return this.currentColumnWidth;
    }

    public void method_25343(class_332 graphics, int mouseX, int mouseY, boolean hovered, float partialTick) {
        int x = this.method_73380();
        int y = this.method_73382();
        int rowWidth = this.method_73387();
        int itemHeight = this.method_73384();
        this.button.method_25358(rowWidth);
        this.button.setScrollablePosition(x, y);
        this.button.method_53533(itemHeight);
        this.button.method_25394(graphics, mouseX, mouseY, 0.0f);
        DrawUtil.drawRectangle(graphics, this.button.method_46426() + 4, this.button.getMiddleY() - 5, 11.0, 10.0, 0, 0.2f);
        if (this.enabled) {
            DrawUtil.drawClampedTexture(graphics, this.glyphIcon, this.button.getLabelColor(), 1.0f, this.button.method_46426() + (this.selected ? 5 : 6), (float)this.button.getMiddleY() - 4.0f, 32.0, 32.0, 0.25f, this.selected ? 90.0 : 0.0);
        } else {
            DrawUtil.drawClampedTexture(graphics, this.disabledGlyphIcon, 0xFF0000, 1.0f, this.button.method_46426() + 4, (float)this.button.getMiddleY() - 5.6f, 32.0, 32.0, 0.35f, this.selected ? 90.0 : 0.0);
            if (ClientCategory.WebMap.equals(this.category)) {
                int labelWidth = class_310.method_1551().field_1772.method_1727(this.button.getLabel());
                int labelStart = this.button.getCenterX() - labelWidth / 2 - (itemHeight - 4);
                int labelEnd = this.button.getCenterX() + labelWidth / 2;
                this.renderWebMapDownloadButtons(graphics, this.cfWebMapDownloadButton, this.curseforgeTexutre, itemHeight, mouseX, mouseY, labelStart - 10, this.button.method_46427() + 2);
                this.renderWebMapDownloadButtons(graphics, this.mdWebMapDownloadButton, this.modrinthTexture, itemHeight, mouseX, mouseY, labelEnd + 10, this.button.method_46427() + 2);
            }
        }
        if (this.masterSlot != null && this.selected) {
            boolean enabled = this.masterSlot.button.method_37303();
            for (Slot slot : this.childSlots) {
                slot.setEnabled(enabled);
            }
        }
        this.currentTooltip = null;
        if (!this.enabled && ClientCategory.WebMap.equals(this.category) && this.cfWebMapDownloadButton.mouseOver(mouseX, mouseY)) {
            this.currentTooltip = new SlotMetadata(this.cfWebMapDownloadButton, Constants.getString("jm.common.curseforge"), "https://www.curseforge.com/minecraft/mc-mods/journeymap-web-map", false);
        } else if (!this.enabled && ClientCategory.WebMap.equals(this.category) && this.mdWebMapDownloadButton.mouseOver(mouseX, mouseY)) {
            this.currentTooltip = new SlotMetadata(this.mdWebMapDownloadButton, Constants.getString("jm.common.modrinth"), "https://modrinth.com/mod/journeymap-web-map", false);
        } else if (this.button.mouseOver(mouseX, mouseY)) {
            this.currentTooltip = this.metadata;
        }
    }

    private void renderWebMapDownloadButtons(class_332 graphics, Button button, class_2960 texture, int slotHeight, int mouseX, int mouseY, int pozX, int pozY) {
        button.setDefaultStyle(false);
        button.setDrawBackground(false);
        button.setDrawFrame(true);
        button.setScrollablePosition(pozX, pozY);
        button.method_53533(slotHeight - 4);
        button.method_25358(slotHeight - 4);
        button.method_25394(graphics, mouseX, mouseY, 0.0f);
        DrawUtil.drawTexture(graphics, texture, button.method_46426() + 1, button.method_46427() + 1, button.method_25364() - 2, button.method_25368() - 2, false, 0.0);
        if (button.mouseOver(mouseX, mouseY)) {
            DrawUtil.drawRectangle(graphics, button.method_46426(), button.method_46427(), button.method_25364(), button.method_25368(), 65280, 0.15f);
        }
    }

    public boolean method_25405(double x, double y) {
        return super.method_25405(x, y);
    }

    private void updateButtonLabel() {
        this.button.method_25355((class_2561)Constants.getStringTextComponent(this.category.getLabel()));
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public boolean method_25402(class_11909 event, boolean doubleClick) {
        if (event.method_74245() == 0) {
            if (this.enabled) {
                boolean pressed = this.button.method_25402(event, doubleClick);
                if (pressed) {
                    this.setSelected(!this.selected);
                    this.updateButtonLabel();
                }
                return pressed;
            }
            if (ClientCategory.WebMap.equals(this.category) && this.cfWebMapDownloadButton.mouseOver(event.comp_4798(), event.comp_4799())) {
                return this.cfWebMapDownloadButton.method_25402(event, doubleClick);
            }
            if (ClientCategory.WebMap.equals(this.category) && this.mdWebMapDownloadButton.mouseOver(event.comp_4798(), event.comp_4799())) {
                return this.mdWebMapDownloadButton.method_25402(event, doubleClick);
            }
        }
        return false;
    }

    public boolean method_25403(class_11909 event, double mouseDX, double mouseDY) {
        return false;
    }

    public boolean method_25406(class_11909 event) {
        return this.button.method_25406(event);
    }

    public boolean method_25400(class_11905 event) {
        return false;
    }

    public boolean method_25404(class_11908 event) {
        return false;
    }

    @Override
    public int compareTo(CategorySlot other) {
        return this.category.compareTo(other.category);
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        this.button.setEnabled(enabled);
    }

    public SlotMetadata getLastPressed() {
        return this.metadata;
    }

    public SlotMetadata getCurrentTooltip() {
        return this.currentTooltip;
    }

    public boolean contains(SlotMetadata slotMetadata) {
        return this.childMetadataList.contains(slotMetadata);
    }

    public Category getCategory() {
        return this.category;
    }
}

