/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.properties.config;

import journeymap.common.properties.catagory.Category;
import journeymap.common.properties.config.ConfigField;

public class DoubleField
extends ConfigField<Double> {
    public static final String ATTR_MIN = "min";
    public static final String ATTR_MAX = "max";
    public static final String ATTR_INC_VAL = "inc";
    public static final String PRECISION = "precision";

    protected DoubleField() {
    }

    public DoubleField(Category category, String key, double minValue, double maxValue, double defaultValue) {
        this(category, key, minValue, maxValue, defaultValue, 0.1f, 2);
    }

    public DoubleField(Category category, String key, double minValue, double maxValue, double defaultValue, double incrementValue, int precision) {
        this(category, key, minValue, maxValue, defaultValue, incrementValue, precision, 100);
    }

    public DoubleField(Category category, String key, double minValue, double maxValue, double defaultValue, double incrementValue, int precision, int sortOrder) {
        super(category, key);
        this.range(minValue, maxValue);
        this.defaultValue(defaultValue);
        this.setToDefault();
        this.sortOrder(sortOrder);
        this.setIncrementValue(incrementValue);
        this.setPrecision(precision);
    }

    public DoubleField(Category category, String key, double minValue, double maxValue, double defaultValue, int sortOrder) {
        super(category, key);
        this.range(minValue, maxValue);
        this.defaultValue(defaultValue);
        this.setToDefault();
        this.sortOrder(sortOrder);
        this.setIncrementValue(0.1f);
        this.setPrecision(2);
    }

    @Override
    public Double getDefaultValue() {
        return this.getDoubleAttr("default");
    }

    @Override
    public Double get() {
        return this.getDoubleAttr("value");
    }

    @Override
    public boolean validate(boolean fix) {
        boolean valid = super.validate(fix);
        valid = this.require(ATTR_MIN, ATTR_MAX) && valid;
        Double value = this.get();
        if (value == null || !(value >= this.getMinValue()) || !(value <= this.getMaxValue())) {
            if (fix) {
                this.setToDefault();
            } else {
                valid = false;
            }
        }
        return valid;
    }

    private void setPrecision(int precision) {
        this.put(PRECISION, precision);
    }

    private void setIncrementValue(double value) {
        this.put(ATTR_INC_VAL, value);
    }

    public DoubleField range(double min, double max) {
        this.put(ATTR_MIN, min);
        this.put(ATTR_MAX, max);
        return this;
    }

    public double getMinValue() {
        return this.getDoubleAttr(ATTR_MIN);
    }

    public double getMaxValue() {
        return this.getDoubleAttr(ATTR_MAX);
    }

    public double getIncrementValue() {
        return this.getDoubleAttr(ATTR_INC_VAL);
    }

    public int getPrecision() {
        return this.getIntegerAttr(PRECISION);
    }
}

