/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client;

import journeymap.client.JourneymapClient;
import journeymap.client.event.NeoForgeEventHandlerManager;
import journeymap.client.event.NeoForgeKeyEvents;
import journeymap.client.event.handlers.ResourceReloadHandler;
import journeymap.common.Journeymap;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.neoforged.neoforge.client.event.AddClientReloadListenersEvent;

@OnlyIn(value=Dist.CLIENT)
public class JourneymapClientNeoForge {
    private final NeoForgeKeyEvents keyEvents;
    private final JourneymapClient client;
    static JourneymapClientNeoForge instance;

    public JourneymapClientNeoForge(IEventBus eventBus) {
        instance = this;
        this.client = new JourneymapClient();
        this.keyEvents = new NeoForgeKeyEvents();
        this.client.setKeyEvents(this.keyEvents);
        eventBus.addListener(this::commonSetupEvent);
        eventBus.addListener(this::clientSetupEvent);
        eventBus.addListener(this::loadCompleteEvent);
        eventBus.addListener(this.keyEvents::onKeyRegisterEvent);
        eventBus.addListener(this::onResourceReloadEvent);
    }

    public void commonSetupEvent(FMLCommonSetupEvent event) {
        this.client.commonSetup();
    }

    public void onResourceReloadEvent(AddClientReloadListenersEvent event) {
        ResourceReloadHandler.getInstance().getOnResourceReloadHandlers().forEach((arg_0, arg_1) -> ((AddClientReloadListenersEvent)event).addListener(arg_0, arg_1));
    }

    public void clientSetupEvent(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            Journeymap.getLogger().info("Journeymap Initializing");
            NeoForgeEventHandlerManager.registerHandlers();
            this.client.init();
        });
    }

    public void loadCompleteEvent(FMLLoadCompleteEvent event) {
        event.enqueueWork(() -> {
            Journeymap.getLogger().info("Journeymap PostInit");
            this.client.postInit();
        });
    }

    public static JourneymapClientNeoForge getInstance() {
        return instance;
    }

    public NeoForgeKeyEvents getKeyEvents() {
        return this.keyEvents;
    }
}

