/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.model.entity;

import com.google.common.cache.CacheLoader;
import com.google.common.collect.Lists;
import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import com.google.gson.JsonObject;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import journeymap.api.v2.client.entity.WrappedEntity;
import journeymap.api.v2.client.util.tuple.Tuple2;
import journeymap.client.JourneymapClient;
import journeymap.client.cartography.color.RGB;
import journeymap.client.model.entity.EntityHelper;
import journeymap.client.properties.CoreProperties;
import journeymap.client.render.draw.MobIconCache;
import journeymap.common.Journeymap;
import journeymap.common.helper.DimensionHelper;
import journeymap.common.log.LogFormatter;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.StringUtil;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ambient.AmbientCreature;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.animal.horse.Horse;
import net.minecraft.world.entity.npc.Npc;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.PlayerTeam;

public class EntityDTO
implements WrappedEntity,
Serializable {
    public final String entityId;
    public transient WeakReference<Entity> entityRef;
    public transient ResourceLocation entityTextureLocation;
    public transient ResourceLocation entityIconLocation;
    public transient ResourceLocation entityTypeLocation;
    public transient boolean hasCustomIcon = false;
    public transient boolean drawOutline = true;
    public String iconLocation;
    public Boolean hostile;
    public Boolean aggro;
    public double posX;
    public double posY;
    public double posZ;
    public int chunkCoordX;
    public int chunkCoordY;
    public int chunkCoordZ;
    private BlockPos chunkPos;
    public double heading;
    private Component customName;
    public String serializedCustomName;
    public String owner;
    public String profession;
    public String username;
    public String biome;
    public ResourceKey<Level> dimension;
    public Boolean underground;
    public boolean invisible;
    public boolean sneaking;
    public boolean passiveAnimal;
    public boolean ambientCreature;
    public boolean npc;
    public int color;
    public int labelColor;
    private List<Component> entityToolTips;
    private List<String> serializedTooltips;
    public boolean disabled = false;

    private EntityDTO(Entity entity) {
        this.entityRef = new WeakReference<Entity>(entity);
        this.entityId = entity.getUUID().toString();
    }

    public void update(LivingEntity entity, boolean hostile) {
        AbstractHorse horse;
        LivingEntity attackTarget;
        Entity ownerEntity;
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer currentPlayer = Minecraft.getInstance().player;
        this.dimension = DimensionHelper.getDimension((Entity)entity);
        this.posX = entity.position().x();
        this.posY = entity.position().y();
        this.posZ = entity.position().z();
        this.chunkCoordX = entity.chunkPosition().x;
        this.chunkCoordY = entity.getBlockY() >> 4;
        this.chunkCoordZ = entity.chunkPosition().z;
        this.chunkPos = new BlockPos(this.chunkCoordX, this.chunkCoordY, this.chunkCoordZ);
        this.heading = Math.round(entity.getYRot() % 360.0f);
        this.disabled = false;
        this.customName = null;
        this.serializedCustomName = null;
        this.entityToolTips = null;
        this.ambientCreature = false;
        this.passiveAnimal = false;
        this.hasCustomIcon = false;
        this.drawOutline = true;
        this.invisible = currentPlayer != null ? entity.isInvisibleTo((Player)currentPlayer) : false;
        this.sneaking = entity.isShiftKeyDown();
        CoreProperties coreProperties = JourneymapClient.getInstance().getCoreProperties();
        int playerColor = coreProperties.getColor(coreProperties.colorPlayer);
        this.entityIconLocation = null;
        this.iconLocation = null;
        PlayerTeam team = null;
        try {
            team = mc.level.getScoreboard().getPlayersTeam(entity.getStringUUID());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (entity instanceof Player) {
            this.username = StringUtil.stripColor((String)entity.getName().getString());
            try {
                playerColor = team != null ? team.getColor().getId() : (currentPlayer.equals((Object)entity) ? coreProperties.getColor(coreProperties.colorSelf) : coreProperties.getColor(coreProperties.colorPlayer));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.entityIconLocation = DefaultPlayerSkin.getDefaultTexture();
            try {
                ClientPacketListener client = Minecraft.getInstance().getConnection();
                PlayerInfo info = client.getPlayerInfo(entity.getUUID());
                if (info != null) {
                    this.entityIconLocation = info.getSkin().texture();
                }
            }
            catch (Throwable t) {
                Journeymap.getLogger().error("Error looking up player skin: " + LogFormatter.toPartialString(t));
            }
        } else {
            this.username = null;
            EntityHelper.IconData iconLoc = EntityHelper.getIconData((Entity)entity);
            if (!this.hasCustomIcon && iconLoc != null) {
                Tuple2<ResourceLocation, DynamicTexture> icon;
                this.entityTextureLocation = iconLoc.texture;
                this.entityIconLocation = iconLoc.icon;
                this.entityTypeLocation = iconLoc.type;
                if (this.entityIconLocation != null && (icon = MobIconCache.getMobIcon(this, this.drawOutline)) != null) {
                    this.iconLocation = ((ResourceLocation)icon.a()).toString();
                }
            }
        }
        if ((ownerEntity = this.getTamedOwner((Entity)entity)) != null) {
            this.owner = ownerEntity.getName().getString();
        }
        Component customName = null;
        boolean passive = false;
        LivingEntity entityLiving = entity;
        if (entity.hasCustomName() && entityLiving.shouldShowName()) {
            customName = entity.getCustomName();
        }
        this.aggro = false;
        if (currentPlayer != null && (attackTarget = entity.getKillCredit()) != null && attackTarget.getUUID().equals(currentPlayer.getUUID())) {
            this.aggro = true;
        }
        if (EntityHelper.isPassive(entity)) {
            passive = true;
        }
        if (entity instanceof Villager) {
            Villager villager = (Villager)entity;
            this.profession = BuiltInRegistries.VILLAGER_PROFESSION.getKey((Object)((VillagerProfession)villager.getVillagerData().profession().value())).getPath();
        } else if (entity instanceof Npc) {
            this.npc = true;
            this.profession = null;
            this.passiveAnimal = false;
        } else if (entity instanceof AmbientCreature) {
            this.ambientCreature = true;
        } else {
            this.profession = null;
            this.passiveAnimal = passive;
        }
        if (customName != null) {
            this.setCustomName(customName);
        }
        this.hostile = hostile || this.aggro != false;
        if (entity instanceof Player) {
            this.labelColor = coreProperties.getColor(coreProperties.colorPlayerLabel);
            this.color = playerColor;
        } else if (team != null) {
            this.labelColor = 0xFFFFFF;
            this.color = team.getColor().getId();
        } else if (this.owner != null || entityLiving instanceof AbstractHorse && (horse = (AbstractHorse)entityLiving).isTamed()) {
            this.labelColor = coreProperties.getColor(coreProperties.colorPetLabel);
            this.color = coreProperties.getColor(coreProperties.colorPet);
        } else if (this.profession != null || this.npc) {
            this.labelColor = coreProperties.getColor(coreProperties.colorVillagerLabel);
            this.color = coreProperties.getColor(coreProperties.colorVillager);
        } else if (hostile) {
            this.labelColor = coreProperties.getColor(coreProperties.colorHostileLabel);
            this.color = coreProperties.getColor(coreProperties.colorHostile);
        } else {
            this.labelColor = coreProperties.getColor(coreProperties.colorPassiveLabel);
            this.color = coreProperties.getColor(coreProperties.colorPassive);
        }
    }

    private Entity getTamedOwner(Entity livingEntity) {
        LocalPlayer currentPlayer = Minecraft.getInstance().player;
        if (livingEntity instanceof TamableAnimal) {
            LivingEntity ownerEntity = ((TamableAnimal)livingEntity).getOwner();
            if (ownerEntity != null) {
                return ownerEntity;
            }
        } else if (livingEntity instanceof Horse && ((Horse)livingEntity).getOwner() != null) {
            LivingEntity ownerEntity = ((Horse)livingEntity).getOwner();
            if (currentPlayer != null && ownerEntity != null) {
                try {
                    UUID ownerUuid = ownerEntity.getUUID();
                    String playerUuid = currentPlayer.getUUID().toString();
                    if (playerUuid.equals(ownerUuid.toString())) {
                        return currentPlayer;
                    }
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }
        return null;
    }

    public String getEntityId() {
        return this.entityId;
    }

    public WeakReference<Entity> getEntityRef() {
        return this.entityRef;
    }

    public ResourceLocation getEntityIconLocation() {
        return this.entityIconLocation;
    }

    public Boolean getHostile() {
        return this.hostile;
    }

    public Boolean getAggro() {
        return this.aggro;
    }

    public Vec3 getPosition() {
        return ((Entity)this.entityRef.get()).position();
    }

    public BlockPos getChunkPos() {
        return this.chunkPos;
    }

    public double getHeading() {
        return this.heading;
    }

    public Component getCustomName() {
        return this.customName;
    }

    public Entity getOwner() {
        return this.getTamedOwner((Entity)this.entityRef.get());
    }

    public String getProfession() {
        return this.profession;
    }

    public String getPlayerName() {
        return this.username;
    }

    public Biome getBiome() {
        return (Biome)Minecraft.getInstance().level.getBiome(((Entity)this.entityRef.get()).blockPosition()).value();
    }

    public ResourceKey<Level> getDimension() {
        return this.dimension;
    }

    public Boolean getUnderground() {
        return this.underground;
    }

    public boolean isInvisible() {
        return this.invisible;
    }

    public boolean isSneaking() {
        return this.sneaking;
    }

    public boolean isPassiveAnimal() {
        return this.passiveAnimal;
    }

    public boolean isAmbientCreature() {
        return this.ambientCreature;
    }

    public boolean isNpc() {
        return this.npc;
    }

    public int getColor() {
        return this.color;
    }

    public int getLabelColor() {
        return this.labelColor;
    }

    public void setLabelColor(int labelColor) {
        this.labelColor = labelColor;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public void setCustomName(String customName) {
        MutableComponent name = null;
        if (customName != null) {
            name = Component.literal((String)customName);
        }
        this.setCustomName((Component)name);
    }

    public void setCustomName(Component customName) {
        if (customName != null) {
            this.customName = customName;
            this.serializedCustomName = this.serializeComponentForWeb(customName);
        } else {
            this.customName = null;
            this.serializedCustomName = null;
        }
    }

    public void setColor(int color) {
        this.color = color;
    }

    public void setDisable(boolean disable) {
        this.disabled = disable;
    }

    public void setDrawOutline(boolean drawOutline) {
        this.drawOutline = drawOutline;
    }

    public void setEntityIconLocation(ResourceLocation entityIconLocation) {
        this.hasCustomIcon = true;
        this.entityIconLocation = entityIconLocation;
        this.iconLocation = entityIconLocation.toString();
    }

    public List<Component> getEntityToolTips() {
        return this.entityToolTips;
    }

    public void setEntityToolTips(List<Component> entityToolTips) {
        this.entityToolTips = entityToolTips;
        if (this.serializedTooltips == null) {
            this.serializedTooltips = new ArrayList<String>();
        }
        this.serializedTooltips.clear();
        entityToolTips.forEach(component -> this.serializedTooltips.add(this.serializeComponentForWeb((Component)component)));
    }

    private String serializeComponentForWeb(Component component) {
        MutableComponent mutableComponent;
        if (component instanceof MutableComponent && (mutableComponent = (MutableComponent)component).getStyle().getColor() != null) {
            String color = RGB.toHexString(mutableComponent.getStyle().getColor().getValue());
            JsonObject object = GsonHelper.parse((String)Component.Serializer.toJson((Component)component, (HolderLookup.Provider)((Entity)this.entityRef.get()).level().registryAccess()));
            if (object.has("color")) {
                object.addProperty("color", color);
                return object.toString();
            }
        }
        return Component.Serializer.toJson((Component)component, (HolderLookup.Provider)((Entity)this.entityRef.get()).level().registryAccess());
    }

    public static class EntityDTOExclusionStrategy
    implements ExclusionStrategy {
        List<String> excludedFields = Lists.newArrayList((Object[])new String[]{"customName", "chunkPos", "entityToolTips", "dimension"});

        public boolean shouldSkipField(FieldAttributes f) {
            if (f.getDeclaringClass().equals(EntityDTO.class)) {
                return this.excludedFields.contains(f.getName());
            }
            return false;
        }

        public boolean shouldSkipClass(Class<?> clazz) {
            return false;
        }
    }

    public static class SimpleCacheLoader
    extends CacheLoader<Entity, EntityDTO> {
        public EntityDTO load(Entity entity) throws Exception {
            return new EntityDTO(entity);
        }
    }
}

