/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.render;

import com.mojang.blaze3d.opengl.GlTexture;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.GpuTexture;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.VertexFormat;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.OptionalDouble;
import journeymap.api.client.impl.ClientAPI;
import journeymap.api.v2.client.display.Context;
import journeymap.client.JourneymapClient;
import journeymap.client.render.Pipelines;
import journeymap.client.render.RegionTileShaders;
import journeymap.client.render.RenderWrapper;
import journeymap.client.texture.RegionTexture;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.TriState;

public class JMRenderTypes
extends RenderType {
    public static final ResourceLocation WAYPOINT_DEFAULT_BEAM = ResourceLocation.parse((String)"textures/entity/beacon_beam.png");
    static final Object2ObjectOpenHashMap<ResourceLocation, RenderType> GRID_LINES_RENDER_TYPE_MAP = new Object2ObjectOpenHashMap();
    static final Int2ObjectOpenHashMap<Int2ObjectOpenHashMap<RenderType>> REGION_TILE_RENDER_TYPE_MAP = new Int2ObjectOpenHashMap();
    static final Int2ObjectOpenHashMap<RenderType> ICON_RENDER_TYPE_MAP = new Int2ObjectOpenHashMap();
    static final Int2ObjectOpenHashMap<RenderType> ICON_CLAMP_RENDER_TYPE_MAP = new Int2ObjectOpenHashMap();
    static final Int2ObjectOpenHashMap<RenderType> ICON_NOBLUR_RENDER_TYPE_MAP = new Int2ObjectOpenHashMap();
    static final Int2ObjectOpenHashMap<RenderType> ICON_UNMASKED_RENDER_TYPE_MAP = new Int2ObjectOpenHashMap();
    static final Int2ObjectOpenHashMap<RenderType> POLYGON_WITH_TEXTURE_RENDER_TYPE_MAP = new Int2ObjectOpenHashMap();
    protected static final RenderStateShard.TexturingStateShard GRID_LINES_TRANSPARENCY = new RenderStateShard.TexturingStateShard("grid_lines_transparency", () -> {
        RenderWrapper.enableBlend();
        RenderWrapper.blendFuncSeparate(770, 771, 1, 771);
        RenderWrapper.texParameter(3553, 10241, 9728);
        RenderWrapper.texParameter(3553, 10240, 9728);
        RenderWrapper.texParameter(3553, 10242, 10497);
        RenderWrapper.texParameter(3553, 10243, 10497);
    }, () -> {
        RenderWrapper.disableBlend();
        RenderWrapper.defaultBlendFunc();
    });
    protected static final RenderStateShard.TexturingStateShard MINIMAP_MASK_TRANSPARENCY = new RenderStateShard.TexturingStateShard("minimap_mask_texturing", () -> RenderSystem.getDevice().createCommandEncoder().clearDepthTexture(Minecraft.getInstance().getMainRenderTarget().getDepthTexture(), 0.0), () -> RenderWrapper.depthFunc(515));
    protected static final RenderStateShard.LayeringStateShard ICON_TRANSPARENCY = new RenderStateShard.LayeringStateShard("icon_transparency", () -> {
        RenderWrapper.enableBlend();
        RenderWrapper.blendFuncSeparate(770, 771, 1, 0);
    }, () -> {
        RenderWrapper.disableBlend();
        RenderWrapper.defaultBlendFunc();
    });
    protected static final RenderStateShard.LayeringStateShard POLYGON_TRANSPARENCY = new RenderStateShard.LayeringStateShard("polygon_transparency", () -> {
        RenderWrapper.enableBlend();
        RenderWrapper.blendFuncSeparate(770, 771, 1, 0);
        RenderWrapper.texParameter(3553, 10241, 9728);
        RenderWrapper.texParameter(3553, 10240, 9728);
        RenderWrapper.texParameter(3553, 10242, 10497);
        RenderWrapper.texParameter(3553, 10243, 10497);
    }, () -> {
        RenderWrapper.disableBlend();
        RenderWrapper.defaultBlendFunc();
    });
    public static final RenderType MINIMAP_RECTANGLE_MASK_RENDER_TYPE = JMRenderTypes.create((String)"minimap_rectangle_mask", (int)256, (boolean)false, (boolean)false, (RenderPipeline)Pipelines.MINIMAP_RECTANGLE_MASK_RENDER_PIPELINE, (RenderType.CompositeState)RenderType.CompositeState.builder().setTextureState(NO_TEXTURE).setLineState(new RenderStateShard.LineStateShard(OptionalDouble.empty())).setLayeringState(NO_LAYERING).setLightmapState(NO_LIGHTMAP).setTexturingState(MINIMAP_MASK_TRANSPARENCY).createCompositeState(false));
    public static final RenderType BEAM_RENDER_TYPE = JMRenderTypes.create((String)"waypoint_beam", (int)256, (boolean)false, (boolean)false, (RenderPipeline)Pipelines.WAYPOINT_BEAM_RENDER_PIPELINE, (RenderType.CompositeState)RenderType.CompositeState.builder().setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(WAYPOINT_DEFAULT_BEAM, TriState.TRUE, false)).setLineState(new RenderStateShard.LineStateShard(OptionalDouble.empty())).setLayeringState(NO_LAYERING).setLightmapState(LIGHTMAP).createCompositeState(false));
    public static final RenderType RECTANGLE_RENDER_TYPE = JMRenderTypes.create((String)"rectangle", (int)256, (boolean)false, (boolean)false, (RenderPipeline)Pipelines.RECTANGLE_RENDER_PIPELINE, (RenderType.CompositeState)RenderType.CompositeState.builder().setTextureState(NO_TEXTURE).setLineState(new RenderStateShard.LineStateShard(OptionalDouble.empty())).setLayeringState(NO_LAYERING).setLightmapState(NO_LIGHTMAP).createCompositeState(false));
    public static final RenderType GRID_LINES_RENDER_TYPE = JMRenderTypes.create((String)"grid_lines", (int)256, (boolean)false, (boolean)true, (RenderPipeline)Pipelines.GRID_LINES_RENDER_PIPELINE, (RenderType.CompositeState)RenderType.CompositeState.builder().setTextureState(NO_TEXTURE).setLineState(new RenderStateShard.LineStateShard(OptionalDouble.of(1.0))).setLayeringState(NO_LAYERING).setLightmapState(NO_LIGHTMAP).createCompositeState(false));
    public static final RenderType POLYGON_WITHOUT_TEXTURE_RENDER_TYPE = JMRenderTypes.create((String)"polygon", (int)256, (boolean)false, (boolean)false, (RenderPipeline)Pipelines.POLYGON_POS_PIPELINE, (RenderType.CompositeState)RenderType.CompositeState.builder().setTextureState(NO_TEXTURE).setLineState(new RenderStateShard.LineStateShard(OptionalDouble.empty())).setLayeringState(NO_LAYERING).setLightmapState(NO_LIGHTMAP).createCompositeState(false));
    public static final RenderType POLYGON_STROKE_RENDER_TYPE = JMRenderTypes.create((String)"polygon_stroke", (int)256, (boolean)false, (boolean)false, (RenderPipeline)Pipelines.POLYGON_STROKE_PIPELINE, (RenderType.CompositeState)RenderType.CompositeState.builder().setTextureState(NO_TEXTURE).setLineState(new RenderStateShard.LineStateShard(OptionalDouble.empty())).setLayeringState(NO_LAYERING).setLightmapState(NO_LIGHTMAP).createCompositeState(false));

    public static void registerMapShader(String key, RenderPipeline shader) {
        REGION_TILE_RENDER_TYPE_MAP.clear();
    }

    public static void registerPosTexColorShader() {
        POLYGON_WITH_TEXTURE_RENDER_TYPE_MAP.clear();
        ICON_UNMASKED_RENDER_TYPE_MAP.clear();
        ICON_NOBLUR_RENDER_TYPE_MAP.clear();
        ICON_RENDER_TYPE_MAP.clear();
        ICON_CLAMP_RENDER_TYPE_MAP.clear();
        REGION_TILE_RENDER_TYPE_MAP.clear();
        GRID_LINES_RENDER_TYPE_MAP.clear();
    }

    public JMRenderTypes(String name, int bufferSize, boolean useDelegate, boolean needsSorting, Runnable pre, Runnable post) {
        super(name, bufferSize, useDelegate, needsSorting, pre, post);
    }

    public void draw(MeshData meshData) {
    }

    public RenderTarget getRenderTarget() {
        return null;
    }

    public RenderPipeline getRenderPipeline() {
        return null;
    }

    public VertexFormat format() {
        return null;
    }

    public VertexFormat.Mode mode() {
        return null;
    }

    public static void clearRegionRenderTypes(int id) {
        if (id != -1) {
            Int2ObjectOpenHashMap map = (Int2ObjectOpenHashMap)REGION_TILE_RENDER_TYPE_MAP.get(id);
            if (map != null) {
                map.clear();
            }
            REGION_TILE_RENDER_TYPE_MAP.remove(id);
        }
    }

    public static RenderType getGridLines(ResourceLocation resourceLocation) {
        RenderType type = (RenderType)GRID_LINES_RENDER_TYPE_MAP.get((Object)resourceLocation);
        if (type == null) {
            type = JMRenderTypes.create((String)("grid_lines" + resourceLocation.toDebugFileName()), (int)256, (boolean)false, (boolean)true, (RenderPipeline)Pipelines.GRID_LINES_RENDER_TYPE_PIPELINE, (RenderType.CompositeState)RenderType.CompositeState.builder().setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(resourceLocation, TriState.FALSE, false)).setLineState(new RenderStateShard.LineStateShard(OptionalDouble.empty())).setLayeringState(NO_LAYERING).setLightmapState(NO_LIGHTMAP).createCompositeState(false));
            GRID_LINES_RENDER_TYPE_MAP.put((Object)resourceLocation, (Object)type);
        }
        return type;
    }

    public static RenderType getRegionTile(RegionTexture texture, int shaderIndex) {
        RenderType type;
        int id = ((GlTexture)texture.getTexture()).glId();
        Int2ObjectOpenHashMap map = (Int2ObjectOpenHashMap)REGION_TILE_RENDER_TYPE_MAP.get(id);
        if (map == null) {
            map = new Int2ObjectOpenHashMap();
            REGION_TILE_RENDER_TYPE_MAP.put(id, (Object)map);
        }
        if ((type = (RenderType)map.get(shaderIndex)) == null) {
            String shader = RegionTileShaders.from(shaderIndex);
            RenderPipeline shaderState = Pipelines.REGION_SHADERS_MAP.get((Object)shader) == null ? Pipelines.REGION_DEFAULT_RENDER_PIPELINE : (RenderPipeline)Pipelines.REGION_SHADERS_MAP.get((Object)shader);
            type = JMRenderTypes.create((String)("region_tile" + id), (int)256, (boolean)false, (boolean)false, (RenderPipeline)shaderState, (RenderType.CompositeState)RenderType.CompositeState.builder().setTextureState((RenderStateShard.EmptyTextureStateShard)new RegionTileStateShard(texture.getTexture())).setLineState(new RenderStateShard.LineStateShard(OptionalDouble.empty())).setLayeringState(NO_LAYERING).setLightmapState(NO_LIGHTMAP).createCompositeState(false));
            map.put(id, (Object)type);
        }
        return type;
    }

    public static RenderType getMinimapCircleMask(GpuTexture texture) {
        return JMRenderTypes.create((String)"minimap_circle_mask", (int)256, (boolean)false, (boolean)false, (RenderPipeline)Pipelines.MINIMAP_CIRCLE_MASK_PIPELINE, (RenderType.CompositeState)RenderType.CompositeState.builder().setTextureState(new RenderStateShard.EmptyTextureStateShard(() -> {
            RenderWrapper.bindTexture(((GlTexture)texture).glId());
            RenderWrapper.setShaderTexture(0, texture);
        }, () -> {})).setLineState(new RenderStateShard.LineStateShard(OptionalDouble.empty())).setLayeringState(NO_LAYERING).setLightmapState(NO_LIGHTMAP).setTexturingState(MINIMAP_MASK_TRANSPARENCY).createCompositeState(false));
    }

    public static RenderType getIcon(GpuTexture texture) {
        int id = ((GlTexture)texture).glId();
        RenderType type = (RenderType)ICON_RENDER_TYPE_MAP.get(id);
        if (type == null) {
            type = JMRenderTypes.create((String)("icon" + id), (int)256, (boolean)false, (boolean)false, (RenderPipeline)Pipelines.ICON_RENDER_PIPELINE, (RenderType.CompositeState)RenderType.CompositeState.builder().setTextureState((RenderStateShard.EmptyTextureStateShard)new IconStateShard(texture)).setLineState(new RenderStateShard.LineStateShard(OptionalDouble.empty())).setLayeringState(NO_LAYERING).setLightmapState(NO_LIGHTMAP).createCompositeState(false));
            ICON_RENDER_TYPE_MAP.put(id, (Object)type);
        }
        return type;
    }

    public static RenderType getIconClamp(GpuTexture texture) {
        int id = ((GlTexture)texture).glId();
        RenderType type = (RenderType)ICON_CLAMP_RENDER_TYPE_MAP.get(id);
        if (type == null) {
            type = JMRenderTypes.create((String)("icon" + id), (int)256, (boolean)false, (boolean)false, (RenderPipeline)Pipelines.ICON_RENDER_PIPELINE, (RenderType.CompositeState)RenderType.CompositeState.builder().setTextureState((RenderStateShard.EmptyTextureStateShard)new IconStateShard(texture, true, false)).setLineState(new RenderStateShard.LineStateShard(OptionalDouble.empty())).setLayeringState(NO_LAYERING).setLightmapState(NO_LIGHTMAP).createCompositeState(false));
            ICON_CLAMP_RENDER_TYPE_MAP.put(id, (Object)type);
        }
        return type;
    }

    public static RenderType getIconNoBlur(GpuTexture texture) {
        int id = ((GlTexture)texture).glId();
        RenderType type = (RenderType)ICON_NOBLUR_RENDER_TYPE_MAP.get(id);
        if (type == null) {
            type = JMRenderTypes.create((String)("icon" + id), (int)256, (boolean)false, (boolean)false, (RenderPipeline)Pipelines.ICON_RENDER_PIPELINE, (RenderType.CompositeState)RenderType.CompositeState.builder().setTextureState((RenderStateShard.EmptyTextureStateShard)new IconStateShard(texture, false)).setLineState(new RenderStateShard.LineStateShard(OptionalDouble.empty())).setLayeringState(NO_LAYERING).setLightmapState(NO_LIGHTMAP).createCompositeState(false));
            ICON_NOBLUR_RENDER_TYPE_MAP.put(id, (Object)type);
        }
        return type;
    }

    public static RenderType getIconUnmasked(GpuTexture texture) {
        int id = ((GlTexture)texture).glId();
        RenderType type = (RenderType)ICON_UNMASKED_RENDER_TYPE_MAP.get(id);
        if (type == null) {
            type = JMRenderTypes.create((String)("icon_unmasked" + id), (int)256, (boolean)false, (boolean)false, (RenderPipeline)Pipelines.ICON_UNMASKED_RENDER_PIPELINE, (RenderType.CompositeState)RenderType.CompositeState.builder().setTextureState((RenderStateShard.EmptyTextureStateShard)new IconStateShard(texture)).setLineState(new RenderStateShard.LineStateShard(OptionalDouble.empty())).setLayeringState(NO_LAYERING).setLightmapState(NO_LIGHTMAP).createCompositeState(false));
            ICON_UNMASKED_RENDER_TYPE_MAP.put(id, (Object)type);
        }
        return type;
    }

    public static RenderType getPolygonWithTexture(GpuTexture texture) {
        int id = ((GlTexture)texture).glId();
        RenderType type = (RenderType)POLYGON_WITH_TEXTURE_RENDER_TYPE_MAP.get(id);
        if (type == null) {
            type = JMRenderTypes.create((String)("polygon" + id), (int)256, (boolean)false, (boolean)false, (RenderPipeline)Pipelines.POLYGON_WITH_TEXTURE_RENDER_PIPELINE, (RenderType.CompositeState)RenderType.CompositeState.builder().setTextureState(new RenderStateShard.EmptyTextureStateShard(() -> {
                RenderWrapper.bindTexture(id);
                RenderWrapper.setShaderTexture(0, texture);
            }, () -> {})).setLineState(new RenderStateShard.LineStateShard(OptionalDouble.empty())).setLayeringState(NO_LAYERING).setLightmapState(NO_LIGHTMAP).createCompositeState(false));
            POLYGON_WITH_TEXTURE_RENDER_TYPE_MAP.put(id, (Object)type);
        }
        return type;
    }

    protected static class RegionTileStateShard
    extends RenderStateShard.EmptyTextureStateShard {
        private final int textureId;

        public RegionTileStateShard(GpuTexture texture) {
            super(() -> {
                RenderWrapper.bindTexture(((GlTexture)texture).glId());
                boolean blur = false;
                if (ClientAPI.INSTANCE.getLastUIState().ui == Context.UI.Fullscreen) {
                    blur = JourneymapClient.getInstance().getFullMapProperties().zoomLevel.get() < 512;
                } else if (ClientAPI.INSTANCE.getLastUIState().ui == Context.UI.Minimap) {
                    blur = JourneymapClient.getInstance().getActiveMiniMapProperties().zoomLevel.get() < 512;
                }
                int mipmapLevels = JourneymapClient.getInstance().getCoreProperties().mipmapLevels.get();
                int mag = mipmapLevels == 0 && blur ? 9729 : 9984;
                int min = mipmapLevels == 0 && blur ? 9729 : 9728;
                RenderWrapper.bindTexture(((GlTexture)texture).glId());
                RenderWrapper.texParameter(3553, 10241, mag);
                RenderWrapper.texParameter(3553, 10240, min);
                RenderWrapper.texParameter(3553, 10242, 33071);
                RenderWrapper.texParameter(3553, 10243, 33071);
                RenderWrapper.texParameter(3553, 33085, mipmapLevels);
                RenderWrapper.texParameter(3553, 33082, 0);
                RenderWrapper.texParameter(3553, 33083, mipmapLevels);
                RenderWrapper.texParameter(3553, 34049, 0);
                RenderWrapper.setShaderTexture(0, texture);
            }, () -> {});
            this.textureId = ((GlTexture)texture).glId();
        }

        public String toString() {
            return this.name + "[" + this.textureId + ")]";
        }
    }

    protected static class IconStateShard
    extends RenderStateShard.EmptyTextureStateShard {
        private final int textureId;
        private final boolean blur;
        private final boolean clamp;

        public IconStateShard(GpuTexture tex) {
            this(tex, true);
        }

        public IconStateShard(GpuTexture texture, boolean blur) {
            this(texture, blur, false);
        }

        public IconStateShard(GpuTexture texture, boolean blur, boolean clamp) {
            super(() -> {
                RenderWrapper.bindTexture(((GlTexture)texture).glId());
                RenderWrapper.texParameter(3553, 10241, blur ? 9729 : 9728);
                RenderWrapper.texParameter(3553, 10240, blur ? 9729 : 9728);
                RenderWrapper.texParameter(3553, 10242, clamp ? 33071 : 10497);
                RenderWrapper.texParameter(3553, 10243, clamp ? 33071 : 10497);
                RenderWrapper.setShaderTexture(0, texture);
            }, () -> {});
            this.blur = blur;
            this.clamp = clamp;
            this.textureId = ((GlTexture)texture).glId();
        }

        public String toString() {
            return this.name + "[" + this.textureId + "] blur:" + this.blur + " clamp:" + this.clamp;
        }
    }
}

