/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.render.ingame;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import journeymap.client.Constants;
import journeymap.client.JourneymapClient;
import journeymap.client.render.JMRenderTypes;
import journeymap.client.render.draw.DrawStep;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.render.ingame.WaypointRenderer;
import journeymap.client.texture.TextureAccess;
import journeymap.client.texture.TextureCache;
import journeymap.client.waypoint.ClientWaypointImpl;
import journeymap.client.waypoint.PlayerPoint;
import journeymap.common.Journeymap;
import journeymap.common.mixin.client.GameRendererInvoker;
import journeymap.common.mixin.client.GuiGraphicsAccessor;
import journeymap.common.waypoint.WaypointStore;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector4f;

public class WaypointDecorationRenderer
extends WaypointRenderer {
    @Override
    public void render(GuiGraphics graphics) {
        this.waypointProperties = JourneymapClient.getInstance().getWaypointProperties();
        MultiBufferSource.BufferSource buffers = ((GuiGraphicsAccessor)graphics).getBufferSource();
        Collection<ClientWaypointImpl> waypoints = WaypointStore.getInstance().getAll();
        List<ClientWaypointImpl> waypointsOrdered = this.waypointsToDraw(waypoints);
        waypointsOrdered.addAll(WaypointStore.getInstance().getPlayerPoints());
        graphics.flush();
        if (waypointsOrdered.isEmpty()) {
            return;
        }
        PoseStack poseStack = graphics.pose();
        Window mainWindow = this.minecraft.getWindow();
        DrawUtil.sizeDisplay(mainWindow.getWidth(), mainWindow.getHeight());
        for (DrawStep.Pass pass : DrawStep.Pass.values()) {
            if (pass == DrawStep.Pass.PreObject || pass == DrawStep.Pass.PostObject || pass == DrawStep.Pass.Tooltip) continue;
            int zLevel = 0;
            for (ClientWaypointImpl waypoint : waypointsOrdered) {
                try {
                    poseStack.pushPose();
                    poseStack.translate(0.0f, 0.0f, (float)(++zLevel));
                    this.renderWaypoint(waypoint, graphics, pass, (MultiBufferSource)buffers);
                    poseStack.popPose();
                }
                catch (Exception t) {
                    Journeymap.getLogger().error("Waypoint decoration failed to render for " + waypoint.getName() + ": ", (Throwable)t);
                }
            }
            buffers.endBatch();
        }
        DrawUtil.sizeDisplay(mainWindow.getGuiScaledWidth(), mainWindow.getGuiScaledHeight());
    }

    private List<ClientWaypointImpl> waypointsToDraw(Collection<ClientWaypointImpl> waypoints) {
        String playerDim = this.minecraft.player.getCommandSenderWorld().dimension().location().toString();
        ArrayList<ClientWaypointImpl> toDraw = new ArrayList<ClientWaypointImpl>();
        double closestAngle = 0.0;
        ClientWaypointImpl closestHolder = null;
        for (ClientWaypointImpl waypoint : waypoints) {
            double angle;
            if (!this.canDrawWaypoint(waypoint, playerDim) || this.waypointProperties.shaderBeacon.get().booleanValue() && !this.waypointProperties.showRotatingBeam.get().booleanValue() && !this.waypointProperties.showStaticBeam.get().booleanValue() || !((angle = this.angleToBeacon(waypoint.getPosition())) < 180.0)) continue;
            if (closestHolder == null || angle < closestAngle) {
                if (closestHolder != null) {
                    toDraw.add(closestHolder);
                }
                closestHolder = waypoint;
                closestAngle = angle;
                continue;
            }
            toDraw.add(waypoint);
        }
        if (closestHolder != null) {
            toDraw.add(closestHolder);
        }
        return toDraw;
    }

    private double angleToBeacon(Vec3 waypointVec) {
        double playerDegrees;
        double angle;
        double playerYaw;
        double yaw = Math.atan2(this.renderManager.camera.getPosition().z() - waypointVec.z, this.renderManager.camera.getPosition().x() - waypointVec.x);
        double degrees = Math.toDegrees(yaw) + 90.0;
        if (degrees < 0.0) {
            degrees += 360.0;
        }
        if ((playerYaw = (double)(this.minecraft.cameraEntity.getYHeadRot() % 360.0f)) < 0.0) {
            playerYaw += 360.0;
        }
        if ((angle = Math.abs(degrees - (playerDegrees = Math.toDegrees(playerYaw = Math.toRadians(playerYaw))))) > 180.0) {
            angle -= 180.0;
        }
        return angle;
    }

    @Override
    protected void render(GuiGraphics graphics, DrawStep.Pass pass, MultiBufferSource buffers, ClientWaypointImpl waypoint, float partialTicks, long gameTime, float[] rgba, float fadeAlpha, double shiftX, double shiftY, double shiftZ, Vec3 playerVec, Vec3 waypointVec, double viewDistance, double actualDistance, double scale) {
        GameRenderer gameRenderer = this.minecraft.gameRenderer;
        Vector4f position = new Vector4f((float)shiftX, (float)shiftY, (float)shiftZ, 1.0f);
        double angle = this.angleToBeacon(waypoint.getPosition());
        Quaternionf rotation = new Quaternionf();
        this.renderManager.camera.rotation().conjugate(rotation);
        position.rotate((Quaternionfc)rotation);
        position.rotateY((float)Math.PI);
        if (position.z <= 0.0f) {
            return;
        }
        Matrix4f projection = gameRenderer.getProjectionMatrix(((GameRendererInvoker)gameRenderer).invokeGetFov(this.renderManager.camera, partialTicks, true));
        position.mulProject((Matrix4fc)projection);
        Window mainWindow = this.minecraft.getWindow();
        int halfWidth = mainWindow.getWidth() / 2;
        int halfHeight = mainWindow.getHeight() / 2;
        double x = position.x * (float)halfWidth + (float)halfWidth;
        double y = position.y * (float)halfHeight + (float)halfHeight;
        if (pass == DrawStep.Pass.TextBG || pass == DrawStep.Pass.Text) {
            if (actualDistance > 0.5 && (angle < (double)this.waypointProperties.autoHideLabelAngle.get().intValue() || !this.waypointProperties.autoHideLabel.get().booleanValue())) {
                this.renderNameTag(waypoint, graphics, pass, buffers, x, y, fadeAlpha, actualDistance);
            }
            if (actualDistance > 0.5 && (waypoint.showDeviation() && angle < (double)this.waypointProperties.autoHideLabelAngle.get().intValue() || !this.waypointProperties.autoHideLabel.get().booleanValue() && waypoint.showDeviation())) {
                this.renderDeviation(waypoint, graphics, pass, buffers, x, y, fadeAlpha, playerVec, waypointVec);
            }
        }
        if (pass == DrawStep.Pass.Object && actualDistance > 0.1 && (!this.waypointProperties.autoHideIcon.get().booleanValue() || angle < (double)this.waypointProperties.autoHideIconAngle.get().intValue())) {
            this.renderIcon(waypoint, graphics, buffers, x, y, fadeAlpha);
        }
    }

    protected void renderIcon(ClientWaypointImpl waypoint, GuiGraphics graphics, MultiBufferSource buffers, double iconX, double iconY, float alpha) {
        double height;
        double width;
        DynamicTexture texture;
        int scale;
        int n = scale = this.waypointProperties.textureSmall.get() != false ? 2 : 4;
        if (waypoint instanceof PlayerPoint) {
            PlayerPoint playerPoint = (PlayerPoint)waypoint;
            texture = playerPoint.getTexture();
            width = 8 * scale;
            height = 8 * scale;
        } else {
            ResourceLocation location = waypoint.getTextureResource();
            texture = TextureCache.getWaypointIcon(location);
            if (texture == null) {
                texture = TextureCache.getWaypointIcon(TextureCache.Waypoint);
            }
            width = ((TextureAccess)texture).journeymap$getWidth() * scale;
            height = ((TextureAccess)texture).journeymap$getHeight() * scale;
        }
        double drawX = iconX - (double)((int)(width / 2.0));
        double drawY = iconY - (double)((int)(height / 2.0));
        RenderType renderType = JMRenderTypes.getIconNoBlur(texture.getTexture());
        VertexConsumer vertexBuilder = buffers.getBuffer(renderType);
        DrawUtil.drawQuad(graphics, vertexBuilder, waypoint.getIconColor(), alpha, drawX, drawY, width, height, 0.0, false);
    }

    protected void renderWaypointLabel(String label, ClientWaypointImpl waypoint, GuiGraphics graphics, DrawStep.Pass pass, MultiBufferSource buffers, double labelX, double labelY, float alpha) {
        float fontScale = this.waypointProperties.fontScale.get().floatValue();
        DrawUtil.drawBatchLabel(graphics, (Component)Component.literal((String)label), pass, buffers, labelX, labelY, DrawUtil.HAlign.Center, DrawUtil.VAlign.Above, -16777216, 0.75f * alpha, (int)waypoint.getSafeColor(), alpha, (double)fontScale, false, 0.0);
    }

    protected void renderNameTag(ClientWaypointImpl waypoint, GuiGraphics graphics, DrawStep.Pass pass, MultiBufferSource buffers, double labelX, double labelY, float alpha, double actualDistance) {
        String distanceLabel = Constants.getString("jm.waypoint.distance_meters", "%1.0f");
        String label = waypoint.getDisplayName();
        boolean showName = this.waypointProperties.showName.get() != false && label != null && label.length() > 0;
        boolean showDistance = this.waypointProperties.showDistance.get();
        if (showName || showDistance) {
            StringBuilder sb = new StringBuilder();
            if (this.waypointProperties.boldLabel.get().booleanValue()) {
                sb.append(ChatFormatting.BOLD);
            }
            if (showName) {
                sb.append(label);
            }
            if (showName && showDistance) {
                sb.append(" ");
            }
            if (showDistance) {
                sb.append(String.format(distanceLabel, actualDistance));
            }
            if (sb.length() > 0) {
                label = sb.toString();
                labelY = labelY - (double)(((TextureAccess)waypoint.getTexture()).journeymap$getHeight() >> 1) - 8.0;
                this.renderWaypointLabel(label, waypoint, graphics, pass, buffers, labelX, labelY, alpha);
            }
        }
    }

    protected void renderDeviation(ClientWaypointImpl waypoint, GuiGraphics graphics, DrawStep.Pass pass, MultiBufferSource buffers, double labelX, double labelY, float alpha, Vec3 playerVec, Vec3 waypointVec) {
        StringBuilder sb = new StringBuilder();
        Vec3 vecTo = playerVec.vectorTo(waypointVec);
        if (this.waypointProperties.boldLabel.get().booleanValue()) {
            sb.append(ChatFormatting.BOLD);
        }
        sb.append(String.format("x:%d, y:%d, z:%d", (int)vecTo.x, (int)vecTo.y, (int)vecTo.z));
        labelY = labelY + (double)(((TextureAccess)waypoint.getTexture()).journeymap$getHeight() >> 1) + 35.0;
        this.renderWaypointLabel(sb.toString(), waypoint, graphics, pass, buffers, labelX, labelY, alpha);
    }
}

