/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.task.main;

import com.mojang.blaze3d.opengl.GlStateManager;
import com.mojang.blaze3d.opengl.GlTexture;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import journeymap.client.JourneymapClient;
import journeymap.client.render.RenderWrapper;
import journeymap.client.task.main.IMainThreadTask;
import journeymap.client.task.main.MappingMonitorTask;
import journeymap.client.texture.ImageUtil;
import journeymap.common.Journeymap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.DynamicTexture;
import org.apache.logging.log4j.Logger;

public class ExpireTextureTask
implements IMainThreadTask {
    private static final int MAX_FAILS = 5;
    private static String NAME = "Tick." + MappingMonitorTask.class.getSimpleName();
    private static Logger LOGGER = Journeymap.getLogger();
    private final List<DynamicTexture> textures;
    private final int textureId;
    private volatile int fails;

    private ExpireTextureTask(int textureId) {
        this.textures = null;
        this.textureId = textureId;
    }

    private ExpireTextureTask(DynamicTexture texture) {
        this.textures = new ArrayList<DynamicTexture>();
        this.textures.add(texture);
        this.textureId = -1;
    }

    private ExpireTextureTask(Collection<DynamicTexture> textureCollection) {
        this.textures = new ArrayList<DynamicTexture>(textureCollection);
        this.textureId = -1;
    }

    public static void queue(int textureId) {
        if (textureId != -1) {
            JourneymapClient.getInstance().queueMainThreadTask(new ExpireTextureTask(textureId));
        }
    }

    public static void queue(DynamicTexture texture) {
        JourneymapClient.getInstance().queueMainThreadTask(new ExpireTextureTask(texture));
    }

    public static void queue(Collection<DynamicTexture> textureCollection) {
        JourneymapClient.getInstance().queueMainThreadTask(new ExpireTextureTask(textureCollection));
    }

    @Override
    public IMainThreadTask perform(Minecraft mc, JourneymapClient jm) {
        boolean success = this.deleteTextures();
        if (!success && this.textures != null && !this.textures.isEmpty()) {
            ++this.fails;
            LOGGER.warn("ExpireTextureTask.perform() couldn't delete textures: " + String.valueOf(this.textures) + ", fails: " + this.fails);
            if (this.fails <= 5) {
                return this;
            }
        }
        return null;
    }

    private boolean deleteTextures() {
        if (this.textureId != -1) {
            return this.deleteTexture(this.textureId);
        }
        ListIterator<DynamicTexture> iter = this.textures.listIterator();
        while (iter.hasNext()) {
            DynamicTexture texture = (DynamicTexture)iter.next();
            if (texture == null) {
                iter.remove();
                continue;
            }
            if (!this.deleteTexture(texture)) break;
            iter.remove();
        }
        return this.textures.isEmpty();
    }

    private boolean deleteTexture(DynamicTexture texture) {
        boolean success = false;
        if (((GlTexture)texture.getTexture()).glId() != -1) {
            try {
                ImageUtil.closeSafely(texture);
                success = true;
            }
            catch (Exception t) {
                LOGGER.warn("Couldn't delete texture " + String.valueOf(texture) + ": " + String.valueOf(t));
            }
        } else {
            ImageUtil.closeSafely(texture);
            success = true;
        }
        return success;
    }

    private boolean deleteTexture(int textureId) {
        try {
            if (!RenderSystem.isOnRenderThread()) {
                RenderWrapper.recordRenderQueue(() -> {
                    if (this.textureId != -1) {
                        GlStateManager._deleteTexture((int)this.textureId);
                    }
                });
            } else if (this.textureId != -1) {
                GlStateManager._deleteTexture((int)this.textureId);
            }
            return true;
        }
        catch (Exception t) {
            LOGGER.warn("Couldn't delete textureId " + textureId + ": " + String.valueOf(t));
            return false;
        }
    }

    @Override
    public String getName() {
        return NAME;
    }
}

