/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.component.buttons;

import journeymap.client.ui.component.buttons.FieldButton;
import journeymap.common.properties.config.ConfigField;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;

public abstract class AbstractSliderButton
extends FieldButton {
    private static final ResourceLocation SLIDER_HANDLE_SPRITE = ResourceLocation.withDefaultNamespace((String)"widget/slider_handle");
    private static final ResourceLocation SLIDER_HANDLE_HIGHLIGHTED_SPRITE = ResourceLocation.withDefaultNamespace((String)"widget/slider_handle_highlighted");

    public AbstractSliderButton(ConfigField<?> field, String label) {
        super(field, label);
    }

    public AbstractSliderButton(ConfigField<?> field, String label, Button.OnPress onPress) {
        super(field, label, onPress);
    }

    public AbstractSliderButton(ConfigField<?> field, int width, int height, String label, Button.OnPress onPress) {
        super(field, width, height, label, onPress);
    }

    private ResourceLocation getHandleSprite() {
        return !this.isHovered ? SLIDER_HANDLE_SPRITE : SLIDER_HANDLE_HIGHLIGHTED_SPRITE;
    }

    @Override
    protected void renderBg(GuiGraphics graphics, Minecraft mc, int mouseX, int mouseY) {
        double sliderValue = this.getSliderValue();
        graphics.blitSprite(RenderType::guiTextured, this.getHandleSprite(), super.getX() + 1 + (int)(sliderValue * (double)(this.width - 10)), super.getY() + 1, 8, this.height - 2);
    }

    public abstract double getSliderValue();
}

