/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.component.buttons;

import java.awt.Color;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.function.Function;
import journeymap.client.Constants;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.ui.UIManager;
import journeymap.client.ui.component.ButtonList;
import journeymap.client.ui.option.ClientOptionsManager;
import journeymap.common.Journeymap;
import journeymap.common.log.LogFormatter;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;

public class Button
extends net.minecraft.client.gui.components.Button {
    public static final ResourceLocation buttonActiveResource = ResourceLocation.parse((String)"widget/button");
    public static final ResourceLocation buttonDisabledResource = ResourceLocation.parse((String)"widget/button_disabled");
    public static final ResourceLocation buttonHighlightedResource = ResourceLocation.parse((String)"widget/button_highlighted");
    public static final WidgetSprites SPRITES = new WidgetSprites(buttonActiveResource, buttonDisabledResource, buttonHighlightedResource);
    protected Integer customFrameColorLight = new Color(160, 160, 160).getRGB();
    protected Integer customFrameColorDark = new Color(120, 120, 120).getRGB();
    protected Integer customBgColor = new Color(100, 100, 100).getRGB();
    protected Integer customBgHoverColor = new Color(125, 135, 190).getRGB();
    protected Integer customBgHoverColor2 = new Color(100, 100, 100).getRGB();
    protected Integer labelColor;
    protected Integer varLabelColor;
    protected Integer hoverLabelColor;
    protected Integer disabledLabelColor;
    public static final int UNSET_ACTIVE_COLOR = -1;
    protected int packedActiveColor = -1;
    protected Integer disabledBgColor = new Color(45, 45, 45).getRGB();
    protected boolean drawFrame;
    protected boolean drawBackground;
    protected boolean drawBackgroundOnDisable = true;
    protected boolean drawLabelShadow = true;
    protected boolean showDisabledHoverText;
    protected boolean defaultStyle = true;
    protected int WIDTH_PAD = 12;
    protected String[] tooltip;
    protected Component label;
    protected Font fontRenderer;
    protected Rectangle2D.Double bounds;
    protected ArrayList<Function<Button, Boolean>> clickListeners;
    private int tooltipSize;
    protected DrawUtil.HAlign horizontalAlignment;
    protected int textX;
    private boolean drawHovered;
    private HoverState onHoverState;
    private boolean wasHovered;
    private boolean drawUnderline;

    public Button(String label) {
        this(0, 0, label, Button.emptyPressable());
        this.resetLabelColors();
    }

    public Button(String label, Button.OnPress onPress) {
        this(0, 0, label, onPress);
        this.resetLabelColors();
    }

    public Button(int width, int height, String label) {
        this(width, height, label, Button.emptyPressable());
    }

    public Button(int width, int height, String label, Button.OnPress onPress) {
        this(width, height, (Component)Constants.getStringTextComponent(label), onPress);
    }

    public Button(int width, int height, Component label, Button.OnPress onPress) {
        super(0, 0, width, height, label, onPress, DEFAULT_NARRATION);
        this.fontRenderer = Minecraft.getInstance().font;
        this.clickListeners = new ArrayList(0);
        this.tooltipSize = 200;
        this.horizontalAlignment = DrawUtil.HAlign.Center;
        this.drawHovered = true;
        this.wasHovered = false;
        this.drawUnderline = false;
        this.label = label;
        this.resetLabelColors();
        this.finishInit();
    }

    public static Button.OnPress emptyPressable() {
        return button -> {};
    }

    public void resetLabelColors() {
        this.labelColor = new Color(0xE0E0E0).getRGB();
        this.hoverLabelColor = new Color(0xFFFFA0).getRGB();
        this.disabledLabelColor = Color.gray.getRGB();
    }

    public int getActiveColor() {
        if (this.packedActiveColor != -1) {
            return this.packedActiveColor;
        }
        return this.active ? 0xFFFFFF : 0xA0A0A0;
    }

    protected void finishInit() {
        this.setEnabled(true);
        this.setDrawButton(true);
        this.setDrawFrame(true);
        this.setDrawBackground(true);
        if (this.height == 0) {
            this.setHeight(20);
        }
        if (this.width == 0) {
            this.setWidth(200);
        }
        this.updateBounds();
    }

    protected void updateLabel() {
    }

    public boolean isActive() {
        return this.isEnabled();
    }

    public int getFitWidth(Font fr) {
        int max = fr.width(this.getMessage().getString());
        return max + this.WIDTH_PAD + (fr.isBidirectional() ? (int)Math.ceil((double)max * 0.25) : 0);
    }

    public String getLabel() {
        return this.label.getString();
    }

    public void fitWidth(Font fr) {
        this.setWidth(this.getFitWidth(fr));
    }

    public void drawPartialScrollable(GuiGraphics graphics, Minecraft minecraft, int x, int y, int width, int height) {
        graphics.blitSprite(RenderType::guiTextured, SPRITES.disabled(), x, y, width, height);
    }

    public void showDisabledOnHover(boolean show) {
        this.showDisabledHoverText = show;
    }

    public boolean isMouseOver(double x, double y) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.screen instanceof ClientOptionsManager && ((ClientOptionsManager)mc.screen).previewMiniMap() && UIManager.INSTANCE.getMiniMap().withinBounds(x, y)) {
            return false;
        }
        return super.isMouseOver(x, y);
    }

    public boolean isMouseOver() {
        return super.isMouseOver((double)super.getX(), (double)super.getY());
    }

    public void setMouseOver(boolean hover) {
        this.setHovered(hover);
    }

    public void playDownSound(SoundManager soundHandler) {
        if (this.isEnabled()) {
            super.playDownSound(soundHandler);
        }
    }

    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        if (!this.isVisible()) {
            return;
        }
        if (this.defaultStyle) {
            super.renderWidget(graphics, mouseX, mouseY, partialTicks);
        } else {
            Minecraft minecraft = Minecraft.getInstance();
            if (minecraft.screen instanceof ClientOptionsManager && ((ClientOptionsManager)minecraft.screen).previewMiniMap() && UIManager.INSTANCE.getMiniMap().withinBounds(mouseX, mouseY)) {
                this.setHovered(false);
            } else {
                this.setHovered(mouseX >= super.getX() && mouseY >= super.getY() && mouseX < super.getX() + this.width && mouseY < super.getY() + this.height);
            }
            if (this.isDrawBackground() || !this.drawBackgroundOnDisable && this.isEnabled()) {
                DrawUtil.drawRectangle(graphics, super.getX(), super.getY(), this.width, this.height, this.isHovered() && this.drawHovered ? this.customBgHoverColor : this.customBgColor, 1.0f);
            } else if (this.isEnabled() && this.isHoveredOrFocused() && this.drawHovered) {
                DrawUtil.drawRectangle(graphics, super.getX(), super.getY(), this.width, this.height, this.customBgHoverColor2, 0.5f);
            }
            if (this.isDrawFrame()) {
                DrawUtil.drawRectangle(graphics, super.getX(), super.getY(), this.width, 1.0, this.customFrameColorLight, 1.0f);
                DrawUtil.drawRectangle(graphics, super.getX(), super.getY(), 1.0, this.height, this.customFrameColorLight, 1.0f);
                DrawUtil.drawRectangle(graphics, super.getX(), super.getY() + this.height - 1, this.width - 1, 1.0, this.customFrameColorDark, 1.0f);
                DrawUtil.drawRectangle(graphics, super.getX() + this.width - 1, super.getY() + 1, 1.0, this.height - 1, this.customFrameColorDark, 1.0f);
            }
            this.renderBg(graphics, minecraft, mouseX, mouseY);
            this.varLabelColor = this.labelColor;
            if (!this.isEnabled()) {
                this.varLabelColor = this.disabledLabelColor;
                if (this.drawBackground) {
                    float alpha = 0.7f;
                    int widthOffset = this.width - (this.height >= 20 ? 3 : 2);
                    DrawUtil.drawRectangle(graphics, this.getX() + 1, this.getY() + 1, widthOffset, this.height - 2, this.disabledBgColor, alpha);
                }
            } else if (this.isHoveredOrFocused() && this.drawHovered) {
                this.varLabelColor = this.hoverLabelColor;
            } else if (this.labelColor != null) {
                this.varLabelColor = this.labelColor;
            } else if (this.getActiveColor() != 0) {
                this.varLabelColor = this.getActiveColor();
            }
            switch (this.horizontalAlignment) {
                case Left: {
                    this.textX = this.getRightX() - this.WIDTH_PAD / 2;
                    break;
                }
                case Right: {
                    this.textX = this.getX() + this.WIDTH_PAD / 2;
                    break;
                }
                default: {
                    this.textX = this.getCenterX();
                }
            }
            DrawUtil.drawLabel(graphics, this.getMessage().getString(), this.textX, this.getMiddleY(), this.horizontalAlignment, DrawUtil.VAlign.Middle, null, 0.0f, this.varLabelColor, 1.0f, 1.0, this.drawLabelShadow, 0.0);
            if (this.drawUnderline) {
                this.drawUnderline(graphics);
            }
        }
    }

    protected void renderBg(GuiGraphics graphics, Minecraft $$1, int $$2, int $$3) {
    }

    public void renderSpecialDecoration(GuiGraphics graphics, int mouseX, int mouseY, int x, int y, int width, int height) {
    }

    public void setHorizontalAlignment(DrawUtil.HAlign horizontalAlignment) {
        this.horizontalAlignment = horizontalAlignment;
    }

    public void drawHovered(boolean drawHovered) {
        this.drawHovered = drawHovered;
    }

    public void drawUnderline(boolean drawUnderline) {
        this.drawUnderline = drawUnderline;
    }

    public void drawUnderline(GuiGraphics graphics) {
        if (this.isVisible()) {
            DrawUtil.drawRectangle(graphics, super.getX(), super.getY() + this.height, this.width, 1.0, this.customFrameColorDark, 1.0f);
        }
    }

    public void secondaryDrawButton() {
    }

    public void onPress() {
        if (this.clickListeners == null || this.clickListeners.size() == 0) {
            super.onPress();
        } else {
            this.checkClickListeners();
        }
    }

    public void mouseMoved(double mouseX, double mouseY) {
        if (this.onHoverState != null) {
            if (this.isHovered() && !this.wasHovered) {
                this.wasHovered = true;
                this.onHoverState.onHoverState(this, this.wasHovered);
            } else if (this.wasHovered && !this.isHovered()) {
                this.wasHovered = false;
                this.onHoverState.onHoverState(this, this.wasHovered);
            }
        }
    }

    public boolean checkClickListeners() {
        boolean clicked = true;
        if (!this.clickListeners.isEmpty()) {
            try {
                for (Function<Button, Boolean> listener : this.clickListeners) {
                    if (!listener.apply(this).booleanValue()) break;
                }
            }
            catch (Throwable t) {
                Journeymap.getLogger().error("Error trying to toggle button '" + String.valueOf(this.getMessage()) + "': " + LogFormatter.toString(t));
                clicked = false;
            }
        }
        return clicked;
    }

    public String getUnformattedTooltip() {
        if (this.tooltip != null && this.tooltip.length > 0) {
            return this.tooltip[0];
        }
        return null;
    }

    public List<FormattedCharSequence> getWrappedTooltip() {
        ArrayList<FormattedCharSequence> list = new ArrayList<FormattedCharSequence>();
        if (this.tooltip != null) {
            for (String line : this.tooltip) {
                list.addAll(this.fontRenderer.split((FormattedText)Constants.getTranslatedTextComponent(line), this.tooltipSize));
            }
            return list;
        }
        if (!this.isEnabled() && this.showDisabledHoverText) {
            list.add(FormattedCharSequence.forward((String)Constants.getString("jm.common.disabled_feature"), (Style)Style.EMPTY.withItalic(Boolean.valueOf(true))));
        }
        return list;
    }

    public void setTooltip(String ... tooltip) {
        this.tooltip = tooltip;
    }

    public void setTooltip(int size, String ... tooltip) {
        this.tooltipSize = size;
        this.tooltip = tooltip;
    }

    public boolean mouseOver(double mouseX, double mouseY) {
        return this.isVisible() && this.getBounds().contains(mouseX, mouseY);
    }

    protected Rectangle2D.Double updateBounds() {
        this.bounds = new Rectangle2D.Double(this.getX(), this.getY(), this.getWidth(), this.getHeight());
        return this.bounds;
    }

    public Rectangle2D.Double getBounds() {
        if (this.bounds == null) {
            return this.updateBounds();
        }
        return this.bounds;
    }

    public int getScrollableWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        if (this.width != width) {
            this.width = width;
            this.bounds = null;
        }
    }

    public void setScrollableWidth(int width) {
        this.setWidth(width);
    }

    public int getButtonHeight() {
        return this.getHeight();
    }

    public void setHeight(int height) {
        if (this.height != height) {
            this.height = height;
            this.bounds = null;
            if (height != 20) {
                this.defaultStyle = false;
            }
        }
    }

    public void setTextOnly(Font fr) {
        Objects.requireNonNull(fr);
        this.setHeight(9 + 1);
        this.fitWidth(fr);
        this.setDrawBackground(false);
        this.setDrawFrame(false);
    }

    public void drawScrollable(GuiGraphics graphics, Minecraft mc, int mouseX, int mouseY) {
        this.render(graphics, mouseX, mouseY, 0.0f);
    }

    public void clickScrollable(Minecraft mc, int mouseX, int mouseY) {
    }

    public void setX(int x) {
        super.setX(x);
        this.bounds = null;
    }

    public void setY(int y) {
        super.setY(y);
        this.bounds = null;
    }

    public int getCenterX() {
        return super.getX() + this.width / 2;
    }

    public int getMiddleY() {
        return super.getY() + this.height / 2;
    }

    public int getBottomY() {
        return super.getY() + this.height;
    }

    public int getRightX() {
        return super.getX() + this.width;
    }

    public void setScrollablePosition(int x, int y) {
        this.setX(x);
        this.setY(y);
    }

    public Button leftOf(int x) {
        this.setX(x - this.getWidth());
        return this;
    }

    public Button rightOf(int x) {
        this.setX(x);
        return this;
    }

    public Button centerHorizontalOn(int x) {
        this.setX(x - this.width / 2);
        return this;
    }

    public Button centerVerticalOn(int y) {
        this.setY(y - this.height / 2);
        return this;
    }

    public Button leftOf(Button other, int margin) {
        this.setX(other.getX() - this.getWidth() - margin);
        return this;
    }

    public Button rightOf(Button other, int margin) {
        this.setX(other.getX() + other.getWidth() + margin);
        return this;
    }

    public Button above(Button other, int margin) {
        this.setY(other.getY() - this.getHeight() - margin);
        return this;
    }

    public Button above(int y) {
        this.setY(y - this.getHeight());
        return this;
    }

    public Button below(Button other, int margin) {
        this.setY(other.getY() + other.getHeight() + margin);
        return this;
    }

    public Button below(ButtonList list, int margin) {
        this.setY(list.getBottomY() + margin);
        return this;
    }

    public Button below(int y) {
        this.setY(y);
        return this;
    }

    public Button alignTo(Button other, DrawUtil.HAlign hAlign, int hgap, DrawUtil.VAlign vAlign, int vgap) {
        int x = this.getX();
        int y = this.getY();
        switch (hAlign) {
            case Right: {
                x = other.getRightX() + hgap;
                break;
            }
            case Left: {
                x = other.getX() - hgap;
                break;
            }
            case Center: {
                x = other.getCenterX();
            }
        }
        switch (vAlign) {
            case Above: {
                y = other.getY() - vgap - this.getHeight();
                break;
            }
            case Below: {
                y = other.getBottomY() + vgap;
                break;
            }
            case Middle: {
                y = other.getMiddleY() - this.getHeight() / 2;
            }
        }
        this.setX(x);
        this.setY(y);
        return this;
    }

    public boolean isEnabled() {
        return this.active;
    }

    public void setEnabled(boolean enabled) {
        this.active = enabled;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public void setDrawButton(boolean drawButton) {
        if (drawButton != this.visible) {
            this.visible = drawButton;
        }
    }

    public boolean isDrawFrame() {
        return this.drawFrame;
    }

    public void setDrawFrame(boolean drawFrame) {
        this.drawFrame = drawFrame;
    }

    public boolean isDrawBackground() {
        return this.drawBackground;
    }

    public void setDrawBackground(boolean drawBackground) {
        this.drawBackground = drawBackground;
    }

    public boolean isDefaultStyle() {
        return this.defaultStyle;
    }

    public void setDefaultStyle(boolean defaultStyle) {
        this.defaultStyle = defaultStyle;
    }

    public void setBackgroundColors(Integer customBgColor, Integer customBgHoverColor, Integer customBgHoverColor2) {
        this.customBgColor = customBgColor;
        this.customBgHoverColor = customBgHoverColor;
        this.customBgHoverColor2 = customBgHoverColor2;
    }

    public void setDrawLabelShadow(boolean draw) {
        this.drawLabelShadow = draw;
    }

    public void setLabelColors(Integer labelColor, Integer hoverLabelColor, Integer disabledLabelColor) {
        this.labelColor = labelColor;
        this.packedActiveColor = labelColor;
        if (hoverLabelColor != null) {
            this.hoverLabelColor = hoverLabelColor;
        }
        if (disabledLabelColor != null) {
            this.disabledLabelColor = disabledLabelColor;
        }
    }

    public String getDisplayString() {
        return this.getMessage().getString();
    }

    public void setOnHover(HoverState hoverState) {
        this.onHoverState = hoverState;
    }

    public boolean isDrawBackgroundOnDisable() {
        return this.drawBackgroundOnDisable;
    }

    public void setDrawBackgroundOnDisable(boolean drawBackgroundOnDisable) {
        this.drawBackgroundOnDisable = drawBackgroundOnDisable;
    }

    public void refresh() {
    }

    public Integer getLabelColor() {
        return this.labelColor;
    }

    public boolean isHovered() {
        return super.isHovered();
    }

    public void setHovered(boolean hovered) {
        this.isHovered = hovered;
    }

    public void addClickListener(Function<Button, Boolean> listener) {
        this.clickListeners.add(listener);
    }

    public String toString() {
        return new StringJoiner(", ", Button.class.getSimpleName() + "[", "]").add("label='" + String.valueOf(this.label) + "'").toString();
    }

    public static interface HoverState {
        public void onHoverState(Button var1, boolean var2);
    }
}

