/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.component.buttons;

import journeymap.client.texture.TextureCache;
import journeymap.client.ui.component.widgets.ColoredImageWidget;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;

public abstract class RadioButton
extends Button {
    private static final ResourceLocation RADIO = ResourceLocation.fromNamespaceAndPath((String)"journeymap", (String)"ui/img/radio_buttons.png");
    int imageWidth;
    int imageHeight;
    protected boolean state;

    public RadioButton(int width, int height, Component message, boolean state, Button.OnPress onPress) {
        super(0, 0, width + 5 + Minecraft.getInstance().font.width((FormattedText)message), height, message, onPress, DEFAULT_NARRATION);
        this.imageWidth = width;
        this.imageHeight = height;
        this.state = state;
    }

    protected void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        int size = 9;
        int length = 36;
        int offset = this.state ? 0 : size;
        int selectedOffset = this.isHovered() ? length / 2 : 0;
        int min = offset + selectedOffset;
        graphics.blit(RenderType::guiTextured, RADIO, this.getX(), this.getY(), (float)min, 0.0f, this.imageWidth, this.imageHeight, length, size);
    }

    public void toggle() {
        this.state = !this.state;
    }

    public boolean state() {
        return this.state;
    }

    public void setState(boolean state) {
        this.state = state;
    }

    public static class ImageRadioButton
    extends RadioButton {
        private final ColoredImageWidget imageWidget;

        public ImageRadioButton(int width, int height, int textureWidth, int textureHeight, ResourceLocation texture, boolean state, Button.OnPress onPress) {
            super(width, height, (Component)Component.empty(), state, onPress);
            this.imageWidget = ColoredImageWidget.texture(textureWidth, textureHeight, TextureCache.getTexture(texture), textureWidth, textureHeight, 0xFFFFFF, true);
        }

        @Override
        protected void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
            super.renderWidget(graphics, mouseX, mouseY, partialTicks);
            this.isHovered = graphics.containsPointInScissor(mouseX, mouseY) && this.inBounds(mouseX, mouseY);
            int color = this.state ? 0xFFFFFF : 0xAAAAAA;
            color = this.isHovered ? 65535 : color;
            this.imageWidget.setColor(color);
        }

        public ColoredImageWidget getImageWidget() {
            return this.imageWidget;
        }

        public boolean isMouseOver(double mouseX, double mouseY) {
            return this.active && this.visible && this.inBounds(mouseX, mouseY);
        }

        private boolean inBounds(double mouseX, double mouseY) {
            int y = Math.min(this.imageWidget.getY(), this.getY());
            int height = Math.max(this.getHeight(), this.imageWidget.getHeight());
            return mouseX >= (double)this.getX() && mouseY >= (double)y && mouseX < (double)(this.imageWidget.getX() + this.imageWidget.getWidth()) && mouseY < (double)(y + height);
        }
    }

    public static class TextRadioButton
    extends RadioButton {
        public TextRadioButton(int width, int height, Component message, boolean state, Button.OnPress onPress) {
            super(width, height, message, state, onPress);
        }

        @Override
        protected void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
            super.renderWidget(graphics, mouseX, mouseY, partialTicks);
            int color = this.state ? 0xFFFFFF : 0xAAAAAA;
            color = this.isHovered ? 65535 : color;
            graphics.drawString(Minecraft.getInstance().font, this.getMessage(), this.getX() + this.imageWidth + 5, this.getY(), color);
        }
    }
}

