/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.component.dropdown;

import java.util.List;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.texture.TextureAccess;
import journeymap.client.ui.component.dropdown.DropDownButton;
import journeymap.client.ui.component.dropdown.DropDownItem;
import journeymap.client.ui.component.dropdown.ImageDropDownItem;
import journeymap.client.ui.component.screens.ScrollPaneScreen;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;

public class ActionsDropDownButton
extends DropDownButton {
    protected boolean matchPaneWidth = true;
    protected int maxHeight = 0;

    public ActionsDropDownButton(String label, Button.OnPress onPress) {
        super(label, onPress);
        this.setDrawBackground(false);
        this.setRenderSolidBackground(true);
        this.setDefaultStyle(false);
        this.setButtonBuffer(Minecraft.getInstance().font.width(label) - 25);
        this.setHorizontalAlignment(DrawUtil.HAlign.Left);
    }

    @Override
    public void setItems(List<DropDownItem> items) {
        this.items = items;
        this.paneWidth = this.getPaneWidth();
        this.width = this.getWidth();
        this.paneScreen = new ScrollPaneScreen(this, items, this.paneWidth, this.getPaneHeight(), this.getX(), this.getPanelLocation());
        this.paneScreen.setRenderSolidBackground(this.renderSolidBackground);
    }

    @Override
    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.renderWidget(graphics, mouseX, mouseY, partialTicks);
        int imageX = this.getX() + 5;
        if (this.horizontalAlignment == DrawUtil.HAlign.Left) {
            imageX = this.getRightX() - this.WIDTH_PAD / 2 - this.fontRenderer.width(this.getMessage().getString()) - 10;
        }
        DrawUtil.drawClampedTexture(graphics, this.glyphIcon, this.getLabelColor(), this.visible ? 0.8f : 1.0f, imageX, (float)this.getMiddleY() - (float)((TextureAccess)this.glyphIcon).journeymap$getHeight() * 0.25f / 2.0f, 0.25f, this.visible ? (double)this.rotation : 0.0);
        DropDownItem dropDownItem = this.selected;
        if (dropDownItem instanceof ImageDropDownItem) {
            ImageDropDownItem item = (ImageDropDownItem)dropDownItem;
            item.renderImage(graphics, this.getCenterX(), this.getY() + (this.height >> 1) - (item.getHeight() >> 1));
        }
    }

    @Override
    public int getWidth() {
        this.width = this.fontRenderer.width(this.getMessage().getString()) + this.buttonBuffer + 10;
        return this.width;
    }

    public int getPaneWidth() {
        int paneWidth = 0;
        if (this.items != null) {
            Font fontRenderer = Minecraft.getInstance().font;
            for (DropDownItem item : this.items) {
                paneWidth = Math.max(paneWidth, fontRenderer.width(this.getLabel(item)) + this.buttonBuffer + 10);
            }
            return paneWidth + this.buttonBuffer;
        }
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    public void setMatchPaneWidth(boolean matchPaneWidth) {
        this.matchPaneWidth = matchPaneWidth;
    }

    public void setMaxHeight(int maxHeight) {
        this.maxHeight = maxHeight;
    }
}

