/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.dialog.about;

import java.awt.Color;
import java.util.Objects;
import java.util.function.Consumer;
import journeymap.client.io.FileHandler;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.ui.component.widgets.StringWidget;
import journeymap.client.ui.dialog.about.SplashInfo;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LayoutSettings;
import net.minecraft.client.gui.layouts.LinearLayout;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class WhatsNew
extends LinearLayout {
    protected final LinearLayout infoGrid;
    protected final Screen parent;

    public WhatsNew(Screen parent) {
        super(0, 0, LinearLayout.Orientation.VERTICAL);
        this.addChild((LayoutElement)new Title("jm.common.splash_whatisnew", Minecraft.getInstance().font, this), LayoutSettings::alignHorizontallyCenter);
        this.spacing(4);
        this.infoGrid = (LinearLayout)this.addChild((LayoutElement)LinearLayout.vertical());
        this.infoGrid.spacing(1);
        this.parent = parent;
    }

    public void visitWidgets(Consumer<AbstractWidget> consumer) {
        this.init();
        super.visitWidgets(consumer);
    }

    private void init() {
        Font font = Minecraft.getInstance().font;
        SplashInfo info = FileHandler.getMessageModel(SplashInfo.class, "splash");
        int maxWidth = 0;
        if (info == null) {
            info = new SplashInfo();
        }
        int i = 0;
        for (SplashInfo.Line line : info.lines) {
            InfoButton button = (InfoButton)this.infoGrid.addChild((LayoutElement)new InfoButton((Component)Component.translatable((String)line.label), font, this, b -> line.invokeAction(this.parent)), LayoutSettings::alignHorizontallyCenter);
            maxWidth = Math.max(maxWidth, button.getWidth());
            i += button.getHeight();
        }
        this.setWidths(maxWidth);
    }

    private void setWidths(int width) {
        this.infoGrid.visitWidgets(widget -> widget.setWidth(width));
    }

    private void render(GuiGraphics graphics) {
        graphics.pose().pushPose();
        int renderX = this.getX() - 5;
        int renderY = this.getY() - 5;
        int renderWidth = this.getWidth() + 10;
        int renderHeight = this.getHeight() + 10;
        DrawUtil.drawGradientRect(graphics, renderX - 1, renderY - 1, renderWidth + 2, renderHeight + 2, 0xC0C0C0, 0.8f, 0xC0C0C0, 0.8f);
        DrawUtil.drawGradientRect(graphics, renderX, renderY, renderWidth, renderHeight, 0x404040, 1.0f, 0, 1.0f);
        graphics.pose().popPose();
    }

    private static class Title
    extends StringWidget {
        private final WhatsNew parent;

        public Title(String key, Font font, WhatsNew parent) {
            super((Component)Component.translatable((String)key).withStyle(ChatFormatting.AQUA).withStyle(ChatFormatting.UNDERLINE), font);
            this.setTooltip(Tooltip.create((Component)Component.translatable((String)(key + ".tooltip"))));
            this.parent = parent;
        }

        @Override
        public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
            super.renderWidget(guiGraphics, mouseX, mouseY, partialTick);
            this.parent.render(guiGraphics);
        }
    }

    private static class InfoButton
    extends Button {
        protected Integer customBgHoverColor2;
        protected Integer labelColor;
        protected Integer hoverLabelColor;
        protected final WhatsNew parent;

        public InfoButton(Component message, Font font, WhatsNew parent, Button.OnPress onPress) {
            int n = font.width(message.getVisualOrderText()) + 10;
            Objects.requireNonNull(font);
            super(0, 0, n, 9 + 5, message, onPress, Button.DEFAULT_NARRATION);
            this.customBgHoverColor2 = new Color(100, 100, 100).getRGB();
            this.labelColor = new Color(0xE0E0E0).getRGB();
            this.hoverLabelColor = new Color(0xFFFFA0).getRGB();
            this.setTooltip(Tooltip.create((Component)Component.translatable((String)"jm.common.splash_action")));
            this.parent = parent;
        }

        protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
            Minecraft minecraft = Minecraft.getInstance();
            if (this.isHoveredOrFocused()) {
                DrawUtil.drawRectangle(guiGraphics, this.getX(), this.getY(), this.getWidth(), this.getHeight(), this.customBgHoverColor2, 0.5f);
            }
            Integer color = this.isHovered ? this.hoverLabelColor : this.labelColor;
            this.renderString(guiGraphics, minecraft.font, color);
        }
    }
}

