/*
 * Decompiled with CFR 0.152.
 */
package journeymap.api.plugins;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import journeymap.api.client.impl.ClientAPI;
import journeymap.api.v2.client.IClientAPI;
import journeymap.api.v2.client.IClientPlugin;
import journeymap.api.v2.client.JourneyMapPlugin;
import journeymap.api.v2.client.display.DisplayType;
import journeymap.api.v2.client.display.Overlay;
import journeymap.api.v2.client.display.PolygonOverlay;
import journeymap.api.v2.client.event.FullscreenDisplayEvent;
import journeymap.api.v2.client.event.MappingEvent;
import journeymap.api.v2.client.model.MapPolygon;
import journeymap.api.v2.client.model.ShapeProperties;
import journeymap.api.v2.common.event.ClientEventRegistry;
import journeymap.api.v2.common.event.FullscreenEventRegistry;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;

@JourneyMapPlugin(apiVersion="2.0.0")
public class LoadedChunkOverlayPlugin
implements IClientPlugin {
    private static final String CHUNK_OVERLAY_ID = "journeymap_chunk_overlay";
    private IClientAPI api;
    private static LoadedChunkOverlayPlugin instance;

    public static LoadedChunkOverlayPlugin getInstance() {
        return instance;
    }

    public void initialize(IClientAPI api) {
        instance = this;
        this.api = api;
        ClientEventRegistry.MAPPING_EVENT.subscribe(this.getModId(), this::onMappingEvent);
        FullscreenEventRegistry.ADDON_BUTTON_DISPLAY_EVENT.subscribe(this.getModId(), this::onAddonButtonEvent);
    }

    private void onAddonButtonEvent(FullscreenDisplayEvent.AddonButtonDisplayEvent addonButtonDisplayEvent) {
    }

    public String getModId() {
        return CHUNK_OVERLAY_ID;
    }

    private void onMappingEvent(MappingEvent mappingEvent) {
        this.api.removeAll(this.getModId(), DisplayType.Polygon);
    }

    public void displayOverlay(String packet) {
        ArrayList<PolygonOverlay> overlayList = new ArrayList<PolygonOverlay>();
        JsonObject node = (JsonObject)new Gson().fromJson(packet, JsonObject.class);
        if (node.get("full") != null) {
            overlayList.addAll(this.buildPolygon(node.get("full").getAsJsonArray(), new ShapeProperties().setFillColor(255).setStrokeWidth(0.0f).setFillOpacity(0.2f)));
        }
        if (node.get("entity") != null) {
            overlayList.addAll(this.buildPolygon(node.get("entity").getAsJsonArray(), new ShapeProperties().setFillColor(0xFF0000).setStrokeWidth(0.0f).setFillOpacity(0.2f)));
        }
        if (node.get("block") != null) {
            overlayList.addAll(this.buildPolygon(node.get("block").getAsJsonArray(), new ShapeProperties().setFillColor(65280).setStrokeWidth(0.0f).setFillOpacity(0.2f)));
        }
        if (node.get("inaccessible") != null) {
            overlayList.addAll(this.buildPolygon(node.get("inaccessible").getAsJsonArray(), new ShapeProperties().setStrokeWidth(0.0f).setFillColor(0xFFFFFF).setFillOpacity(0.2f)));
        }
        ArrayList<Overlay> toRemove = new ArrayList<Overlay>(ClientAPI.INSTANCE.getOverlays(CHUNK_OVERLAY_ID, (ResourceKey<Level>)Minecraft.getInstance().player.level().dimension()).columnKeySet());
        overlayList.forEach(ClientAPI.INSTANCE::show);
        toRemove.forEach(ClientAPI.INSTANCE::remove);
    }

    private List<PolygonOverlay> buildPolygon(JsonArray node, ShapeProperties prop) {
        ArrayList<PolygonOverlay> overlayList = new ArrayList<PolygonOverlay>();
        for (JsonElement area : node) {
            JsonObject obj = area.getAsJsonObject();
            JsonObject outer = obj.get("outerArea").getAsJsonObject();
            ArrayList<BlockPos> points = new ArrayList<BlockPos>();
            ArrayList<MapPolygon> holes = new ArrayList<MapPolygon>();
            for (JsonElement point : outer.get("points").getAsJsonArray()) {
                points.add(BlockPos.of((long)point.getAsLong()));
            }
            if (obj.has("holes")) {
                JsonElement holesnode = obj.get("holes");
                for (JsonElement hole : holesnode.getAsJsonArray()) {
                    ArrayList<BlockPos> holePoints = new ArrayList<BlockPos>();
                    for (JsonElement point : hole.getAsJsonObject().get("points").getAsJsonArray()) {
                        holePoints.add(BlockPos.of((long)point.getAsLong()));
                    }
                    holes.add(new MapPolygon(holePoints));
                }
            }
            PolygonOverlay polygonOverlay = new PolygonOverlay(CHUNK_OVERLAY_ID, Minecraft.getInstance().player.level().dimension(), prop, new MapPolygon(points), holes);
            overlayList.add(polygonOverlay);
        }
        return overlayList;
    }
}

