/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.command;

import com.mojang.authlib.GameProfile;
import java.util.TreeSet;
import journeymap.api.services.EventBus;
import journeymap.api.v2.common.event.common.TeleportEvent;
import journeymap.api.v2.common.waypoint.Waypoint;
import journeymap.client.JourneymapClient;
import journeymap.client.waypoint.ClientWaypointImpl;
import journeymap.common.Journeymap;
import journeymap.common.helper.DimensionHelper;
import journeymap.common.log.LogFormatter;
import net.minecraft.client.Minecraft;
import net.minecraft.client.server.IntegratedServer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.players.NameAndId;
import net.minecraft.server.players.PlayerList;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.ServerLevelData;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class CmdTeleportWaypoint {
    final Minecraft mc = Minecraft.getInstance();
    final ClientWaypointImpl waypoint;

    public CmdTeleportWaypoint(ClientWaypointImpl waypoint) {
        this.waypoint = waypoint;
    }

    public static boolean isPermitted(Minecraft mc) {
        if (mc.getSingleplayerServer() != null) {
            IntegratedServer mcServer = mc.getSingleplayerServer();
            PlayerList configurationManager = null;
            GameProfile profile = null;
            try {
                profile = new GameProfile(mc.player.getUUID(), mc.player.getName().getString());
                configurationManager = mcServer.getPlayerList();
                Journeymap.getLogger().debug("integrated server not null, can send commands: " + configurationManager.isOp(new NameAndId(profile)) + " is tp enabled: " + JourneymapClient.getInstance().getStateHandler().isTeleportEnabled());
                return configurationManager.isOp(new NameAndId(profile)) || JourneymapClient.getInstance().getStateHandler().isTeleportEnabled();
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    if (profile != null && configurationManager != null) {
                        Journeymap.getLogger().debug("Some Error happened: " + mcServer.isSingleplayer() + " : " + ((ServerLevelData)mcServer.getLevel(mc.player.level().dimension()).getLevelData()).isAllowCommands() + " : " + mcServer.getSingleplayerProfile().name().equalsIgnoreCase(profile.name()));
                        return mcServer.isSingleplayer() && ((ServerLevelData)mcServer.getLevel(mc.player.level().dimension()).getLevelData()).isAllowCommands() && mcServer.getSingleplayerProfile().name().equalsIgnoreCase(profile.name());
                    }
                    Journeymap.getLogger().warn("Failed to check teleport permission both ways: " + LogFormatter.toString(e) + ", and profile or configManager were null.");
                }
                catch (Exception e2) {
                    Journeymap.getLogger().warn("Failed to check teleport permission. Both ways failed: " + LogFormatter.toString(e) + ", and " + LogFormatter.toString(e2));
                }
            }
        }
        if (JourneymapClient.getInstance().getStateHandler().isJourneyMapServerConnection()) {
            Journeymap.getLogger().debug("On a server with JM returning: " + JourneymapClient.getInstance().getStateHandler().isTeleportEnabled());
            return JourneymapClient.getInstance().getStateHandler().isTeleportEnabled();
        }
        Journeymap.getLogger().debug("On a server without JM returning true by default");
        return true;
    }

    public void run() {
        TeleportEvent event;
        double z;
        double x;
        if (JourneymapClient.getInstance().getStateHandler().isJourneyMapServerConnection() || Minecraft.getInstance().hasSingleplayerServer()) {
            x = this.waypoint.getRawCenterX();
            z = this.waypoint.getRawCenterZ();
        } else {
            x = this.waypoint.getBlockCenteredX();
            z = this.waypoint.getBlockCenteredZ();
        }
        TreeSet<String> dims = this.waypoint.getDimensions();
        String dim = this.mc.player.level().dimension().location().toString();
        if (!dims.isEmpty() && !dims.contains(dim = this.waypoint.getPos().getPrimaryDimension())) {
            dim = dims.stream().filter(d -> this.mc.player.level().dimension().equals(DimensionHelper.getWorldKeyForName(d))).findFirst().orElse(dims.first());
        }
        if (Level.NETHER.equals(DimensionHelper.getWorldKeyForName(dim)) && Level.NETHER.equals(this.mc.player.level().dimension())) {
            x = this.waypoint.getRawCenterX();
            z = this.waypoint.getRawCenterZ();
        }
        if (!EventBus.post(event = new TeleportEvent((Waypoint)this.waypoint, BlockPos.containing((double)x, (double)this.waypoint.getY(), (double)z), this.mc.player.level().dimension(), DimensionHelper.getWorldKeyForName(dim))).isCancelled()) {
            Vec3 pos = Vec3.upFromBottomCenterOf((Vec3i)event.getPos(), (double)0.0);
            CmdTeleportWaypoint.teleport(pos.x(), (int)pos.y(), pos.z(), event.getDestinationLevel().location().toString(), this.waypoint.getName());
        }
    }

    public static void teleport(BlockPos pos, ResourceKey<Level> dim, @Nullable String name) {
        TeleportEvent event = new TeleportEvent(pos, dim);
        if (!EventBus.post(event).isCancelled()) {
            ResourceKey dimension = event.getDestinationLevel();
            CmdTeleportWaypoint.teleport(event.getPos().getX(), event.getPos().getY(), event.getPos().getZ(), dimension != null ? dimension.location().toString() : null, name);
        }
    }

    public static void teleport(double x, int y, double z, String dim, @Nullable String name) {
        Minecraft mc = Minecraft.getInstance();
        if (JourneymapClient.getInstance().getStateHandler().isJourneyMapServerConnection() || Minecraft.getInstance().hasSingleplayerServer()) {
            JourneymapClient.getInstance().getDispatcher().sendTeleportPacket(x, y, z, dim);
        } else {
            String teleportCommand = JourneymapClient.getInstance().getWaypointProperties().teleportCommand.getAsString();
            Boolean wholeNumbers = JourneymapClient.getInstance().getWaypointProperties().wholeNumberTeleportCoords.get();
            String xLoc = wholeNumbers != false ? Integer.toString((int)x) : String.valueOf(x);
            String zLoc = wholeNumbers != false ? Integer.toString((int)z) : String.valueOf(z);
            if ((teleportCommand = teleportCommand.replace("{name}", mc.player.getName().getString()).replace("{x}", xLoc).replace("{y}", String.valueOf(y)).replace("{z}", zLoc).replace("{wpname}", name != null ? name : "").replace("{dim}", dim)).startsWith("/")) {
                Journeymap.getLogger().debug("Sending slash tp command: {}", (Object)teleportCommand);
                mc.player.connection.sendCommand(teleportCommand.substring(1));
            } else {
                Journeymap.getLogger().debug("Sending non-slash tp command: {}", (Object)teleportCommand);
                mc.player.connection.sendChat(teleportCommand);
            }
        }
    }
}

