/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.event;

import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import journeymap.client.event.NeoForgeEventHandlerManager;
import journeymap.client.event.handlers.KeyEventHandler;
import journeymap.client.event.handlers.keymapping.KeyEvent;
import journeymap.common.Journeymap;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.client.event.ScreenEvent;

@ParametersAreNonnullByDefault
public class NeoForgeKeyEvents
implements KeyEvent,
NeoForgeEventHandlerManager.EventHandler {
    private static final List<KeyMapping> keyList = Lists.newArrayList();
    private final KeyEventHandler keyEventHandler = new KeyEventHandler(this);

    @SubscribeEvent
    public void onGameKeyboardEvent(InputEvent.Key event) {
        int key = event.getKey();
        this.keyEventHandler.onGameKeyboardEvent(key);
    }

    @SubscribeEvent
    public void onGuiKeyboardEvent(ScreenEvent.KeyPressed.Post event) {
        int key = event.getKeyCode();
        boolean success = this.keyEventHandler.onGuiKeyboardEvent(event.getScreen(), key);
        event.setCanceled(success);
    }

    @SubscribeEvent
    public void onGuiMouseEvent(ScreenEvent.MouseButtonPressed.Post event) {
        this.keyEventHandler.onMouseEvent(event.getScreen(), event.getMouseButtonEvent().buttonInfo(), 1);
    }

    @SubscribeEvent
    public void onMouseEvent(InputEvent.MouseButton.Post event) {
        if (Minecraft.getInstance().screen == null) {
            this.keyEventHandler.onMouseEvent(null, event.getMouseButtonInfo(), event.getAction());
        }
    }

    @Override
    public KeyEventHandler getHandler() {
        return this.keyEventHandler;
    }

    @Override
    public KeyMapping register(KeyMapping keyMapping) {
        keyList.add(keyMapping);
        return keyMapping;
    }

    public void onKeyRegisterEvent(RegisterKeyMappingsEvent event) {
        Journeymap.getLogger().info("Registering Keybinds");
        keyList.forEach(arg_0 -> ((RegisterKeyMappingsEvent)event).register(arg_0));
    }
}

