/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.render.draw;

import com.google.common.cache.CacheLoader;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import earcut4j.Earcut;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import journeymap.api.v2.client.display.Context;
import journeymap.api.v2.client.display.PolygonOverlay;
import journeymap.api.v2.client.model.MapPolygon;
import journeymap.api.v2.client.model.ShapeProperties;
import journeymap.api.v2.client.model.TextProperties;
import journeymap.client.data.DataCache;
import journeymap.client.render.JMRenderTypes;
import journeymap.client.render.draw.BaseOverlayDrawStep;
import journeymap.client.render.draw.DrawStep;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.render.map.Renderer;
import journeymap.client.texture.TextureCache;
import journeymap.client.ui.UIManager;
import journeymap.client.ui.minimap.DisplayVars;
import journeymap.client.ui.minimap.Shape;
import journeymap.common.Journeymap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class DrawPolygonStep
extends BaseOverlayDrawStep<PolygonOverlay> {
    protected List<Point2D.Double> fillPoints = new ArrayList<Point2D.Double>();
    protected List<List<Point2D.Double>> strokePoints = new ArrayList<List<Point2D.Double>>();
    protected List<Point2D.Double> texturePoints = new ArrayList<Point2D.Double>();
    private ResourceLocation textureResource;
    private AbstractTexture texture;
    boolean doRender = true;
    boolean onScreen;

    public DrawPolygonStep(PolygonOverlay polygon) {
        super(polygon);
    }

    public void draw(GuiGraphics graphics, PoseStack poseStack, MultiBufferSource.BufferSource buffers, double xOffset, double yOffset, Renderer renderer, double fontScale, double rotation) {
        if (((PolygonOverlay)this.overlay).getOuterArea().getPoints().isEmpty()) {
            this.onScreen = false;
            return;
        }
        this.onScreen = this.isOnScreen(xOffset, yOffset, renderer, rotation);
        if (this.onScreen && this.doRender) {
            this.ensureTexture();
            DrawUtil.drawPolygon(graphics, poseStack, buffers, xOffset, yOffset, this.fillPoints, this.strokePoints, this.texturePoints, this.texture, ((PolygonOverlay)this.overlay).getShapeProperties());
            if (this.isTextInMinimap(renderer)) {
                this.drawText(poseStack, buffers, xOffset, yOffset, renderer, fontScale, 0.0);
            }
        }
    }

    public void setTextureResource(ResourceLocation textureResource) {
        this.textureResource = textureResource;
        if (this.texture != null) {
            this.texture.close();
        }
        this.texture = null;
    }

    public ResourceLocation getTextureResource() {
        return this.textureResource;
    }

    protected void ensureTexture() {
        if (this.textureResource == null || this.texture != null) {
            return;
        }
        try {
            this.texture = TextureCache.getTexture(this.textureResource);
        }
        catch (Exception e) {
            Journeymap.getLogger().error("Error getting PolygonOverlay texture: " + String.valueOf(e), (Throwable)e);
        }
    }

    private boolean isTextInMinimap(Renderer renderer) {
        if (renderer.getUIState().ui == Context.UI.Minimap) {
            Minecraft mc = Minecraft.getInstance();
            DisplayVars dv = UIManager.INSTANCE.getMiniMap().getDisplayVars();
            Point2D.Double centerPoint = renderer.getPixel(mc.player.getX(), mc.player.getZ());
            if (centerPoint == null) {
                return false;
            }
            Rectangle2D.Double centerRect = new Rectangle2D.Double(((Point2D)centerPoint).getX() - (double)(dv.getMinimapWidth() / 2.0f), ((Point2D)centerPoint).getY() - (double)(dv.getMinimapHeight() / 2.0f), dv.getMinimapWidth(), dv.getMinimapHeight());
            if (dv.getShape() == Shape.Circle) {
                return centerPoint.distance(this.labelPosition) < (double)(dv.getMinimapWidth() / 2.0f);
            }
            return centerRect.contains(renderer.getWindowPosition(this.labelPosition));
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void updatePositions(Renderer renderer, double rotation) {
        if (((PolygonOverlay)this.overlay).getOuterArea().getPoints().isEmpty()) {
            return;
        }
        if (Context.UI.Minimap == renderer.getUIState().ui) {
            void var6_8;
            Vec3 playerPos = Minecraft.getInstance().player.position();
            int limit = renderer.getZoom() * (renderer.getGridSize() * 2);
            BlockPos blockPos = (BlockPos)((PolygonOverlay)this.overlay).getOuterArea().getPoints().get(0);
            for (BlockPos point : ((PolygonOverlay)this.overlay).getOuterArea().getPoints()) {
                double distanceToPlayer = point.distToCenterSqr((Position)playerPos);
                if (!(point.distSqr((Vec3i)var6_8) > Mth.square((double)distanceToPlayer))) continue;
                BlockPos blockPos2 = point;
            }
            if (!var6_8.closerThan((Vec3i)Minecraft.getInstance().player.blockPosition(), (double)limit)) {
                this.doRender = false;
                return;
            }
        }
        this.doRender = true;
        List<BlockPos> points = DataCache.INSTANCE.getTriangulation((PolygonOverlay)this.overlay);
        this.fillPoints.clear();
        this.texturePoints.clear();
        for (BlockPos blockPos : points) {
            Point2D.Double pixel = renderer.getBlockPixelInGrid(blockPos);
            if (this.fillPoints.isEmpty()) {
                this.screenBounds.setRect(pixel.x, pixel.y, 1.0, 1.0);
            } else {
                this.screenBounds.add(pixel);
            }
            this.fillPoints.add(pixel);
            this.texturePoints.add(new Point2D.Double(blockPos.getX(), blockPos.getZ()));
        }
        boolean needClockwise = ((PolygonOverlay)this.overlay).getShapeProperties().getStrokePosition() != ShapeProperties.StrokePosition.CENTER;
        this.strokePoints.clear();
        this.strokePoints.add(DrawPolygonStep.toScreen(renderer, ((PolygonOverlay)this.overlay).getOuterArea(), needClockwise, false));
        if (((PolygonOverlay)this.overlay).getHoles() != null) {
            for (MapPolygon hole : ((PolygonOverlay)this.overlay).getHoles()) {
                this.strokePoints.add(DrawPolygonStep.toScreen(renderer, hole, needClockwise, true));
            }
        }
        TextProperties textProperties = ((PolygonOverlay)this.overlay).getTextProperties();
        this.labelPosition.setLocation(this.screenBounds.getCenterX() + (double)textProperties.getOffsetX(), this.screenBounds.getCenterY() + (double)textProperties.getOffsetY());
    }

    private static List<Point2D.Double> toScreen(@NotNull Renderer renderer, @NotNull MapPolygon polygon, boolean needClockwise, boolean hole) {
        ArrayList<Point2D.Double> points = new ArrayList<Point2D.Double>();
        if (polygon.getPoints().isEmpty()) {
            return points;
        }
        int direction = 0;
        BlockPos prev = (BlockPos)polygon.getPoints().getLast();
        for (BlockPos pos : polygon.getPoints()) {
            points.add(renderer.getBlockPixelInGrid(pos));
            if (!needClockwise) continue;
            direction += (pos.getX() + prev.getX()) * (pos.getZ() - prev.getZ());
            prev = pos;
        }
        if (needClockwise && direction < 0 != hole) {
            Collections.reverse(points);
        }
        return points;
    }

    public static List<MapPolygon> triangulate(@NotNull PolygonOverlay overlay) {
        List holesList = Optional.ofNullable(overlay.getHoles()).orElse(new ArrayList());
        List blockPoints = Stream.concat(overlay.getOuterArea().getPoints().stream(), holesList.stream().flatMap(hole -> hole.getPoints().stream())).collect(Collectors.toList());
        double[] points = new double[blockPoints.size() * 2];
        for (int index = 0; index < blockPoints.size(); ++index) {
            points[index * 2] = ((BlockPos)blockPoints.get(index)).getX();
            points[index * 2 + 1] = ((BlockPos)blockPoints.get(index)).getZ();
        }
        int[] holes = new int[holesList.size()];
        int holeIndex = overlay.getOuterArea().getPoints().size();
        for (int index = 0; index < holesList.size(); ++index) {
            holes[index] = holeIndex;
            holeIndex += ((MapPolygon)holesList.get(index)).getPoints().size();
        }
        List<Integer> triangles = Earcut.earcut(points, holes, 2);
        ArrayList<MapPolygon> trianglePolys = new ArrayList<MapPolygon>();
        for (int index = 0; index < triangles.size(); index += 3) {
            ArrayList<BlockPos> trianglePoints = new ArrayList<BlockPos>();
            trianglePoints.add((BlockPos)blockPoints.get(triangles.get(index + 2)));
            trianglePoints.add((BlockPos)blockPoints.get(triangles.get(index + 1)));
            trianglePoints.add((BlockPos)blockPoints.get(triangles.get(index)));
            trianglePolys.add(new MapPolygon(trianglePoints));
        }
        return trianglePolys;
    }

    @Override
    public void draw(GuiGraphics graphics, double xOffset, double yOffset, Renderer renderer, double fontScale, double rotation) {
    }

    protected void drawText(PoseStack poseStack, MultiBufferSource.BufferSource buffers, double xOffset, double yOffset, Renderer renderer, double fontScale, double rotation) {
        TextProperties textProperties = ((PolygonOverlay)this.overlay).getTextProperties();
        if (textProperties.isActiveIn(renderer.getUIState())) {
            double y;
            double x;
            if (this.labelPosition != null) {
                if (this.labelLines == null) {
                    this.updateTextFields();
                }
                if (this.labelLines != null) {
                    x = this.labelPosition.x + xOffset;
                    y = this.labelPosition.y + yOffset;
                    DrawPolygonStep.drawLabels(poseStack, buffers, this.labelLines, x, y, DrawUtil.HAlign.Center, DrawUtil.VAlign.Middle, textProperties.getBackgroundColor(), textProperties.getBackgroundOpacity(), textProperties.getColor(), textProperties.getOpacity(), (double)textProperties.getScale() * fontScale, textProperties.hasFontShadow(), rotation);
                }
            }
            if (renderer.getUIState().ui != Context.UI.Minimap && this.titlePosition != null) {
                if (this.titleLines == null) {
                    this.updateTextFields();
                }
                if (this.titleLines != null) {
                    x = this.titlePosition.x + 5.0 + xOffset;
                    y = this.titlePosition.y + yOffset;
                    DrawPolygonStep.drawLabels(poseStack, buffers, this.titleLines, x, y, DrawUtil.HAlign.Right, DrawUtil.VAlign.Above, textProperties.getBackgroundColor(), textProperties.getBackgroundOpacity(), textProperties.getColor(), textProperties.getOpacity(), (double)textProperties.getScale() * fontScale, textProperties.hasFontShadow(), rotation);
                }
            }
        }
    }

    public static void drawLabels(PoseStack poseStack, MultiBufferSource.BufferSource buffers, String[] lines, double x, double y, DrawUtil.HAlign hAlign, DrawUtil.VAlign vAlign, Integer bgColor, float bgAlpha, Integer color, float alpha, double fontScale, boolean fontShadow, double rotation) {
        if (lines.length == 0) {
            return;
        }
        if (lines.length == 1) {
            if (bgColor != null && bgAlpha > 0.0f) {
                DrawUtil.drawBatchLabel(poseStack, (Component)Component.literal((String)lines[0]), DrawStep.Pass.TextBG, (MultiBufferSource)buffers, x, y, hAlign, vAlign, bgColor, bgAlpha, color, alpha, fontScale, fontShadow, rotation);
            }
            DrawUtil.drawBatchLabel(poseStack, (Component)Component.literal((String)lines[0]), DrawStep.Pass.Text, (MultiBufferSource)buffers, x, y, hAlign, vAlign, bgColor, bgAlpha, color, alpha, fontScale, fontShadow, rotation);
            return;
        }
        Font fontRenderer = Minecraft.getInstance().font;
        double vpad = fontRenderer.isBidirectional() ? 0.0 : (fontShadow ? 6.0 : 4.0);
        double hpad = 4.0;
        Objects.requireNonNull(fontRenderer);
        double lineHeight = 9.0 * fontScale;
        double bgHeight = lineHeight * (double)lines.length + vpad;
        double bgWidth = 0.0;
        if (bgColor != null && bgAlpha > 0.0f) {
            for (String line : lines) {
                bgWidth = Math.max(bgWidth, (double)fontRenderer.width(line) * fontScale);
            }
            if (bgWidth % 2.0 == 0.0) {
                bgWidth += 1.0;
            }
        }
        bgWidth += 4.0;
        double rectX = x;
        double rectY = y;
        switch (hAlign) {
            case Left: {
                rectX = x - bgWidth + 2.0;
                break;
            }
            case Center: {
                rectX = (float)(x - (Math.max(1.0, bgWidth) / 2.0 + fontScale) + (fontScale > 1.0 ? 0.5 : 0.0));
                break;
            }
            case Right: {
                rectX = x - 2.0 - 0.5;
            }
        }
        switch (vAlign) {
            case Above: {
                rectY = (y -= lineHeight * (double)lines.length) - bgHeight / 2.0 - vpad / 2.0;
                break;
            }
            case Middle: {
                rectY = (y -= bgHeight / 2.0) - vpad / 2.0 - 5.0 * fontScale;
                break;
            }
            case Below: {
                rectY = y;
            }
        }
        if (bgColor != null && bgAlpha > 0.0f) {
            VertexConsumer vertexBuilder = buffers.getBuffer(JMRenderTypes.RECTANGLE_RENDER_TYPE);
            DrawUtil.drawRectangle(poseStack, vertexBuilder, rectX, rectY, bgWidth, bgHeight, bgColor, bgAlpha);
        }
        for (String line : lines) {
            DrawUtil.drawBatchLabel(poseStack, (Component)Component.literal((String)line), DrawStep.Pass.Text, (MultiBufferSource)buffers, x, y, hAlign, vAlign, bgColor, bgAlpha, color, alpha, fontScale, fontShadow, rotation);
            y += lineHeight;
        }
    }

    public static class SimpleCacheLoader
    extends CacheLoader<PolygonOverlay, DrawPolygonStep> {
        public DrawPolygonStep load(PolygonOverlay overlay) throws Exception {
            return new DrawPolygonStep(overlay);
        }
    }

    public static class TriangulationCacheLoader
    extends CacheLoader<PolygonOverlay, List<BlockPos>> {
        public List<BlockPos> load(PolygonOverlay overlay) throws Exception {
            return DrawPolygonStep.triangulate(overlay).stream().flatMap(poly -> poly.getPoints().stream()).collect(Collectors.toList());
        }
    }
}

