/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.component;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import journeymap.client.event.handlers.keymapping.KeyModifier;
import journeymap.client.ui.component.ScrollListPane;
import journeymap.client.ui.component.Slot;
import net.minecraft.client.InputType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;

public class MultiSelectableScrollListPane<T extends Slot>
extends ScrollListPane<T> {
    private final List<Slot> selectedElements = new ArrayList<Slot>();

    public MultiSelectableScrollListPane(Minecraft mc, int x, int y, int width, int height, int slotHeight) {
        super(mc, x, y, width, height, slotHeight);
    }

    public int getTotalItemHeight() {
        return this.getItemHeight() * this.getItemCount() + 4;
    }

    public void selectAll() {
        if (this.children().isEmpty()) {
            return;
        }
        this.selectedElements.clear();
        this.selectedElements.addAll(this.children());
        if (this.getSelected() == null) {
            super.setSelected((AbstractSelectionList.Entry)((Slot)((Object)this.children().get(0))));
        }
    }

    public List<Slot> getAllSelected() {
        return this.selectedElements;
    }

    public int getSelectedCount() {
        return this.selectedElements.size();
    }

    public void setSelected(@Nullable Slot slot) {
        if (this.minecraft.getLastInputType().equals((Object)InputType.KEYBOARD_TAB)) {
            super.setSelected((AbstractSelectionList.Entry)slot);
            this.selectedElements.remove((Object)slot);
            this.selectedElements.add(slot);
            return;
        }
        if (slot == null) {
            this.selectedElements.clear();
        } else if (KeyModifier.CONTROL.isActive(null)) {
            if (this.selectedElements.remove((Object)slot)) {
                if (this.selectedElements.isEmpty()) {
                    super.setSelected(null);
                } else if (this.getSelected() == slot) {
                    super.setSelected((AbstractSelectionList.Entry)this.selectedElements.get(0));
                }
                return;
            }
            this.selectedElements.add(slot);
        } else {
            this.selectedElements.clear();
            this.selectedElements.add(slot);
        }
        super.setSelected((AbstractSelectionList.Entry)slot);
    }

    public void setSelectedAndKeepCurrent(Slot slot) {
        if (!this.selectedElements.contains((Object)slot)) {
            this.selectedElements.add(slot);
        }
    }

    @Override
    public boolean isSelectedItem(int index) {
        return this.selectedElements.contains(this.children().get(index));
    }

    public boolean isSelectedItem(Slot slot) {
        return this.selectedElements.contains((Object)slot);
    }

    public void renderItem(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick, Slot<T> entry) {
        if (this.entriesCanBeSelected() && this.getSelected() == entry) {
            int frameColor = this.isFocused() ? -1 : -8355712;
            this.renderSelection(guiGraphics, entry, frameColor);
        }
        entry.renderContent(guiGraphics, mouseX, mouseY, Objects.equals(this.getHovered(), entry), partialTick);
    }

    @Override
    public void renderBackground(GuiGraphics graphics, PoseStack poseStack, int i, int j, float f) {
    }
}

