/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.waypointmanager.group;

import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import journeymap.api.services.EventBus;
import journeymap.api.v2.client.util.tuple.Tuple2;
import journeymap.api.v2.common.event.common.WaypointGroupEvent;
import journeymap.api.v2.common.waypoint.WaypointGroup;
import journeymap.client.Constants;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.texture.TextureCache;
import journeymap.client.ui.component.Slot;
import journeymap.client.ui.component.buttons.BasicImageButton;
import journeymap.client.ui.component.popupscreenbutton.ImagePopupButton;
import journeymap.client.ui.component.widgets.StringWidget;
import journeymap.client.ui.option.SlotMetadata;
import journeymap.client.ui.waypointmanager.ManagerSlot;
import journeymap.client.ui.waypointmanager.group.DeleteConfirmGroupPopup;
import journeymap.client.ui.waypointmanager.group.EditGroupPopup;
import journeymap.common.waypoint.WaypointGroupStore;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.layouts.FrameLayout;
import net.minecraft.client.gui.layouts.Layout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LayoutSettings;
import net.minecraft.client.gui.layouts.LinearLayout;
import net.minecraft.client.gui.layouts.SpacerElement;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.input.CharacterEvent;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;
import org.jetbrains.annotations.NotNull;

public class GroupSlot
extends ManagerSlot {
    private final WaypointGroup group;
    private int width;
    private int height;
    boolean selected = false;
    private int x;
    private int y;
    private final boolean isAll;
    private ManagerSlot.ToolTipMeta tooltips;
    private LinearLayout layout = LinearLayout.horizontal();

    public GroupSlot(WaypointGroup group, int width, int height) {
        this.group = group;
        this.width = width;
        this.height = height;
        this.buildTooltips();
        this.isAll = WaypointGroupStore.ALL.getGuid().equals(group.getGuid());
    }

    @Override
    public void repositionElements() {
        this.layout.arrangeElements();
        FrameLayout.centerInRectangle((LayoutElement)this.layout, (ScreenRectangle)this.getRectangle());
    }

    @Override
    public void init() {
        Font font = Minecraft.getInstance().font;
        int count = this.group.getWaypointIds().size();
        String name = this.group.getName();
        this.layout = LinearLayout.horizontal();
        this.layout.spacing(1);
        if (this.isAll) {
            this.layout.addChild((LayoutElement)new SpacerElement(14, 14));
        } else {
            ImagePopupButton deleteButton = (ImagePopupButton)this.layout.addChild(new ImagePopupButton<Tuple2>(14, 14, TextureCache.X_OUTLINE_SPRITE, ChatFormatting.RED.getColor(), (Component)Component.translatable((String)"jm.waypoint.delete_group.label"), () -> new DeleteConfirmGroupPopup(this.group), this::deleteGroup));
            deleteButton.setTooltip(Tooltip.create((Component)Component.translatable((String)"jm.waypoint.delete_group.label")));
        }
        if (this.isAll) {
            this.layout.addChild((LayoutElement)new SpacerElement(14, 14));
            this.layout.addChild((LayoutElement)new SpacerElement(14, 14));
        } else {
            ImagePopupButton editButton = (ImagePopupButton)this.layout.addChild(new ImagePopupButton<WaypointGroupEvent>(14, 14, TextureCache.OPTIONS_SPRITE, (Component)Component.translatable((String)"jm.waypoint.group.edit.label"), () -> new EditGroupPopup((Component)Component.translatable((String)"jm.waypoint.group.edit.label"), this.group), b -> {}));
            editButton.setTooltip(Tooltip.create((Component)Component.translatable((String)"jm.waypoint.group.edit.label")));
            ((BasicImageButton)this.layout.addChild((LayoutElement)new BasicImageButton(14, 14, TextureCache.POWER_SPRITE, (Integer)(this.group.isEnabled() ? 65280 : 0xFF0000), this::onEnable, this.getEnabledComponent(this.group.isEnabled())))).setTexWidth(10).setTexHeight(10).setXOffset(2).setYOffset(2).setTooltip(Tooltip.create((Component)this.getEnabledComponent(this.group.isEnabled())));
        }
        this.layout.addChild((LayoutElement)new StringWidget((Component)Component.literal((String)name), font.width("XXXXXXXX"), font).alignLeft(), LayoutSettings.defaults().alignVerticallyMiddle());
        this.layout.addChild((LayoutElement)new StringWidget((Component)Component.literal((String)String.format("%s", count)), font.width("000"), font).alignRight(), LayoutSettings::alignVerticallyMiddle);
        this.repositionElements();
    }

    private void onEnable(Button button) {
        this.group.setEnabled(!this.group.isEnabled());
        EventBus.post(new WaypointGroupEvent(this.group, WaypointGroupEvent.Context.UPDATE));
    }

    private Component getEnabledComponent(boolean enabled) {
        return enabled ? Component.translatable((String)"jm.waypoint.disable_group") : Component.translatable((String)"jm.waypoint.enable_group");
    }

    @Override
    public Layout getLayout() {
        return this.layout;
    }

    private void buildTooltips() {
        ArrayList<FormattedCharSequence> tooltip = new ArrayList<FormattedCharSequence>();
        tooltip.add(FormattedCharSequence.forward((String)this.group.getName(), (Style)Style.EMPTY.applyFormat(ChatFormatting.AQUA)));
        if (this.group.getDescription() != null) {
            tooltip.add(FormattedCharSequence.forward((String)this.group.getDescription(), (Style)Style.EMPTY.applyFormat(ChatFormatting.AQUA)));
        }
        tooltip.add(FormattedCharSequence.forward((String)Constants.getString("jm.waypoint.group.edit.waypoints", this.group.getWaypointIds().size()), (Style)Style.EMPTY.applyFormat(ChatFormatting.GREEN)));
        if (this.group.getTag() != null && !this.group.getTag().isEmpty()) {
            tooltip.add(FormattedCharSequence.forward((String)Constants.getString("jm.waypoint.group.edit.tag", this.group.getTag()), (Style)Style.EMPTY.applyFormat(ChatFormatting.GREEN)));
        }
        tooltip.add(FormattedCharSequence.forward((String)Constants.getString("jm.waypoint.group.edit.id", this.group.getGuid()), (Style)Style.EMPTY.applyFormat(ChatFormatting.BLUE)));
        this.tooltips = new ManagerSlot.ToolTipMeta(tooltip);
    }

    private void editGroup(Button button) {
        EditGroupPopup popup = new EditGroupPopup((Component)Component.translatable((String)"jm.waypoint.group.edit.label"), this.group);
        popup.display();
    }

    protected void deleteGroup(Tuple2<Boolean, Boolean> tuple2) {
        EventBus.post(new WaypointGroupEvent(this.group, WaypointGroupEvent.Context.DELETED, ((Boolean)tuple2.b()).booleanValue()));
    }

    @Override
    public int compareTo(@NotNull ManagerSlot o) {
        return 0;
    }

    public boolean charTyped(CharacterEvent event) {
        return false;
    }

    public boolean keyPressed(KeyEvent event) {
        return false;
    }

    @Override
    public Collection<SlotMetadata<GroupSlot>> getMetadata() {
        return List.of();
    }

    @Override
    public List<? extends Slot> getChildSlots(int listWidth, int columnWidth) {
        return new ArrayList();
    }

    @Override
    public SlotMetadata getLastPressed() {
        return null;
    }

    @Override
    public SlotMetadata getCurrentTooltip() {
        return null;
    }

    @Override
    public SlotMetadata getCurrentTooltip(int mouseX, int mouseY) {
        AtomicBoolean showTooltip = new AtomicBoolean(true);
        this.layout.visitWidgets(widget -> {
            Button button;
            if (widget instanceof Button && (button = (Button)widget).isHovered()) {
                showTooltip.set(false);
            }
        });
        return showTooltip.get() ? this.tooltips : null;
    }

    @Override
    public void setEnabled(boolean enabled) {
    }

    @Override
    public int getColumnWidth() {
        return 0;
    }

    @Override
    public boolean contains(SlotMetadata slotMetadata) {
        return false;
    }

    public void renderContent(GuiGraphics graphics, int mouseX, int mouseY, boolean hovered, float partialTicks) {
        this.x = this.getContentX();
        this.y = this.getContentY();
        this.width = this.getContentWidth();
        this.height = this.getContentHeight();
        this.layout.setX(this.x + 1);
        this.layout.setY(this.y + 1);
        Integer color = hovered ? backgroundHover : background;
        float alpha = hovered ? 1.0f : 0.4f;
        DrawUtil.drawRectangle(graphics, this.x, this.y, this.width, this.height, color, alpha);
        if (this.selected) {
            DrawUtil.drawRectangle(graphics, this.x, this.y, this.width, this.height, backgroundHover, 1.0f);
        }
        this.layout.visitWidgets(widget -> widget.render(graphics, mouseX, mouseY, partialTicks));
        if (this.group.colorOverride() && this.group.getColor() != null) {
            this.outline(graphics, this.x - 1, this.y - 1, this.width + 1, this.height + 1, this.group.getColor(), alpha * 2.0f);
        }
    }

    public void renderTransferStatus(GuiGraphics graphics, boolean transferable) {
        int color = transferable ? 65280 : 0xFF0000;
        DrawUtil.drawRectangle(graphics, this.x, this.y, this.width, this.height, color, 0.4f);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        long clickTime = Util.getMillis();
        boolean bl = this.doubleclick = clickTime - this.lastClickTime < 250L && this.lastClickButton == button;
        if (button == 1 || this.doubleclick) {
            if (this.doubleclick) {
                this.editGroup(null);
            }
            this.lastClickTime = clickTime;
            this.lastClickButton = button;
            return true;
        }
        this.selected = this.isMouseOver(mouseX, mouseY);
        this.lastClickTime = clickTime;
        this.lastClickButton = button;
        return this.selected;
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public boolean mouseDragged(MouseButtonEvent event, double dragX, double dragY) {
        return super.mouseDragged(event, dragX, dragY);
    }

    public WaypointGroup getGroup() {
        return this.group;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("group", (Object)this.group.getName()).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GroupSlot groupSlot = (GroupSlot)o;
        return Objects.equals(this.group.getGuid(), groupSlot.group.getGuid());
    }

    public int hashCode() {
        return Objects.hash(this.group);
    }
}

