/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.waypointmanager.notification;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import journeymap.client.Constants;
import journeymap.client.ui.component.buttons.CheckBox;
import journeymap.client.ui.component.popupscreenbutton.PopupButtonScreen;
import journeymap.client.ui.component.widgets.StringWidget;
import journeymap.client.ui.waypointmanager.notification.NotificationPanel;
import journeymap.client.ui.waypointmanager.notification.WaypointNotificationSlot;
import journeymap.client.waypoint.ClientWaypointImpl;
import journeymap.common.waypoint.WaypointStore;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.FrameLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LayoutSettings;
import net.minecraft.client.gui.layouts.LinearLayout;
import net.minecraft.client.gui.layouts.SpacerElement;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;

public class NotificationScreen
extends PopupButtonScreen<List<ClientWaypointImpl>> {
    private NotificationPanel<WaypointNotificationSlot> waypointPanel;
    private List<WaypointNotificationSlot> slots;

    public NotificationScreen(Component title) {
        super(title);
    }

    @Override
    protected void repositionElements() {
        this.layout.arrangeElements();
        this.waypointPanel.repositionSlots();
        this.waypointPanel.updateSize(250, 125, 0, 0);
        this.layout.arrangeElements();
        FrameLayout.centerInRectangle((LayoutElement)this.layout, (ScreenRectangle)this.getRectangle());
        this.waypointPanel.mouseScrolled(1.0, 1.0, 1.0, 1.0);
    }

    protected void init() {
        this.slots = this.buildSlots();
        this.waypointPanel = new NotificationPanel(this.minecraft, 0, 0, 20);
        LinearLayout headerLayout = LinearLayout.horizontal();
        LinearLayout bottomButtonsLayout = LinearLayout.horizontal().spacing(10);
        this.layout.addChild((LayoutElement)((StringWidget)LinearLayout.horizontal().addChild((LayoutElement)new StringWidget((Component)this.title.copy().withStyle(new ChatFormatting[]{ChatFormatting.AQUA, ChatFormatting.UNDERLINE}), 200, this.font))), LayoutSettings::alignHorizontallyCenter);
        this.layout.addChild((LayoutElement)headerLayout);
        this.layout.addChild(this.waypointPanel);
        this.layout.addChild((LayoutElement)bottomButtonsLayout, LayoutSettings::alignHorizontallyCenter);
        this.layout.spacing(6);
        CheckBox selectAllCheckBox = new CheckBox(Constants.getString("jm.colorpalette.select_all"), false, this::onSelectAll);
        selectAllCheckBox.setTooltip(Tooltip.create((Component)Component.translatable((String)"jm.common.waypoint.select_all")));
        headerLayout.addChild((LayoutElement)selectAllCheckBox);
        headerLayout.addChild((LayoutElement)new SpacerElement(75, 0));
        headerLayout.addChild((LayoutElement)new StringWidget((Component)Component.translatable((String)"jm.common.waypoint.notification.from").withStyle(ChatFormatting.UNDERLINE), 40, this.font));
        bottomButtonsLayout.addChild((LayoutElement)Button.builder((Component)Component.translatable((String)"jm.common.waypoint.notification.import"), this::importSelected).width(20 + this.font.width((FormattedText)Component.translatable((String)"jm.common.waypoint.notification.import"))).build());
        bottomButtonsLayout.addChild((LayoutElement)Button.builder((Component)Component.translatable((String)"jm.common.cancel"), this::cancel).width(20 + this.font.width((FormattedText)Component.translatable((String)"jm.common.cancel"))).build());
        this.layout.visitWidgets(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget((GuiEventListener)x$0);
        });
        this.waypointPanel.setSlots(this.slots);
        this.waypointPanel.initSlots();
        this.waypointPanel.visitSlots(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addWidget((GuiEventListener)x$0);
        });
        this.repositionElements();
    }

    private void cancel(Button button) {
        this.onClose();
    }

    private void importSelected(Button button) {
        List<ClientWaypointImpl> list = this.waypointPanel.getRootSlots().stream().filter(WaypointNotificationSlot::isChecked).map(WaypointNotificationSlot::getWaypoint).toList();
        this.setResponseAndClose(list);
    }

    private void onSelectAll(Button button) {
        Boolean toggled = ((CheckBox)button).getToggled();
        this.waypointPanel.getRootSlots().forEach(slot -> slot.setChecked(toggled));
    }

    protected void renderPopupScreen(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.renderPopupScreen(graphics, mouseX, mouseY, partialTicks);
        Optional child = this.waypointPanel.getChildAt(mouseX, mouseY);
        if (child.isPresent()) {
            List lastTooltip = this.waypointPanel.lastTooltip;
            long lastTooltipTime = this.waypointPanel.lastTooltipTime;
            if (this.waypointPanel.lastTooltip != null && this.waypointPanel.lastTooltip.equals(lastTooltip)) {
                this.waypointPanel.lastTooltipTime = lastTooltipTime;
                if (System.currentTimeMillis() - this.waypointPanel.lastTooltipTime > this.waypointPanel.hoverDelay) {
                    graphics.setTooltipForNextFrame(this.font, this.waypointPanel.lastTooltip, mouseX, mouseY + 15);
                }
            }
        }
    }

    protected List<WaypointNotificationSlot> buildSlots() {
        ArrayList<WaypointNotificationSlot> list = new ArrayList<WaypointNotificationSlot>();
        WaypointStore.getInstance().getExternalWaypoints().getXaeroWaypoints().forEach(wp -> {});
        return list;
    }
}

