/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.waypointmanager.notification;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import journeymap.client.Constants;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.ui.component.Slot;
import journeymap.client.ui.component.buttons.CheckBox;
import journeymap.client.ui.component.widgets.StringWidget;
import journeymap.client.ui.option.SlotMetadata;
import journeymap.client.ui.waypointmanager.ManagerSlot;
import journeymap.client.waypoint.ClientWaypointImpl;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.layouts.FrameLayout;
import net.minecraft.client.gui.layouts.Layout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LayoutSettings;
import net.minecraft.client.gui.layouts.LinearLayout;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;
import org.jetbrains.annotations.NotNull;

public class WaypointNotificationSlot
extends ManagerSlot {
    private LinearLayout layout = LinearLayout.horizontal();
    private final ClientWaypointImpl waypoint;
    private final String from;
    private CheckBox checkBox;
    private boolean checked = false;
    private ManagerSlot.ToolTipMeta tooltip;

    public WaypointNotificationSlot(ClientWaypointImpl waypoint, String from) {
        this.from = from;
        this.waypoint = waypoint;
    }

    @Override
    public void repositionElements() {
        this.layout.arrangeElements();
        FrameLayout.centerInRectangle((LayoutElement)this.layout, (ScreenRectangle)this.getRectangle());
    }

    @Override
    public void init() {
        Font font = Minecraft.getInstance().font;
        this.tooltip = this.getToolTip();
        this.checkBox = (CheckBox)this.layout.addChild((LayoutElement)new CheckBox("", false, this::checked), LayoutSettings::alignHorizontallyRight);
        this.layout.addChild((LayoutElement)new StringWidget((Component)Component.literal((String)this.waypoint.getName()), 120, font).alignLeft(), LayoutSettings::alignVerticallyMiddle);
        this.layout.addChild((LayoutElement)new StringWidget((Component)Component.literal((String)this.from), 85, font).alignLeft(), LayoutSettings::alignVerticallyMiddle);
        this.repositionElements();
    }

    private ManagerSlot.ToolTipMeta getToolTip() {
        BlockPos pos = this.waypoint.getBlockPos();
        ArrayList<FormattedCharSequence> list = new ArrayList<FormattedCharSequence>();
        list.add(this.buildTooltip(Constants.getString("jm.common.waypoint.notification.name.label"), this.waypoint.getName()));
        list.add(this.buildTooltip(Constants.getString("jm.common.waypoint.notification.dim.label"), this.waypoint.getPrimaryDimension()));
        list.add(this.buildTooltip(Constants.getString("jm.common.waypoint.notification.block.label"), "[x:" + pos.getX() + ", y:" + pos.getY() + ", z:" + pos.getZ() + "]"));
        list.add(this.buildTooltip(Constants.getString("jm.common.waypoint.notification.group.label"), this.waypoint.getGroupId()));
        list.add(this.buildTooltip(Constants.getString("jm.common.waypoint.notification.shared_by.label"), Constants.getString("jm.common.waypoint.notification.shared_by_from.label", this.from)));
        return new ManagerSlot.ToolTipMeta(list);
    }

    private FormattedCharSequence buildTooltip(String key, String value) {
        return FormattedCharSequence.composite((FormattedCharSequence[])new FormattedCharSequence[]{FormattedCharSequence.forward((String)key, (Style)Style.EMPTY.applyFormats(new ChatFormatting[]{ChatFormatting.AQUA, ChatFormatting.UNDERLINE})), FormattedCharSequence.forward((String)" ", (Style)Style.EMPTY), FormattedCharSequence.forward((String)value, (Style)Style.EMPTY.applyFormat(ChatFormatting.GREEN))});
    }

    @Override
    public Layout getLayout() {
        return this.layout;
    }

    public void renderContent(GuiGraphics graphics, int mouseX, int mouseY, boolean hovered, float partialTicks) {
        int x = this.getContentX();
        int y = this.getContentY();
        int rowWidth = this.getContentWidth();
        int itemHeight = this.getContentHeight();
        this.layout.setX(x + 3);
        this.layout.setY(y + 3);
        DrawUtil.drawRectangle(graphics, x, y, rowWidth - 5, itemHeight, 0, 0.25f);
        this.outline(graphics, x, y, rowWidth - 5, itemHeight, 0xC0C0C0, 0.25f);
        this.layout.visitWidgets(widget -> widget.render(graphics, mouseX, mouseY, partialTicks));
    }

    private void checked(Button button) {
        this.setChecked(((CheckBox)button).getToggled());
    }

    public boolean isChecked() {
        return this.checked;
    }

    public ClientWaypointImpl getWaypoint() {
        return this.waypoint;
    }

    public void setChecked(boolean checked) {
        this.checked = checked;
        this.checkBox.setToggled(checked);
    }

    @Override
    public Collection<SlotMetadata> getMetadata() {
        return null;
    }

    @Override
    public List<? extends Slot> getChildSlots(int listWidth, int columnWidth) {
        return null;
    }

    @Override
    public SlotMetadata getLastPressed() {
        return null;
    }

    @Override
    public SlotMetadata getCurrentTooltip() {
        AtomicBoolean showTooltip = new AtomicBoolean(true);
        this.layout.visitWidgets(widget -> {
            Button button;
            if (widget instanceof Button && (button = (Button)widget).isHovered()) {
                showTooltip.set(false);
            }
        });
        return showTooltip.get() ? this.tooltip : null;
    }

    @Override
    public void setEnabled(boolean enabled) {
    }

    @Override
    public boolean contains(SlotMetadata slotMetadata) {
        return false;
    }

    @Override
    public int compareTo(@NotNull ManagerSlot o) {
        return 0;
    }
}

