/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.waypoint;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import journeymap.api.common.waypoint.WaypointFactoryImpl;
import journeymap.api.v2.common.waypoint.Waypoint;
import journeymap.client.Constants;
import journeymap.common.Journeymap;
import journeymap.common.helper.DimensionHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.StringUtils;

public class WaypointParser {
    public static String[] QUOTES = new String[]{"'", "\""};
    public static Pattern PATTERN = Pattern.compile("(\\w+\\s*:\\s*-?[\\w\\d\\s'\"]+,\\s*)+(\\w+\\s*:\\s*-?[\\w\\d\\s'\"]+)", 2);
    private static Pattern TEXT_BETWEEN_QUOTES = Pattern.compile("\".*?\"|'.*?'|`.*`");

    public static List<String> getWaypointStrings(String line) {
        int idx;
        String wpStr;
        String sanitized = line == null ? null : line.replaceAll("<[^>]*>", "").trim();
        ArrayList<CallSite> list = null;
        String[] candidates = StringUtils.substringsBetween((String)sanitized, (String)"[", (String)"]");
        if (candidates != null) {
            for (String candidate : candidates) {
                if (!PATTERN.matcher(candidate).find() || WaypointParser.parse(candidate) == null) continue;
                if (list == null) {
                    list = new ArrayList(1);
                }
                list.add((CallSite)((Object)("[" + candidate + "]")));
            }
        }
        if (list == null && sanitized != null && sanitized.contains("xaero-waypoint:") && !(wpStr = sanitized.substring(idx = sanitized.indexOf("xaero-waypoint:")).trim()).isEmpty()) {
            list = new ArrayList<CallSite>(1);
            list.add((CallSite)((Object)wpStr));
        }
        return list;
    }

    static List<Waypoint> getWaypoints(String line) {
        String sanitized = line == null ? null : line.replaceAll("<[^>]*>", "").trim();
        ArrayList<Waypoint> list = null;
        String[] candidates = StringUtils.substringsBetween((String)sanitized, (String)"[", (String)"]");
        if (candidates != null) {
            for (String candidate : candidates) {
                Waypoint waypoint;
                if (!PATTERN.matcher(candidate).find() || (waypoint = WaypointParser.parse(candidate)) == null) continue;
                if (list == null) {
                    list = new ArrayList<Waypoint>(1);
                }
                list.add(waypoint);
            }
        }
        return list;
    }

    public static Waypoint parse(String original) {
        ParsedWaypoint wp = ParsedWaypoint.parse(original);
        String name = wp.name;
        String dim = wp.dim;
        if (wp.x != null && wp.z != null) {
            if (name == null) {
                name = String.format("%s,%s", wp.x, wp.z);
            }
            if (dim == null) {
                dim = Minecraft.getInstance() == null ? "minecraft:overworld" : DimensionHelper.getDimKeyName((ResourceKey<Level>)Minecraft.getInstance().level.dimension());
            }
            return WaypointFactoryImpl.createWaypoint("journeymap", new BlockPos(wp.x.intValue(), wp.y, wp.z.intValue()), name, dim, wp.showDeviation);
        }
        return null;
    }

    public static Component parseChatForWaypoints(Component component) {
        List<String> matches = WaypointParser.getWaypointStrings(component.getString());
        MutableComponent response = null;
        if (matches != null) {
            boolean changed = false;
            ComponentContents componentContents = component.getContents();
            if (componentContents instanceof TranslatableContents) {
                String[] strings;
                TranslatableContents contents = (TranslatableContents)componentContents;
                Object[] formatArgs = contents.getArgs();
                for (int i = 0; i < formatArgs.length && !matches.isEmpty(); ++i) {
                    Component result;
                    Object arg;
                    if (formatArgs[i] instanceof Component) {
                        arg = (Component)formatArgs[i];
                        result = WaypointParser.addWaypointMarkup(arg.getString(), matches);
                        if (result == null) continue;
                        formatArgs[i] = result;
                        changed = true;
                        continue;
                    }
                    if (!(formatArgs[i] instanceof String) || (result = WaypointParser.addWaypointMarkup((String)(arg = (String)formatArgs[i]), matches)) == null) continue;
                    formatArgs[i] = result;
                    changed = true;
                }
                if (changed) {
                    response = Component.translatable((String)contents.getKey(), (Object[])formatArgs);
                } else if (!matches.isEmpty() && (strings = component.getString().split(":")).length > 1) {
                    Component result = WaypointParser.addWaypointMarkup(matches.getFirst(), matches);
                    response = Component.translatable((String)"chat.type.text", (Object[])new Object[]{strings[0], result});
                }
            } else if (component instanceof MutableComponent) {
                MutableComponent mutableComponent = (MutableComponent)component;
                for (Component content : mutableComponent.getSiblings()) {
                    Component result = WaypointParser.addWaypointMarkup(content.getString(), matches);
                    if (result == null) continue;
                    response = result;
                    changed = true;
                }
                if (response != null) {
                    changed = true;
                }
            } else {
                Journeymap.getLogger().warn("No implementation for handling waypoints in ITextComponent " + String.valueOf(component.getClass()));
            }
            if (!changed) {
                Journeymap.getLogger().warn(String.format("Matched waypoint in chat but failed to update message for %s : %s", component.getClass(), component.getString()));
            }
            return response;
        }
        return component;
    }

    /*
     * WARNING - void declaration
     */
    private static Component addWaypointMarkup(String text, List<String> matches) {
        ArrayList<MutableComponent> newParts = new ArrayList<MutableComponent>();
        int index = 0;
        boolean matched = false;
        Iterator<String> iterator = matches.iterator();
        while (iterator.hasNext()) {
            void var8_9;
            String match = iterator.next();
            if (!text.contains(match)) continue;
            int start = text.indexOf(match);
            if (start > index) {
                newParts.add(Constants.getStringTextComponent(text.substring(index, start)));
            }
            matched = true;
            String string = ParsedWaypoint.parse((String)match).name;
            if (string == null) {
                String string2 = match;
            }
            MutableComponent clickable = Constants.getStringTextComponent(Constants.getString("jm.waypoint.chat_share") + " \u00a7b\u00a7n" + (String)var8_9 + "\u00a7r");
            clickable.withStyle(style -> style.withClickEvent((ClickEvent)new ClickEvent.RunCommand("/jmc wpedit " + match)));
            MutableComponent hover = Component.translatable((String)"jm.common.share.chat.journeymap");
            hover.withStyle(style -> style.withColor(TextColor.fromLegacyFormat((ChatFormatting)ChatFormatting.YELLOW)));
            MutableComponent hover2 = Component.translatable((String)"jm.common.share.chat.description");
            hover2.withStyle(style -> style.withColor(TextColor.fromLegacyFormat((ChatFormatting)ChatFormatting.AQUA)));
            hover.append((Component)hover2);
            clickable.withStyle(style -> style.withHoverEvent((HoverEvent)new HoverEvent.ShowText((Component)hover)));
            newParts.add(clickable);
            index = start + match.length();
            iterator.remove();
        }
        if (!matched) {
            return null;
        }
        if (index < text.length() - 1) {
            newParts.add(Constants.getStringTextComponent(text.substring(index, text.length())));
        }
        if (!newParts.isEmpty()) {
            MutableComponent replacement = Constants.getStringTextComponent("");
            for (Component component : newParts) {
                replacement.append(component);
            }
            return replacement;
        }
        return null;
    }

    public record ParsedWaypoint(String name, String dim, Integer x, int y, Integer z, boolean showDeviation) {
        static String xaerosDimParser(String dim) {
            if ("overworld".equals(dim = ((String)dim).replace("Internal-", "").replace("-waypoints", "").replace("dim%", "").replace("$", ":")) || "the-nether".equals(dim) || "the-end".equals(dim)) {
                dim = "minecraft:" + (String)dim;
            }
            if ("External".equals(dim)) {
                dim = "minecraft:overworld";
            }
            dim = ((String)dim).replace("-", "_");
            return dim;
        }

        public static ParsedWaypoint parse(String string) {
            Object name = null;
            String raw = string.replaceAll("[\\[\\]]", "");
            if (string.startsWith("xaero-waypoint:")) {
                String[] split = string.split(":");
                String dimName = ParsedWaypoint.xaerosDimParser(split[9]);
                name = split[1].replace("gui.", "");
                int x = Integer.parseInt(split[3]);
                int y = Integer.parseInt(split[4].replace("~", "63"));
                int z = Integer.parseInt(split[5]);
                return new ParsedWaypoint((String)name, dimName, x, y, z, false);
            }
            String[] nameMatch = StringUtils.substringsBetween((String)string, (String)"\"", (String)"\"");
            if (nameMatch != null && nameMatch.length > 0) {
                name = nameMatch[0];
            }
            Integer x = null;
            int y = 63;
            Integer z = null;
            Object dim = "minecraft:overworld";
            boolean showDeviation = false;
            for (String part : raw.split(",")) {
                String[] prop;
                if (!part.contains(":") || (prop = part.split(":")).length != 2 && (prop.length != 3 || !part.contains("dim:"))) continue;
                String key = prop[0].trim().toLowerCase();
                String val = prop[1].trim();
                try {
                    if ("x".equals(key)) {
                        x = Integer.parseInt(val);
                    } else if ("y".equals(key)) {
                        y = Integer.parseInt(val);
                    } else if ("z".equals(key)) {
                        z = Integer.parseInt(val);
                    } else if ("dim".equals(key)) {
                        dim = val + ":" + prop[2].trim();
                    } else if ("name".equals(key) && name == null) {
                        name = val.replace("\"", "");
                    }
                    if (!"showDeviation".equals(key)) continue;
                    showDeviation = Boolean.parseBoolean(val);
                }
                catch (Exception e) {
                    Journeymap.getLogger().warn("Bad format in waypoint text part: " + part + ": " + String.valueOf(e));
                }
            }
            if (name == null) {
                name = x + "," + z;
            }
            return new ParsedWaypoint((String)name, (String)dim, x, y, z, showDeviation);
        }
    }
}

