/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.nbt;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.Map;
import journeymap.api.services.Services;
import journeymap.common.nbt.model.PlayerDTO;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.saveddata.SavedDataType;

public class PlayerData
extends SavedData {
    private static final Codec<PlayerDTO> PLAYEER_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("player_id").forGetter(PlayerDTO::getUuid), (App)Codec.BOOL.fieldOf("hidden_underground").forGetter(PlayerDTO::isHiddenUnderground), (App)Codec.BOOL.fieldOf("radar_visible").forGetter(PlayerDTO::isVisible), (App)Codec.BOOL.fieldOf("view_loaded_chunk_entity").forGetter(PlayerDTO::isChunkEntity), (App)Codec.BOOL.fieldOf("view_loaded_chunk_full").forGetter(PlayerDTO::isChunkFull), (App)Codec.BOOL.fieldOf("view_loaded_chunk_block").forGetter(PlayerDTO::isChunkBlock), (App)Codec.BOOL.fieldOf("view_loaded_chunk_inaccessible").forGetter(PlayerDTO::isChunkInaccessible)).apply((Applicative)instance, PlayerDTO::new));
    private static final Codec<Map<String, PlayerDTO>> CODEC_LIST = Codec.unboundedMap((Codec)Codec.STRING, PLAYEER_CODEC);
    private static final Codec<PlayerData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)CODEC_LIST.fieldOf("players").forGetter(p -> p.playerMap)).apply((Applicative)instance, map -> new PlayerData(new HashMap<String, PlayerDTO>((Map<String, PlayerDTO>)map))));
    private static final SavedDataType<PlayerData> TYPE = new SavedDataType("JMPlayerSettings", PlayerData::new, CODEC, DataFixTypes.OPTIONS);
    private final Map<String, PlayerDTO> playerMap;

    public PlayerData(Map<String, PlayerDTO> playerMap) {
        this.playerMap = playerMap;
        Services.COMMON_SERVICE.getServer().getLevel(Level.OVERWORLD).getDataStorage().set(TYPE, (SavedData)this);
    }

    public PlayerData() {
        this(new HashMap<String, PlayerDTO>());
        this.setDirty();
    }

    public static PlayerData getPlayerData() {
        return PlayerData.get();
    }

    private static PlayerData get() {
        ServerLevel level = Services.COMMON_SERVICE.getServer().getLevel(Level.OVERWORLD);
        return (PlayerData)level.getDataStorage().computeIfAbsent(TYPE);
    }

    public PlayerDTO getPlayer(ServerPlayer serverPlayer) {
        String uuid = serverPlayer.getStringUUID();
        return this.playerMap.computeIfAbsent(uuid, PlayerDTO::new);
    }
}

