/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.render.draw;

import com.google.common.cache.CacheLoader;
import java.awt.geom.Point2D;
import journeymap.client.JourneymapClient;
import journeymap.client.render.draw.DrawStep;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.render.map.Renderer;
import journeymap.client.texture.TextureCache;
import journeymap.client.waypoint.ClientWaypointImpl;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class DrawWayPointStep
implements DrawStep {
    public final ClientWaypointImpl waypoint;
    final ResourceLocation texture;
    final boolean isEdit;
    Point2D.Double lastPosition;
    boolean lastOnScreen;
    boolean showLabel;
    double labelScale = 0.0;
    float iconScale = 0.0f;

    public DrawWayPointStep(ClientWaypointImpl waypoint) {
        this(waypoint, false);
    }

    public DrawWayPointStep(ClientWaypointImpl waypoint, boolean isEdit) {
        this.waypoint = waypoint;
        this.isEdit = isEdit;
        this.texture = waypoint.getTextureResource();
    }

    public void setShowLabel(boolean showLabel) {
        this.showLabel = showLabel;
    }

    public void setLabelScale(float labelScale) {
        this.labelScale = labelScale;
    }

    public void setIconScale(float iconScale) {
        this.iconScale = iconScale;
    }

    @Override
    public void draw(GuiGraphics graphics, double xOffset, double yOffset, Renderer renderer, double fontScale, double rotation) {
        if (!(this.waypoint.isInPlayerDimension() && JourneymapClient.getInstance().getStateHandler().isWaypointsAllowed() && JourneymapClient.getInstance().getWaypointProperties().renderWaypoints.get().booleanValue() && JourneymapClient.getInstance().getWaypointProperties().renderWaypointsMap.get().booleanValue())) {
            return;
        }
        Point2D.Double pixel = this.getPosition(xOffset, yOffset, renderer, true);
        graphics.pose().pushMatrix();
        if (renderer.isOnScreen(pixel)) {
            if (this.showLabel) {
                int fontColor;
                int labelOffset = -16;
                labelOffset = this.iconScale <= 1.0f ? labelOffset : (int)((float)labelOffset * this.iconScale);
                this.labelScale = this.labelScale == 0.0 ? fontScale : this.labelScale;
                String waypointName = this.waypoint.getDisplayName();
                int n = this.waypoint.isDeathPoint() ? 0xFF0000 : (fontColor = this.isEdit ? 0xFFFFFF : this.waypoint.getSafeColor());
                if (this.waypoint.isDeathPoint() && !JourneymapClient.getInstance().getWaypointProperties().showDeathpointlabel.get().booleanValue()) {
                    waypointName = "";
                }
                Point2D labelPoint = renderer.shiftWindowPosition(pixel.getX(), pixel.getY(), 0, labelOffset);
                DrawUtil.drawLabel(graphics, (Component)Component.literal((String)waypointName), labelPoint.getX(), labelPoint.getY(), DrawUtil.HAlign.Center, DrawUtil.VAlign.Above, 0, 0.7f, fontColor, 1.0f, this.labelScale, false, rotation);
            } else if (this.isEdit) {
                DrawUtil.drawOnMapImageScaleCorrected(graphics, TextureCache.WaypointEdit, this.waypoint.getIconColor(), 1.0f, pixel.getX(), pixel.getY(), 32.0, 32.0, this.iconScale, rotation);
            }
            DrawUtil.drawOnMapImageScaleCorrected(graphics, this.texture, this.waypoint.getIconColor(), 1.0f, pixel.getX(), pixel.getY(), 16.0, 16.0, this.iconScale, rotation);
        } else if (!this.isEdit) {
            renderer.ensureOnScreen(pixel);
            DrawUtil.drawOnMapImageScaleCorrected(graphics, this.texture, this.waypoint.getIconColor(), 1.0f, pixel.getX(), pixel.getY(), 16.0, 16.0, this.iconScale, rotation);
        }
        graphics.pose().popMatrix();
    }

    public void drawOffscreen(GuiGraphics graphics, Point2D pixel, double rotation) {
        DrawUtil.drawOnMapImageScaleCorrected(graphics, this.texture, this.waypoint.getIconColor(), 1.0f, pixel.getX(), pixel.getY(), 16.0, 16.0, this.iconScale, rotation);
    }

    public Point2D.Double getPosition(double xOffset, double yOffset, Renderer renderer, boolean forceUpdate) {
        if (!forceUpdate && this.lastPosition != null) {
            return this.lastPosition;
        }
        double x = (double)this.waypoint.getX() + 0.5;
        double z = (double)this.waypoint.getZ() + 0.5;
        Point2D.Double pixel = renderer.getBlockPixelInGrid(x, z);
        pixel.setLocation(pixel.getX() + xOffset, pixel.getY() + yOffset);
        this.lastPosition = pixel;
        return pixel;
    }

    public boolean isOnScreen() {
        return this.lastOnScreen;
    }

    public void setOnScreen(boolean lastOnScreen) {
        this.lastOnScreen = lastOnScreen;
    }

    @Override
    public int getDisplayOrder() {
        return 0;
    }

    @Override
    public String getModId() {
        return this.waypoint.getOrigin();
    }

    public static class SimpleCacheLoader
    extends CacheLoader<ClientWaypointImpl, DrawWayPointStep> {
        public DrawWayPointStep load(ClientWaypointImpl holder) throws Exception {
            return new DrawWayPointStep(holder);
        }
    }
}

