/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.component;

import java.util.function.Consumer;
import journeymap.client.ui.component.LayoutSlot;
import journeymap.client.ui.component.ScrollListPane;
import journeymap.client.ui.component.Slot;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;

public class ScrollListLayoutPane<T extends LayoutSlot>
extends ScrollListPane<T> {
    protected final int offset = 7;

    public ScrollListLayoutPane(Minecraft mc, int x, int y, int width, int height, int slotHeight) {
        super(mc, x, y, width, height, slotHeight);
    }

    @Override
    public void updateSize(int width, int height, int x, int y) {
        super.updateSizeAndPosition(width, height, x - 3, y);
        this.scrollbarX = this.width + x - 7;
        this.listWidth = this.width - 7;
    }

    @Override
    public void setListWidth(int width) {
        this.scrollbarX = (this.width + width) / 2 - 7;
        this.listWidth = width - 7;
    }

    public void visitSlots(Consumer<AbstractWidget> consumer) {
        this.getRootSlots().forEach(slot -> slot.getLayout().visitWidgets(consumer));
    }

    public void initSlots() {
        this.getRootSlots().forEach(LayoutSlot::init);
    }

    public void repositionSlots() {
        this.getRootSlots().forEach(LayoutSlot::repositionElements);
    }

    protected void renderItem(GuiGraphics graphics, int mouseX, int mouseY, float partialTick, Slot<T> entry) {
        LayoutSlot e = (LayoutSlot)entry;
        super.renderItem(graphics, mouseX, mouseY, partialTick, entry);
        e.getLayout().visitWidgets(widget -> widget.render(graphics, mouseX, mouseY, partialTick));
    }
}

