/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common;

import java.lang.invoke.MethodHandles;
import journeymap.client.JourneymapClientForge;
import journeymap.common.Journeymap;
import journeymap.common.config.ForgeConfig;
import journeymap.common.event.ForgeServerEvents;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.event.server.ServerStoppedEvent;
import net.minecraftforge.eventbus.api.bus.BusGroup;
import net.minecraftforge.fml.IExtensionPoint;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;

@Mod(value="journeymap")
public class JourneymapForge {
    private final Journeymap journeymap = new Journeymap();

    public JourneymapForge(FMLJavaModLoadingContext context) {
        if (FMLEnvironment.dist.isClient()) {
            new JourneymapClientForge(context);
        }
        FMLCommonSetupEvent.getBus((BusGroup)context.getModBusGroup()).addListener(this::commonSetupEvent);
        ServerStartingEvent.BUS.addListener(this::serverStartingEvent);
        ServerStoppedEvent.BUS.addListener(this::serverStoppingEvent);
        context.registerConfig(ModConfig.Type.SERVER, (IConfigSpec)ForgeConfig.SERVER_SPEC);
        ModConfigEvent.Loading.getBus((BusGroup)context.getModBusGroup()).addListener(this::serverConfig);
        InterModEnqueueEvent.getBus((BusGroup)context.getModBusGroup()).addListener(this::imc);
        context.registerExtensionPoint(IExtensionPoint.DisplayTest.class, () -> new IExtensionPoint.DisplayTest(() -> "SERVER_ONLY", (remote, isServer) -> true));
    }

    private void imc(InterModEnqueueEvent event) {
        InterModComms.sendTo((String)"darkmodeeverywhere", (String)"dme-shaderblacklist", () -> "journeymap");
    }

    public void commonSetupEvent(FMLCommonSetupEvent event) {
        BusGroup.DEFAULT.register(MethodHandles.lookup(), (Object)new ForgeServerEvents());
    }

    public void serverConfig(ModConfigEvent.Loading event) {
        if (event.getConfig().getType() == ModConfig.Type.SERVER) {
            this.journeymap.setAdminConfig(new ForgeConfig());
        }
    }

    public void serverStartingEvent(ServerStartingEvent event) {
        this.journeymap.serverStarted(event.getServer());
    }

    public void serverStoppingEvent(ServerStoppedEvent event) {
        this.journeymap.serverStopping(event.getServer());
    }
}

