/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.helper;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import journeymap.api.services.Services;
import net.minecraft.client.Minecraft;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.dimension.DimensionType;

public class DimensionHelper {
    public static String getDimName(Entity entity) {
        return DimensionHelper.getDimName(entity.level());
    }

    public static String getDimName(@Nullable Level world) {
        if (world != null) {
            return DimensionHelper.getDimName((ResourceKey<Level>)world.dimension());
        }
        return "overworld";
    }

    public static String getDimName(ResourceKey<Level> dimensionKey) {
        return dimensionKey.location().getPath();
    }

    public static String getDimName(String key) {
        return key.split(":")[1];
    }

    public static String getDimKeyName(Entity entity) {
        return DimensionHelper.getDimKeyName(entity.level());
    }

    public static String getDimKeyName(@Nullable Level world) {
        if (world != null) {
            return DimensionHelper.getDimKeyName((ResourceKey<Level>)world.dimension());
        }
        return "minecraft:overworld";
    }

    public static String getDimKeyName(ResourceKey<Level> dimensionKey) {
        return dimensionKey.location().toString();
    }

    public static ResourceKey<Level> getDimension(Entity entity) {
        return DimensionHelper.getDimension(entity.level());
    }

    public static ResourceKey<Level> getDimension(Level world) {
        return world.dimension();
    }

    public static DimensionType getDimTypeForName(String dimName) {
        return DimensionHelper.getDimTypeMap().get(dimName);
    }

    public static DimensionType getDimTypeForKey(ResourceKey<Level> dimKey) {
        return DimensionHelper.getDimTypeMap().get(DimensionHelper.getDimName(dimKey));
    }

    public static String getSafeDimName(ResourceKey<Level> dim) {
        return dim.location().toString().replaceAll(":", "~");
    }

    public static ResourceLocation getDimResource(String dimName) {
        return ResourceLocation.parse((String)dimName);
    }

    public static boolean isNetherWorld(Level world) {
        return world.dimension().equals((Object)Level.NETHER);
    }

    public static boolean isOverworldWorld(Level world) {
        return world.dimension().equals((Object)Level.OVERWORLD);
    }

    public static boolean isEndWorld(Level world) {
        return world.dimension().equals((Object)Level.END);
    }

    public static ResourceKey<Level> getWorldKeyForName(String dimName) {
        return ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)DimensionHelper.getDimResource(dimName));
    }

    public static Map<String, DimensionType> getDimTypeMap() {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(Services.COMMON_SERVICE.getServer().getAllLevels().iterator(), 16), false).collect(Collectors.toMap(DimensionHelper::getDimKeyName, Level::dimensionType));
    }

    public static List<ResourceKey<Level>> getServerDimNameList() {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(Services.COMMON_SERVICE.getServer().getAllLevels().iterator(), 16), false).map(Level::dimension).collect(Collectors.toList());
    }

    public static Set<ResourceKey<Level>> getClientDimList() {
        return Minecraft.getInstance().player.connection.levels();
    }
}

