/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.component;

import com.mojang.blaze3d.vertex.PoseStack;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.util.List;
import java.util.Optional;
import journeymap.client.render.RenderWrapper;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.ui.component.buttons.Button;
import journeymap.client.ui.component.screens.JmUILegacy;
import journeymap.common.mixin.client.AbstractScrollAreaAccessor;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.input.InputWithModifiers;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;

public class ScrollPane
extends ObjectSelectionList<ScrollPaneEntry> {
    public int paneWidth = 0;
    public int paneHeight = 0;
    public Point2D.Double origin = new Point2D.Double();
    protected Button selected = null;
    private Integer frameColor = new Color(-6250336).getRGB();
    private Minecraft mc;
    private int _mouseX;
    private int _mouseY;
    private boolean showFrame = true;
    private boolean drawPartialScrollable = true;
    private boolean renderSolidBackground = false;
    private boolean renderDecorations = true;
    private boolean scrollVisible = true;
    protected boolean renderSelection;

    public ScrollPane(JmUILegacy parent, Minecraft mc, int width, int height, List<? extends Button> items, int itemHeight, int itemGap) {
        super(mc, width, height, 16, itemHeight + itemGap);
        for (Button button : items) {
            super.addEntry((AbstractSelectionList.Entry)new ScrollPaneEntry(this, this, button));
        }
        this.paneWidth = width;
        this.paneHeight = height;
        this.mc = mc;
    }

    public int getX() {
        return (int)this.origin.getX();
    }

    public int getY() {
        return (int)this.origin.getY();
    }

    public int getSlotHeight() {
        return this.height;
    }

    public void setDrawPartialScrollable(boolean value) {
        this.drawPartialScrollable = value;
    }

    public void setDimensions(int width, int height, int marginTop, int marginBottom, int x, int y) {
        super.updateSizeAndPosition(width, height, x, y);
        this.paneWidth = width;
        this.paneHeight = height;
        this.origin.setLocation(x, y);
    }

    protected int getItemCount() {
        return super.getItemCount();
    }

    public Button getClickedButton(MouseButtonEvent event, boolean doubleClick) {
        if (event.button() == 0) {
            for (ScrollPaneEntry entry : super.children()) {
                Button item = entry.item;
                if (item == null || !this.inFullView(item)) continue;
                if (item.isHovered() && item.mouseClicked(event, doubleClick)) {
                    item.onPress((InputWithModifiers)event.buttonInfo());
                    return item;
                }
                item.clickScrollable(this.mc, (int)event.x(), (int)event.y());
            }
        }
        return null;
    }

    public Button getButton(int mouseX, int mouseY) {
        for (ScrollPaneEntry entry : super.children()) {
            Button item = entry.item;
            if (item == null || !this.inFullView(item) || !item.isHovered() || !item.mouseOver(mouseX, mouseY)) continue;
            return item;
        }
        return null;
    }

    public void renderWidget(GuiGraphics graphics, int mX, int mY, float partialTicks) {
        this._mouseX = mX;
        this._mouseY = mY;
        PoseStack pose = new PoseStack();
        pose.pushPose();
        RenderWrapper.enableDepthTest();
        this.renderBackground(graphics);
        super.renderWidget(graphics, mX, mY, partialTicks);
        pose.popPose();
    }

    protected void renderListSeparators(GuiGraphics pGuiGraphics) {
    }

    protected void renderListBackground(GuiGraphics guiGraphics) {
    }

    protected void renderBackground(GuiGraphics graphics) {
        int width = this.getWidth();
        float alpha = 0.4f;
        int y = this.getY() - 1;
        DrawUtil.drawRectangle(graphics, this.getX(), y, width, this.paneHeight + 1, Color.BLACK.getRGB(), this.renderSolidBackground ? 1.0f : alpha);
        if (super.scrollbarVisible()) {
            ++width;
        }
        if (this.showFrame) {
            alpha = 1.0f;
            DrawUtil.drawRectangle(graphics, this.getX(), y, width, 1.0, this.frameColor, alpha);
            DrawUtil.drawRectangle(graphics, this.getX(), y + this.paneHeight + 1, width + 1, 1.0, this.frameColor, alpha);
            DrawUtil.drawRectangle(graphics, this.getX(), y, 1.0, this.paneHeight + 1, this.frameColor, alpha);
            DrawUtil.drawRectangle(graphics, this.getX() + width, y, 1.0, this.paneHeight + 1, this.frameColor, alpha);
        }
    }

    protected void renderItem(GuiGraphics graphics, int mouseX, int mouseY, float partialTick, ScrollPaneEntry entry) {
        int margin = 4;
        int itemX = this.getX() + 2;
        Button item = entry.item;
        item.setScrollablePosition(itemX, entry.getY());
        item.setScrollableWidth(this.paneWidth - 4);
        item.drawScrollable(graphics, this.mc, this._mouseX, this._mouseY);
        item.renderSpecialDecoration(graphics, this._mouseX, this._mouseY, this.getX(), this.getY(), this.getWidth(), this.height);
    }

    protected void renderSelection(GuiGraphics guiGraphics, ScrollPaneEntry entry, int i) {
        if (this.renderSelection) {
            super.renderSelection(guiGraphics, (AbstractSelectionList.Entry)entry, i);
        }
    }

    public boolean mouseDragged(MouseButtonEvent event, double mouseDX, double mouseDY) {
        if (this.children().isEmpty()) {
            return false;
        }
        if (event.button() == 0 && ((AbstractScrollAreaAccessor)((Object)this)).isScrolling()) {
            if (event.y() < (double)super.getY()) {
                this.setScrollAmount(0.0);
            } else {
                double d0 = Math.max(1, this.maxScrollAmount());
                int i = super.getBottom() - super.getY();
                int j = Mth.clamp((int)((int)((float)(i * i) / (float)this.contentHeight())), (int)32, (int)(i - 8));
                double d1 = Math.max(1.0, d0 / (double)(i - j));
                this.setScrollAmount(this.scrollAmount() + mouseDY * d1);
            }
            return true;
        }
        return false;
    }

    public boolean isScrollVisible() {
        return this.scrollVisible;
    }

    public boolean inFullView(Button item) {
        return item.getY() >= this.getY() && item.getY() + item.getButtonHeight() <= this.getY() + this.paneHeight;
    }

    protected int scrollBarX() {
        return this.paneWidth + this.getX();
    }

    public boolean updateScrolling(MouseButtonEvent event) {
        double rightX = this.getX() + this.getWidth() - 5;
        boolean scrolling = event.button() == 0 && event.x() >= rightX && event.y() < rightX + 10.0;
        ((AbstractScrollAreaAccessor)((Object)this)).setScrolling(scrolling);
        return scrolling;
    }

    public int getWidth() {
        boolean scrollVisible = 0 < this.maxScrollAmount();
        return this.paneWidth + (scrollVisible ? 5 : 0);
    }

    public int getFitWidth(Font fr) {
        int fit = 0;
        for (ScrollPaneEntry entry : this.children()) {
            fit = Math.max(fit, entry.item.getFitWidth(fr));
        }
        return fit;
    }

    public boolean isMouseOver(double posX, double posY) {
        int topY = this.getY();
        int bottomY = this.getY() + this.paneHeight;
        int leftX = this.getX();
        int rightX = this.getX() + this.getWidth();
        return posY >= (double)topY && posY <= (double)bottomY && posX >= (double)leftX && posX <= (double)rightX;
    }

    public Optional<GuiEventListener> getChildAt(double mouseX, double mouseY) {
        return Optional.empty();
    }

    public void mouseMoved(double mouseX, double mouseY) {
        for (ScrollPaneEntry entry : super.children()) {
            Button item = entry.item;
            if (item == null || !this.inFullView(item)) continue;
            item.mouseMoved(mouseX, mouseY);
        }
        super.mouseMoved(mouseX, mouseY);
    }

    public void setRenderSelection(boolean renderSelection) {
        this.renderSelection = renderSelection;
    }

    public void setRenderSolidBackground(boolean value) {
        this.renderSolidBackground = value;
    }

    public void setRenderDecorations(boolean value) {
        this.renderDecorations = value;
    }

    class ScrollPaneEntry
    extends ObjectSelectionList.Entry<ScrollPaneEntry> {
        private ScrollPane parent;
        private Button item;

        public ScrollPaneEntry(ScrollPane this$0, ScrollPane parent, Button item) {
            this.parent = parent;
            this.item = item;
        }

        public Component getNarration() {
            return Component.literal((String)"");
        }

        public void renderContent(GuiGraphics guiGraphics, int i, int i1, boolean b, float v) {
        }
    }
}

