/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.component;

import java.awt.Color;
import journeymap.client.Constants;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.input.CharacterEvent;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;

public class TextBox
extends EditBox {
    protected final String numericRegex;
    protected final boolean numeric;
    protected final boolean allowNegative;
    protected int minLength;
    protected Integer clampMin;
    protected Integer clampMax;
    private final OnPress onPress;
    private long lastClick = 0L;
    private boolean hasError;

    public TextBox(Object text, Font fontRenderer, int width, int height) {
        this(text, fontRenderer, width, height, false, false, () -> {});
    }

    public TextBox(Object text, Font fontRenderer, int width, int height, OnPress onPress) {
        this(text, fontRenderer, width, height, false, false, onPress);
    }

    public TextBox(Object text, Font fontRenderer, int width, int height, boolean isNumeric, boolean negative) {
        this(text, fontRenderer, width, height, isNumeric, negative, () -> {});
    }

    public TextBox(Object text, Font fontRenderer, int width, int height, boolean isNumeric, boolean negative, OnPress onPress) {
        super(fontRenderer, 0, 0, width, height, (Component)Constants.getStringTextComponent(text == null ? "" : text.toString()));
        this.onPress = onPress;
        this.setMaxLength(256);
        this.setValue(text == null ? "" : text.toString());
        this.numeric = isNumeric;
        this.allowNegative = negative;
        String regex = null;
        if (this.numeric) {
            regex = this.allowNegative ? "[^-?\\d]" : "[^\\d]";
        }
        this.numericRegex = regex;
    }

    public void setClamp(Integer min, Integer max) {
        this.clampMin = min;
        this.clampMax = max;
    }

    public void setMinLength(int minLength) {
        this.minLength = minLength;
    }

    public void insertText(@NotNull String par1Str) {
        if (this.numeric) {
            String fixed = par1Str.replaceAll(this.numericRegex, "");
            if (this.allowNegative) {
                par1Str = "-".equals(fixed) && this.getCursorPosition() != 0 && !this.isAllSelected() ? "" : fixed;
            }
        }
        super.insertText(par1Str);
    }

    public void setText(Object object) {
        super.setValue(object.toString());
    }

    public boolean isNumeric() {
        return this.numeric;
    }

    public boolean hasMinLength() {
        String text = this.getValue();
        int textLen = text == null ? 0 : text.length();
        return this.minLength <= textLen;
    }

    public boolean charTyped(CharacterEvent event) {
        boolean typed = false;
        if (this.isHoveredOrFocused()) {
            typed = super.charTyped(event);
            if (this.numeric && typed) {
                this.clamp();
            }
            this.onPress.onPress();
        }
        return typed;
    }

    public boolean keyPressed(KeyEvent event) {
        boolean pressed = false;
        if (this.isHoveredOrFocused()) {
            pressed = super.keyPressed(event);
            this.onPress.onPress();
        }
        return pressed;
    }

    public boolean mouseDragged(MouseButtonEvent event, double mouseDX, double mouseDY) {
        double mouseY;
        double mouseX = event.x();
        if (this.isMouseOver(mouseX, mouseY = event.y())) {
            if (this.isFocused() && event.button() == 0) {
                int i = Mth.floor((double)mouseX) - super.getX();
                if (this.isBordered()) {
                    i -= 4;
                }
                String s = this.font.plainSubstrByWidth(this.getValue().substring(this.displayPos), this.getInnerWidth());
                this.setHighlightPos(this.font.plainSubstrByWidth(s, i).length() + this.displayPos);
                return true;
            }
            return super.mouseDragged(event, mouseDX, mouseDY);
        }
        return false;
    }

    public boolean mouseClicked(MouseButtonEvent event, boolean doubleClick) {
        double mouseX = event.x();
        double mouseY = event.y();
        super.setHighlightPos(super.getCursorPosition());
        if (this.isMouseOver(mouseX, mouseY) && super.mouseClicked(event, doubleClick)) {
            if (doubleClick) {
                this.selectAll();
            }
            this.setFocused(true);
            return true;
        }
        this.setFocused(false);
        return false;
    }

    public void setFocused(boolean focused) {
        super.setFocused(focused);
    }

    public void selectAll() {
        this.moveCursorToEnd(false);
        this.setHighlightPos(0);
    }

    public boolean isAllSelected() {
        return this.getValue().equals(this.getHighlighted());
    }

    public void setCursorPosition(int position) {
        super.setCursorPosition(position);
    }

    public boolean isHovered() {
        return this.isHovered;
    }

    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.renderWidget(graphics, mouseX, mouseY, partialTicks);
        if (this.isVisible() && (!this.hasMinLength() || this.hasErrorState())) {
            int red = Color.red.getRGB();
            int x1 = this.getX() - 1;
            int y1 = this.getY() - 1;
            int x2 = x1 + this.getWidth() + 1;
            int y2 = y1 + this.getHeight() + 1;
            graphics.fill(x1, y1, x2, y1 + 1, red);
            graphics.fill(x1, y2, x2, y2 + 1, red);
            graphics.fill(x1, y1, x1 + 1, y2, red);
            graphics.fill(x2, y1, x2 + 1, y2, red);
        }
    }

    public boolean hasErrorState() {
        return this.hasError;
    }

    public void setErrorState(boolean hasError) {
        this.hasError = hasError;
    }

    public Integer clamp() {
        return this.clamp(this.getValue());
    }

    public Integer clamp(String text) {
        int val;
        if (!this.numeric) {
            return null;
        }
        if (this.clampMin != null) {
            if (text == null || text.length() == 0 || text.equals("-")) {
                return null;
            }
            try {
                val = Math.max(this.clampMin, Integer.parseInt(text));
            }
            catch (Exception e) {
                return this.clampMin;
            }
            if (this.clampMax != null) {
                try {
                    val = Math.min(this.clampMax, val);
                }
                catch (Exception e) {
                    return this.clampMax;
                }
            }
        } else {
            try {
                val = Integer.parseInt(text);
            }
            catch (Exception e) {
                return null;
            }
        }
        if (val != Integer.parseInt(text)) {
            this.setText(val);
        }
        return val;
    }

    public int getX() {
        return super.getX();
    }

    public void setX(int x) {
        super.setX(x);
    }

    public int getY() {
        return super.getY();
    }

    public void setY(int y) {
        super.setY(y);
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int w) {
        this.width = w;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int h) {
        this.height = h;
    }

    public int getCenterX() {
        return this.getX() + this.getWidth() / 2;
    }

    public int getMiddleY() {
        return this.getY() + this.getHeight() / 2;
    }

    public int getBottomY() {
        return this.getY() + this.getHeight();
    }

    public int getRightX() {
        return this.getX() + this.getWidth();
    }

    public static interface OnPress {
        public void onPress();
    }
}

