/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.dialog;

import com.google.common.collect.Lists;
import java.awt.Color;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.EnumSet;
import journeymap.client.Constants;
import journeymap.client.JourneymapClient;
import journeymap.client.cartography.color.RGB;
import journeymap.client.model.grid.GridSpec;
import journeymap.client.model.grid.GridSpecs;
import journeymap.client.model.map.MapType;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.texture.TextureCache;
import journeymap.client.ui.component.buttons.Button;
import journeymap.client.ui.component.buttons.FloatSliderButton;
import journeymap.client.ui.component.dropdown.PropertyDropdownButton;
import journeymap.client.ui.component.screens.AbstractPopupScreen;
import journeymap.client.ui.component.widgets.ColoredImageWidget;
import journeymap.client.ui.component.widgets.ImageRadioButtonListWidget;
import journeymap.client.ui.component.widgets.StringWidget;
import journeymap.common.properties.catagory.Category;
import journeymap.common.properties.config.EnumField;
import journeymap.common.properties.config.FloatField;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LayoutSettings;
import net.minecraft.client.gui.layouts.LinearLayout;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;

public class GridEditorPopup
extends AbstractPopupScreen {
    private static final int COLOR_PICKER_SIZE = 40;
    private static final ResourceLocation COLOR_PICKER = TextureCache.ColorPicker;
    private static final ResourceLocation NIGHT_ICON = ResourceLocation.fromNamespaceAndPath((String)"journeymap", (String)"ui/img/ico/night.png");
    private static final ResourceLocation UNDERGROUND_ICON = ResourceLocation.fromNamespaceAndPath((String)"journeymap", (String)"ui/img/ico/caves.png");
    private static final ResourceLocation DAY_ICON = ResourceLocation.fromNamespaceAndPath((String)"journeymap", (String)"ui/img/ico/day.png");
    private final Component labelSubmit = Component.translatable((String)"jm.common.submit");
    private final Component labelReset = Component.translatable((String)"jm.common.reset");
    private final Component labelCancel = Component.translatable((String)"jm.common.cancel");
    private PropertyDropdownButton<GridSpec.Style> buttonStyle;
    private FloatSliderButton buttonOpacity;
    private final Rectangle2D.Double colorPickRect;
    private final ColoredImageWidget colorPickerWidget;
    private final DynamicTexture colorPickerTex = (DynamicTexture)TextureCache.getTexture(COLOR_PICKER);
    private final GridSpecs gridSpecs;
    private Integer activeColor;
    private MapType activeMapType;
    private ResourceLocation selected;
    private GridWidget regionTextureWidget;

    public GridEditorPopup() {
        super((Component)Component.translatable((String)"jm.common.grid_editor"));
        this.colorPickRect = new Rectangle2D.Double(0.0, 0.0, 40.0, 40.0);
        this.colorPickerWidget = ColoredImageWidget.texture(40, 40, COLOR_PICKER, 40, 40, -1, true);
        this.colorPickerWidget.setOutline(true);
        this.colorPickerWidget.setOutlineColor(-6250336);
        this.gridSpecs = JourneymapClient.getInstance().getCoreProperties().gridSpecs.clone();
        this.activeMapType = MapType.day((ResourceKey<Level>)Level.OVERWORLD);
        this.activeColor = this.gridSpecs.getSpec(this.activeMapType).getColor();
        this.selected = DAY_ICON;
    }

    @Override
    public void renderPopupScreenBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.renderTransparentBackground(guiGraphics);
        guiGraphics.blitSprite(RenderPipelines.GUI_TEXTURED, BACKGROUND_SPRITE, this.layout.getX() - 18, this.layout.getY() - 10, this.layout.getWidth() + 36, this.layout.getHeight() + 20);
    }

    protected void init() {
        LinearLayout bottomLayout = LinearLayout.horizontal();
        this.layout.spacing(6);
        this.layout.defaultCellSetting().alignHorizontallyCenter();
        this.layout.addChild((LayoutElement)new StringWidget((Component)this.getTitle().copy().withStyle(new ChatFormatting[]{ChatFormatting.AQUA, ChatFormatting.UNDERLINE}), this.font), LayoutSettings::alignHorizontallyCenter);
        this.layout.addChild((LayoutElement)this.topLayoutBuilder());
        this.layout.addChild((LayoutElement)this.contentLayoutBuilder());
        this.layout.addChild((LayoutElement)bottomLayout);
        bottomLayout.spacing(12);
        bottomLayout.addChild((LayoutElement)Button.builder((Component)this.labelSubmit, b -> this.save()).width(this.font.width((FormattedText)this.labelSubmit) + 10).build());
        bottomLayout.addChild((LayoutElement)Button.builder((Component)this.labelReset, b -> this.reset()).width(this.font.width((FormattedText)this.labelReset) + 10).build());
        bottomLayout.addChild((LayoutElement)Button.builder((Component)this.labelCancel, b -> this.onClose()).width(this.font.width((FormattedText)this.labelCancel) + 10).build());
        this.layout.visitWidgets(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget((GuiEventListener)x$0);
        });
        super.repositionElements();
    }

    private LinearLayout contentLayoutBuilder() {
        LinearLayout contentLayout = LinearLayout.horizontal();
        contentLayout.spacing(10);
        ArrayList list = Lists.newArrayList((Object[])new ResourceLocation[]{DAY_ICON, NIGHT_ICON, UNDERGROUND_ICON});
        contentLayout.addChild(new ImageRadioButtonListWidget<ResourceLocation>("", list, DAY_ICON, 24, 24, this::updateValue));
        this.regionTextureWidget = (GridWidget)contentLayout.addChild((LayoutElement)GridWidget.texture(TextureCache.TileSampleDay, this.gridSpecs.getSpec(this.activeMapType)));
        this.regionTextureWidget.setOutline(true);
        this.regionTextureWidget.setOutlineColor(-6250336);
        return contentLayout;
    }

    private LinearLayout topLayoutBuilder() {
        LinearLayout topLayout = LinearLayout.horizontal();
        LinearLayout selectionLayout = LinearLayout.vertical();
        topLayout.spacing(5);
        selectionLayout.spacing(6);
        topLayout.addChild((LayoutElement)this.colorPickerWidget);
        topLayout.addChild((LayoutElement)selectionLayout);
        GridSpec spec = this.gridSpecs.getSpec(this.activeMapType);
        this.buttonStyle = (PropertyDropdownButton)selectionLayout.addChild(new PropertyDropdownButton<GridSpec.Style>(EnumSet.allOf(GridSpec.Style.class), Constants.getString("jm.common.grid_style"), new EnumField<GridSpec.Style>(Category.Hidden, "", spec.style), b -> this.updateGridSpecs()));
        this.buttonStyle.setDefaultStyle(false);
        this.buttonStyle.setDrawBackground(false);
        this.buttonOpacity = (FloatSliderButton)selectionLayout.addChild((LayoutElement)new FloatSliderButton(new FloatField(Category.Hidden, "", 0.0f, 1.0f, spec.alpha), Constants.getString("jm.common.grid_opacity") + " : ", ""));
        this.buttonOpacity.setDefaultStyle(false);
        this.buttonOpacity.setDrawBackground(false);
        return topLayout;
    }

    protected void renderPopupScreen(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.renderPopupScreen(graphics, mouseX, mouseY, partialTicks);
        this.colorPickRect.setRect(this.colorPickerWidget.getX(), this.colorPickerWidget.getY(), 40.0, 40.0);
        GridSpec activeSpec = this.gridSpecs.getSpec(this.activeMapType);
        int colorX = activeSpec.getColorX();
        int colorY = activeSpec.getColorY();
        if (colorX > 0 && colorY > 0) {
            DrawUtil.drawRectangle(graphics, (colorX += this.colorPickerWidget.getX()) - 2, (colorY += this.colorPickerWidget.getY()) - 2, 5.0, 5.0, Color.darkGray.getRGB(), 0.8f);
            DrawUtil.drawRectangle(graphics, colorX - 1, colorY, 3.0, 1.0, this.activeColor, 1.0f);
            DrawUtil.drawRectangle(graphics, colorX, colorY - 1, 1.0, 3.0, this.activeColor, 1.0f);
        }
        this.regionTextureWidget.setTexture(this.getTileSample(this.activeMapType));
        this.regionTextureWidget.setGridSpec(this.gridSpecs.getSpec(this.activeMapType));
    }

    public boolean mouseClicked(MouseButtonEvent event, boolean doubleClick) {
        super.mouseClicked(event, doubleClick);
        if (event.button() == 0) {
            this.checkColorPicker(event.x(), event.y());
        }
        return true;
    }

    public boolean mouseDragged(MouseButtonEvent event, double dragX, double dragY) {
        try {
            if (this.buttonOpacity.dragging) {
                this.updateGridSpecs();
            } else {
                this.checkColorPicker(event.x(), event.y());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return super.mouseDragged(event, dragX, dragY);
    }

    protected void checkColorPicker(double mouseX, double mouseY) {
        if (this.colorPickRect.contains(mouseX, mouseY)) {
            float scale = 3.2f;
            int x = (int)(mouseX - (double)((int)this.colorPickRect.x));
            int y = (int)(mouseY - (double)((int)this.colorPickRect.y));
            int rgb = this.colorPickerTex.getPixels().getPixel((int)((float)x * scale), (int)((float)y * scale));
            this.activeColor = RGB.rgbaToRgb(rgb);
            GridSpec activeSpec = this.gridSpecs.getSpec(this.activeMapType);
            activeSpec.setColorCoords(x, y);
            this.updateGridSpecs();
        }
    }

    protected void updateGridSpecs() {
        GridSpec activeSpec = this.gridSpecs.getSpec(this.activeMapType);
        int colorX = activeSpec.getColorX();
        int colorY = activeSpec.getColorY();
        GridSpec newSpec = new GridSpec(this.buttonStyle.getField().get(), new Color(this.activeColor), this.buttonOpacity.getValue()).setColorCoords(colorX, colorY);
        MapType mapType = NIGHT_ICON.equals((Object)this.selected) ? MapType.night((ResourceKey<Level>)Level.OVERWORLD) : (UNDERGROUND_ICON.equals((Object)this.selected) ? MapType.underground(0, (ResourceKey<Level>)Level.OVERWORLD) : MapType.day((ResourceKey<Level>)Level.OVERWORLD));
        this.gridSpecs.setSpec(mapType, newSpec);
        this.updatePreview(mapType);
    }

    public ResourceLocation getTileSample(MapType mapType) {
        if (NIGHT_ICON.equals((Object)this.selected)) {
            return TextureCache.TileSampleNight;
        }
        if (UNDERGROUND_ICON.equals((Object)this.selected)) {
            return TextureCache.TileSampleUnderground;
        }
        return TextureCache.TileSampleDay;
    }

    protected void updatePreview(MapType mapType) {
        this.activeMapType = mapType;
        GridSpec activeSpec = this.gridSpecs.getSpec(this.activeMapType);
        this.activeColor = activeSpec.getColor();
        this.buttonOpacity.setValue(activeSpec.alpha);
        this.buttonStyle.setValue(activeSpec.style);
    }

    private void updateValue(ResourceLocation resourceLocation) {
        this.selected = resourceLocation;
        this.updateGridSpecs();
    }

    private void save() {
        this.updateGridSpecs();
        JourneymapClient.getInstance().getCoreProperties().gridSpecs.updateFrom(this.gridSpecs);
        JourneymapClient.getInstance().getCoreProperties().save();
        this.onClose();
    }

    private void reset() {
        GridSpec defaultSpec;
        MapType mapType;
        if (NIGHT_ICON.equals((Object)this.selected)) {
            mapType = MapType.night((ResourceKey<Level>)Level.OVERWORLD);
            defaultSpec = GridSpecs.DEFAULT_NIGHT.clone();
        } else if (UNDERGROUND_ICON.equals((Object)this.selected)) {
            mapType = MapType.underground(0, (ResourceKey<Level>)Level.OVERWORLD);
            defaultSpec = GridSpecs.DEFAULT_UNDERGROUND.clone();
        } else {
            mapType = MapType.day((ResourceKey<Level>)Level.OVERWORLD);
            defaultSpec = GridSpecs.DEFAULT_DAY.clone();
        }
        this.gridSpecs.setSpec(mapType, defaultSpec);
        this.activeColor = this.gridSpecs.getSpec(mapType).getColor();
        this.buttonStyle.setValue(this.gridSpecs.getSpec((MapType)mapType).style);
        this.buttonOpacity.setValue(this.gridSpecs.getSpec((MapType)mapType).alpha);
    }

    private static class GridWidget
    extends ColoredImageWidget.Image {
        private ResourceLocation texture;
        private GridSpec gridSpec;

        public static GridWidget texture(ResourceLocation texture, GridSpec gridSpec) {
            return new GridWidget(0, 0, 128, 128, texture, 128, 128, -1, false, gridSpec);
        }

        public GridWidget(int x, int y, int width, int height, ResourceLocation texture, int textureWidth, int textureHeight, int color, boolean blur, GridSpec gridSpec) {
            super(x, y, width, height, texture, textureWidth, textureHeight, color, blur);
            this.texture = texture;
            this.gridSpec = gridSpec;
        }

        @Override
        protected void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
            super.renderWidget(graphics, mouseX, mouseY, partialTick);
            int color = RGB.toArgb(this.gridSpec.getColor(), this.gridSpec.alpha);
            graphics.blit(RenderPipelines.GUI_TEXTURED, this.gridSpec.style.getTextureLocation(), this.getX(), this.getY(), 0.25f, 0.25f, 128, 128, 512, 512, color);
        }

        public void setGridSpec(GridSpec gridSpec) {
            this.gridSpec = gridSpec;
        }

        @Override
        public void setTexture(ResourceLocation texture) {
            this.texture = texture;
        }

        @Override
        protected ResourceLocation getTexture() {
            return this.texture;
        }
    }
}

