/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.option;

import com.google.common.base.Strings;
import java.awt.Color;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.ui.component.ButtonList;
import journeymap.client.ui.component.Slot;
import journeymap.client.ui.component.buttons.Button;
import journeymap.client.ui.component.buttons.SliderButton;
import journeymap.client.ui.component.buttons.TextFieldButton;
import journeymap.client.ui.option.CategorySlot;
import journeymap.client.ui.option.SlotMetadata;
import journeymap.common.Journeymap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.input.CharacterEvent;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.input.MouseButtonEvent;

public class ButtonListSlot
extends Slot
implements Comparable<ButtonListSlot> {
    static int hgap = 8;
    Minecraft mc = Minecraft.getInstance();
    Font fontRenderer;
    ButtonList buttons;
    Map<Button, SlotMetadata> buttonOptionMetadata;
    CategorySlot parent;
    SlotMetadata lastPressed;
    SlotMetadata currentToolTip;
    Integer colorToolbarBgStart;
    Integer colorToolbarBgEnd;

    public ButtonListSlot(CategorySlot parent) {
        this.fontRenderer = Minecraft.getInstance().font;
        this.buttons = new ButtonList();
        this.buttonOptionMetadata = new HashMap<Button, SlotMetadata>();
        this.lastPressed = null;
        this.currentToolTip = null;
        this.colorToolbarBgStart = new Color(0, 0, 100).getRGB();
        this.colorToolbarBgEnd = new Color(0, 0, 100).getRGB();
        this.parent = parent;
    }

    public ButtonListSlot add(SlotMetadata slotMetadata) {
        this.buttons.add(slotMetadata.getButton());
        this.buttonOptionMetadata.put(slotMetadata.getButton(), slotMetadata);
        return this;
    }

    public ButtonListSlot addAll(Collection<SlotMetadata> slotMetadataCollection) {
        for (SlotMetadata slotMetadata : slotMetadataCollection) {
            this.add(slotMetadata);
        }
        return this;
    }

    public ButtonListSlot merge(ButtonListSlot other) {
        for (SlotMetadata otherSlot : other.buttonOptionMetadata.values()) {
            this.add(otherSlot);
        }
        return this;
    }

    public void clear() {
        this.buttons.clear();
        this.buttonOptionMetadata.clear();
    }

    public Collection<SlotMetadata> getMetadata() {
        return this.buttonOptionMetadata.values();
    }

    public void renderContent(GuiGraphics graphics, int mouseX, int mouseY, boolean hovered, float partialTick) {
        int x = this.getContentX();
        int y = this.getContentY();
        int rowWidth = this.getContentWidth();
        int itemHeight = this.getContentHeight();
        int margin = 0;
        if (this.parent.getCurrentColumnWidth() > 0) {
            int cols = this.parent.currentColumns;
            margin = (rowWidth - (hgap * cols - 1 + cols * this.parent.getCurrentColumnWidth())) / 2;
            x += margin;
            rowWidth -= margin * 2;
        }
        SlotMetadata tooltipMetadata = null;
        if (this.buttons.size() > 0) {
            this.buttons.setHeights(itemHeight);
            if (this.buttonOptionMetadata.get(this.buttons.get(0)).isToolbar()) {
                this.buttons.fitWidths(this.fontRenderer);
                this.buttons.layoutHorizontal(x + rowWidth - hgap, y, false, hgap);
                if (this.buttons.getLeftX() < x) {
                    x = this.buttons.getLeftX() - hgap;
                    rowWidth = this.buttons.getRightX() + hgap;
                }
                DrawUtil.drawGradientRect(graphics, x, y, rowWidth, itemHeight, this.colorToolbarBgStart, 0.15f, this.colorToolbarBgEnd, 0.6f);
            } else {
                this.buttons.setWidths(this.parent.currentColumnWidth);
                this.buttons.layoutHorizontal(x, y, true, hgap);
            }
            for (Button button : this.buttons) {
                button.render(graphics, mouseX, mouseY, 0.0f);
                if (tooltipMetadata != null || !button.mouseOver(mouseX, mouseY)) continue;
                tooltipMetadata = this.buttonOptionMetadata.get((Object)button);
            }
        } else {
            Journeymap.getLogger().warn("no buttons in " + this.parent.category.getLabel());
        }
        this.currentToolTip = tooltipMetadata;
    }

    public boolean mouseClicked(MouseButtonEvent event, boolean doubleClick) {
        if (event.button() == 0) {
            for (Button button : this.buttons) {
                if (!button.mouseClicked(event, doubleClick)) continue;
                this.lastPressed = this.buttonOptionMetadata.get((Object)button);
                return true;
            }
        }
        return false;
    }

    public boolean mouseReleased(MouseButtonEvent event) {
        for (Button button : this.buttons) {
            button.mouseReleased(event);
        }
        return true;
    }

    public boolean charTyped(CharacterEvent event) {
        for (SlotMetadata slot : this.buttonOptionMetadata.values()) {
            Button button = slot.button;
            if (!slot.equals(this.lastPressed) || !button.isMouseOver() || !(button instanceof TextFieldButton)) continue;
            return button.charTyped(event);
        }
        return false;
    }

    public boolean mouseDragged(MouseButtonEvent event, double mouseDX, double mouseDY) {
        for (SlotMetadata slot : this.buttonOptionMetadata.values()) {
            Button button = slot.button;
            if (!slot.equals(this.lastPressed) || !button.isMouseOver() || !(button instanceof SliderButton) && !(button instanceof TextFieldButton)) continue;
            return button.mouseDragged(event, mouseDX, mouseDY);
        }
        return false;
    }

    public boolean keyPressed(KeyEvent event) {
        for (SlotMetadata slot : this.buttonOptionMetadata.values()) {
            Button button = slot.button;
            if (!slot.equals(this.lastPressed) || !button.isMouseOver() || !(button instanceof TextFieldButton) && !(button instanceof SliderButton)) continue;
            return button.keyPressed(event);
        }
        return false;
    }

    @Override
    public void setEnabled(boolean enabled) {
        for (SlotMetadata slot : this.buttonOptionMetadata.values()) {
            if (slot.isMasterPropertyForCategory()) continue;
            slot.button.setEnabled(enabled);
        }
    }

    public List<Slot> getChildSlots(int listWidth, int columnWidth) {
        return Collections.EMPTY_LIST;
    }

    public SlotMetadata getLastPressed() {
        return this.lastPressed;
    }

    public SlotMetadata getCurrentTooltip() {
        return this.currentToolTip;
    }

    @Override
    public int getColumnWidth() {
        this.buttons.equalizeWidths(this.fontRenderer);
        return ((Button)((Object)this.buttons.get(0))).getWidth();
    }

    public boolean contains(SlotMetadata slotMetadata) {
        return this.buttonOptionMetadata.values().contains(slotMetadata);
    }

    protected String getFirstButtonString() {
        if (this.buttons.size() > 0) {
            return ((Button)((Object)this.buttons.get(0))).getMessage().getString();
        }
        return null;
    }

    @Override
    public int compareTo(ButtonListSlot o) {
        String buttonString = this.getFirstButtonString();
        String otherButtonString = o.getFirstButtonString();
        if (!Strings.isNullOrEmpty((String)buttonString)) {
            return buttonString.compareTo(otherButtonString);
        }
        if (!Strings.isNullOrEmpty((String)otherButtonString)) {
            return 1;
        }
        return 0;
    }
}

