/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.io.nbt;

import com.mojang.datafixers.DataFixer;
import java.util.Optional;
import journeymap.client.io.nbt.CustomChunkReader;
import journeymap.client.io.nbt.RegionLoader;
import journeymap.client.model.chunk.ChunkMD;
import journeymap.common.Journeymap;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2802;
import net.minecraft.class_2812;
import net.minecraft.class_2818;
import net.minecraft.class_310;
import net.minecraft.class_3977;
import net.minecraft.class_4284;
import net.minecraft.class_638;
import org.apache.logging.log4j.Logger;

public class JMChunkLoader {
    private static Logger logger = Journeymap.getLogger();

    public static ChunkMD getChunkMD(class_3977 loader, class_310 mc, class_1923 coord, boolean forceRetain) {
        if (RegionLoader.getRegionFile(mc, coord.field_9181, coord.field_9180).exists()) {
            return JMChunkLoader.getChunkFromRegion(mc.field_1687, coord, loader, forceRetain);
        }
        logger.warn("Region doesn't exist for chunk: " + String.valueOf(coord));
        return null;
    }

    private static ChunkMD getChunkFromRegion(class_638 world, class_1923 coord, class_3977 loader, boolean forceRetain) {
        try {
            Optional nbt = (Optional)loader.method_23696(coord).get();
            if (nbt.isPresent()) {
                return JMChunkLoader.getChunkFromNBT(world, coord, (class_2487)nbt.get(), forceRetain);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static ChunkMD getChunkFromNBT(class_638 world, class_1923 coord, class_2487 nbt, boolean forceRetain) {
        int dataVersion;
        DataFixer fixer = class_310.method_1551().method_1543();
        nbt = class_4284.field_19214.method_48130(fixer, nbt, dataVersion = class_3977.method_17908((class_2487)nbt));
        CustomChunkReader.ProcessedChunk processedChunk = CustomChunkReader.read(world, coord, nbt);
        if (processedChunk != null && processedChunk.chunk() != null) {
            return new ChunkMD(processedChunk.chunk(), forceRetain, processedChunk.light());
        }
        return null;
    }

    public static ChunkMD getChunkMdFromMemory(class_1937 level, int chunkX, int chunkZ) {
        class_2818 theChunk;
        class_2802 provider;
        if (level != null && level == class_310.method_1551().field_1724.method_73183() && (provider = level.method_8398()) != null && (theChunk = level.method_8497(chunkX, chunkZ)) != null && !(theChunk instanceof class_2812) && theChunk.method_12200() == class_310.method_1551().field_1724.method_73183()) {
            return new ChunkMD(theChunk);
        }
        return null;
    }
}

