/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.helpers;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import journeymap.common.Journeymap;
import journeymap.common.util.ObfuscationHelper;
import org.jetbrains.annotations.NotNull;

public class FabricObfHelper
implements ObfuscationHelper {
    @Override
    @NotNull
    public <T> Field findField(@NotNull Class<? super T> declaringClass, @NotNull String propertyEnumStaticFieldName) {
        Field f = FabricObfHelper.getFieldInternal(declaringClass, propertyEnumStaticFieldName);
        if (f != null) {
            return f;
        }
        throw new IllegalArgumentException("Could not find any of fields " + propertyEnumStaticFieldName + " on class " + String.valueOf(declaringClass));
    }

    @Override
    public Method findMethod(@NotNull Class<?> declaringClass, @NotNull String methodName, Class<?> ... methodArgTypes) {
        try {
            Method m = declaringClass.getDeclaredMethod(methodName, methodArgTypes);
            m.setAccessible(true);
            return m;
        }
        catch (NoSuchMethodException | SecurityException e) {
            Journeymap.getLogger().error("No Such Method in class {} : {} : {}", (Object)declaringClass.getName(), (Object)methodName, methodArgTypes);
            return null;
        }
    }

    private static Field getFieldInternal(Class<?> cls, String name) {
        try {
            Field f = cls.getDeclaredField(name);
            f.setAccessible(true);
            return f;
        }
        catch (NoSuchFieldException | SecurityException e) {
            return null;
        }
    }
}

