/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.texture;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.GpuTexture;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.class_1011;
import net.minecraft.class_1923;

public class RegionMipmapGenerator {
    private static final float[] GAMMA_POW_2_2 = new float[256];

    public static class_1011[] generateMipmaps(class_1011 baseImage, int mipmapLevel) {
        class_1011[] mipmaps = new class_1011[mipmapLevel + 1];
        mipmaps[0] = baseImage;
        for (int i = 1; i <= mipmapLevel; ++i) {
            class_1011 image = mipmaps[i - 1];
            class_1011 nextImage = new class_1011(image.method_4307() >> 1, image.method_4323() >> 1, false);
            int width = nextImage.method_4307();
            int height = nextImage.method_4323();
            for (int x = 0; x < width; ++x) {
                for (int y = 0; y < height; ++y) {
                    nextImage.method_61941(x, y, RegionMipmapGenerator.alphaBlend(image.method_61940(x * 2 + 0, y * 2 + 0), image.method_61940(x * 2 + 1, y * 2 + 0), image.method_61940(x * 2 + 0, y * 2 + 1), image.method_61940(x * 2 + 1, y * 2 + 1)));
                }
            }
            mipmaps[i] = nextImage;
        }
        return mipmaps;
    }

    public static void updateMipmapsAndUpload(class_1011[] mipmaps, Set<class_1923> dirtyChunks, GpuTexture texture) {
        HashSet<class_1923> dirtyChunksPrev = new HashSet<class_1923>(dirtyChunks);
        int chunkSize = 16;
        for (int i = 1; i < mipmaps.length; ++i) {
            HashSet<class_1923> dirtyChunksScaled = new HashSet<class_1923>();
            for (class_1923 pos : dirtyChunksPrev) {
                dirtyChunksScaled.add(new class_1923(pos.field_9181 >> 1, pos.field_9180 >> 1));
            }
            dirtyChunksPrev = dirtyChunksScaled;
            class_1011 image = mipmaps[i - 1];
            class_1011 nextImage = mipmaps[i];
            chunkSize = Math.max(chunkSize >> 1, 1);
            for (class_1923 pos : dirtyChunksScaled) {
                for (int x = pos.field_9181; x < pos.field_9181 + chunkSize; ++x) {
                    for (int y = pos.field_9180; y < pos.field_9180 + chunkSize; ++y) {
                        nextImage.method_61941(x, y, RegionMipmapGenerator.alphaBlend(image.method_61940(x * 2 + 0, y * 2 + 0), image.method_61940(x * 2 + 1, y * 2 + 0), image.method_61940(x * 2 + 0, y * 2 + 1), image.method_61940(x * 2 + 1, y * 2 + 1)));
                    }
                }
                RenderSystem.getDevice().createCommandEncoder().writeToTexture(texture, nextImage, i, 0, pos.field_9181, pos.field_9180, chunkSize, chunkSize, pos.field_9181, pos.field_9180);
            }
            mipmaps[i] = nextImage;
        }
    }

    private static int alphaBlend(int color1, int color2, int color3, int color4) {
        float r = 0.0f;
        float g = 0.0f;
        float b = 0.0f;
        int count = 0;
        if (color1 >> 24 != 0) {
            r += RegionMipmapGenerator.getPow22(color1 >> 0);
            g += RegionMipmapGenerator.getPow22(color1 >> 8);
            b += RegionMipmapGenerator.getPow22(color1 >> 16);
            ++count;
        }
        if (color2 >> 24 != 0) {
            r += RegionMipmapGenerator.getPow22(color2 >> 0);
            g += RegionMipmapGenerator.getPow22(color2 >> 8);
            b += RegionMipmapGenerator.getPow22(color2 >> 16);
            ++count;
        }
        if (color3 >> 24 != 0) {
            r += RegionMipmapGenerator.getPow22(color3 >> 0);
            g += RegionMipmapGenerator.getPow22(color3 >> 8);
            b += RegionMipmapGenerator.getPow22(color3 >> 16);
            ++count;
        }
        if (color4 >> 24 != 0) {
            r += RegionMipmapGenerator.getPow22(color4 >> 0);
            g += RegionMipmapGenerator.getPow22(color4 >> 8);
            b += RegionMipmapGenerator.getPow22(color4 >> 16);
            ++count;
        }
        if (count == 0) {
            return 0;
        }
        int r2 = (int)(Math.pow(r /= (float)count, 0.45454545454545453) * 255.0);
        int g2 = (int)(Math.pow(g /= (float)count, 0.45454545454545453) * 255.0);
        int b2 = (int)(Math.pow(b /= (float)count, 0.45454545454545453) * 255.0);
        return 0xFF000000 | b2 << 16 | g2 << 8 | r2;
    }

    private static float getPow22(int value) {
        return GAMMA_POW_2_2[value & 0xFF];
    }

    static {
        for (int i = 0; i < 256; ++i) {
            RegionMipmapGenerator.GAMMA_POW_2_2[i] = (float)Math.pow((float)i / 255.0f, 2.2);
        }
    }
}

