/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.minimap;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import javax.annotation.Nullable;
import journeymap.api.services.EventBus;
import journeymap.api.v2.client.event.InfoSlotDisplayEvent;
import journeymap.api.v2.client.util.tuple.Tuple2;
import journeymap.client.io.ThemeLoader;
import journeymap.client.model.map.MapType;
import journeymap.client.properties.MiniMapProperties;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.texture.TextureCache;
import journeymap.client.ui.minimap.LabelVars;
import journeymap.client.ui.minimap.Orientation;
import journeymap.client.ui.minimap.Position;
import journeymap.client.ui.minimap.Shape;
import journeymap.client.ui.option.LocationFormat;
import journeymap.client.ui.theme.Theme;
import journeymap.client.ui.theme.ThemeCompassPoints;
import journeymap.client.ui.theme.ThemeLabelSource;
import journeymap.client.ui.theme.ThemeMinimapFrame;
import net.minecraft.class_1041;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;

public class DisplayVars {
    private final Position position;
    private final Shape shape;
    private final Orientation orientation;
    private final double fontScale;
    private final double infoSlotFontScale;
    private final int displayWidth;
    private final int displayHeight;
    private final float terrainAlpha;
    private final class_1041 mainWindow;
    private final double minimapWidth;
    private final double minimapHeight;
    private final double textureX;
    private final double textureY;
    private final double translateX;
    private final double translateY;
    private final double reticleSegmentLength;
    private final Point2D.Double centerPoint;
    private final boolean showCompass;
    private final boolean showReticle;
    private final List<Tuple2<LabelVars, ThemeLabelSource.InfoSlot>> labels = new ArrayList<Tuple2<LabelVars, ThemeLabelSource.InfoSlot>>(4);
    private final Theme theme;
    private final ThemeMinimapFrame minimapFrame;
    private final ThemeCompassPoints minimapCompassPoints;
    private final Theme.Minimap.MinimapSpec minimapSpec;
    private final LocationFormat.LocationFormatKeys locationFormatKeys;
    private final boolean locationFormatVerbose;
    private final boolean frameRotates;
    private int marginX;
    private int marginY;
    private MapTypeStatus mapTypeStatus;
    private MapPresetStatus mapPresetStatus;
    private float positionY;
    private float positionX;

    DisplayVars(class_310 mc, MiniMapProperties miniMapProperties, @Nullable ThemeMinimapFrame frame) {
        int startY;
        this.mainWindow = mc.method_22683();
        this.showCompass = miniMapProperties.showCompass.get();
        this.showReticle = miniMapProperties.showReticle.get();
        this.position = (Position)((Object)miniMapProperties.position.get());
        this.orientation = (Orientation)((Object)miniMapProperties.orientation.get());
        this.displayWidth = mc.method_22683().method_4489();
        this.displayHeight = mc.method_22683().method_4506();
        this.terrainAlpha = Math.max(0.0f, Math.min(1.0f, (float)miniMapProperties.terrainAlpha.get().intValue() / 100.0f));
        this.locationFormatKeys = new LocationFormat().getFormatKeys(miniMapProperties.locationFormat.get());
        this.locationFormatVerbose = miniMapProperties.locationFormatVerbose.get();
        this.theme = ThemeLoader.getCurrentTheme();
        this.positionY = miniMapProperties.positionY.get().floatValue();
        this.positionX = miniMapProperties.positionX.get().floatValue();
        switch ((Shape)((Object)miniMapProperties.shape.get())) {
            case Rectangle_Horizontal: {
                double ratio;
                if (this.theme.minimap.square != null) {
                    this.shape = Shape.Rectangle_Horizontal;
                    this.minimapSpec = this.theme.minimap.square;
                    ratio = (double)mc.method_22683().method_4489() * 1.0 / (double)mc.method_22683().method_4506();
                    this.minimapHeight = miniMapProperties.getSize();
                    this.minimapWidth = this.minimapHeight * ratio;
                    this.reticleSegmentLength = this.minimapWidth / 1.5;
                    break;
                }
            }
            case Rectangle_Vertical: {
                double ratio;
                if (this.theme.minimap.square != null) {
                    this.shape = Shape.Rectangle_Vertical;
                    this.minimapSpec = this.theme.minimap.square;
                    ratio = (double)mc.method_22683().method_4489() * 1.0 / (double)mc.method_22683().method_4506();
                    this.minimapHeight = (double)miniMapProperties.getSize() * ratio;
                    this.minimapWidth = miniMapProperties.getSize();
                    this.reticleSegmentLength = this.minimapHeight / 1.5;
                    break;
                }
            }
            case Circle: {
                if (this.theme.minimap.circle != null) {
                    this.shape = Shape.Circle;
                    this.minimapSpec = this.theme.minimap.circle;
                    this.minimapWidth = miniMapProperties.getSize();
                    this.minimapHeight = miniMapProperties.getSize();
                    this.reticleSegmentLength = this.minimapHeight / 2.0;
                    break;
                }
            }
            default: {
                this.shape = Shape.Square;
                this.minimapSpec = this.theme.minimap.square;
                this.minimapWidth = miniMapProperties.getSize();
                this.minimapHeight = miniMapProperties.getSize();
                this.reticleSegmentLength = Math.sqrt(this.minimapHeight * this.minimapHeight + this.minimapWidth * this.minimapWidth) / 2.0;
            }
        }
        this.fontScale = miniMapProperties.getFontScale();
        this.infoSlotFontScale = miniMapProperties.getInfoSlotFontScale();
        class_327 fontRenderer = mc.field_1772;
        Tuple2<List<ThemeLabelSource.InfoSlot>, List<ThemeLabelSource.InfoSlot>> tuple = this.getInfoSlotLabels(miniMapProperties);
        List topLabels = (List)tuple.a();
        List bottomLabels = (List)tuple.b();
        int topInfoLabelsHeight = this.getInfoLabelAreaHeight(fontRenderer, this.minimapSpec.labelTop, topLabels);
        int bottomInfoLabelsHeight = this.getInfoLabelAreaHeight(fontRenderer, this.minimapSpec.labelBottom, bottomLabels);
        float compassFontScale = miniMapProperties.getCompassFontScale();
        float compassLabelHeight = 0.0f;
        if (this.showCompass) {
            compassLabelHeight = (float)DrawUtil.getLabelHeight(fontRenderer, this.minimapSpec.compassLabel.shadow) * compassFontScale;
        }
        if (frame == null || this.minimapSpec != frame.minimapSpec || frame.theme != this.theme || frame.getWidth() != this.minimapWidth || frame.getHeight() != this.minimapHeight || frame.clear) {
            if (frame != null) {
                frame.clear();
            }
            this.minimapFrame = new ThemeMinimapFrame(this.theme, this.minimapSpec, miniMapProperties, this.minimapWidth, this.minimapHeight);
        } else {
            this.minimapFrame = frame;
        }
        this.marginX = this.marginY = this.minimapSpec.margin;
        if (this.showCompass) {
            double compassPointMargin;
            boolean compassExists;
            boolean bl = compassExists = this.minimapSpec.compassPoint != null && this.minimapSpec.compassPoint.width > 0;
            if (compassExists) {
                float compassPointScale = ThemeCompassPoints.getCompassPointScale(compassLabelHeight, this.minimapSpec);
                compassPointMargin = (float)(this.minimapSpec.compassPoint.width >> 1) * compassPointScale;
            } else {
                compassPointMargin = compassLabelHeight;
            }
            this.marginX = (int)Math.max((double)this.marginX, Math.ceil(compassPointMargin));
            this.marginY = (int)Math.max((double)this.marginY, Math.ceil(compassPointMargin) + (double)(compassLabelHeight / 2.0f));
        }
        double halfWidth = this.minimapWidth / 2.0;
        double halfHeight = this.minimapHeight / 2.0;
        int screenHeight = mc.method_22683().method_4506();
        int screenWidth = mc.method_22683().method_4489();
        switch (this.position) {
            case BottomRight: {
                if (!this.minimapSpec.labelBottomInside) {
                    this.marginY += bottomInfoLabelsHeight;
                }
                this.textureX = (double)screenWidth - this.minimapWidth - (double)this.marginX;
                this.textureY = (double)screenHeight - this.minimapHeight - (double)this.marginY;
                this.translateX = (double)screenWidth / 2.0 - halfWidth - (double)this.marginX;
                this.translateY = (double)screenHeight / 2.0 - halfHeight - (double)this.marginY;
                break;
            }
            case TopLeft: {
                if (!this.minimapSpec.labelTopInside) {
                    this.marginY += topInfoLabelsHeight;
                    this.marginY = Math.max(this.marginY, topInfoLabelsHeight + 2 * this.minimapSpec.margin);
                }
                this.textureX = this.marginX;
                this.textureY = this.marginY;
                this.translateX = -((double)screenWidth / 2.0) + halfWidth + (double)this.marginX;
                this.translateY = -((double)screenHeight / 2.0) + halfHeight + (double)this.marginY;
                break;
            }
            case BottomLeft: {
                if (!this.minimapSpec.labelBottomInside) {
                    this.marginY += bottomInfoLabelsHeight;
                }
                this.textureX = this.marginX;
                this.textureY = (double)screenHeight - this.minimapHeight - (double)this.marginY;
                this.translateX = -((double)screenWidth / 2.0) + halfWidth + (double)this.marginX;
                this.translateY = (double)screenHeight / 2.0 - halfHeight - (double)this.marginY;
                break;
            }
            case TopCenter: {
                if (!this.minimapSpec.labelTopInside) {
                    this.marginY += topInfoLabelsHeight;
                    this.marginY = Math.max(this.marginY, topInfoLabelsHeight + 2 * this.minimapSpec.margin);
                }
                this.textureX = ((double)screenWidth - this.minimapWidth) / 2.0;
                this.textureY = this.marginY;
                this.translateX = 0.0;
                this.translateY = -((double)screenHeight / 2.0) + halfHeight + (double)this.marginY;
                break;
            }
            case Center: {
                this.textureX = ((double)screenWidth - this.minimapWidth) / 2.0;
                this.textureY = ((double)screenHeight - this.minimapHeight) / 2.0;
                this.translateX = 0.0;
                this.translateY = 0.0;
                break;
            }
            case Custom: {
                this.textureX = (float)screenWidth * this.positionX;
                this.textureY = (float)screenHeight * this.positionY;
                this.translateX = this.textureX - (double)screenWidth / 2.0 + halfWidth;
                this.translateY = this.textureY - (double)screenHeight / 2.0 + halfHeight;
                break;
            }
            default: {
                if (!this.minimapSpec.labelTopInside) {
                    this.marginY += topInfoLabelsHeight;
                    this.marginY = Math.max(this.marginY, topInfoLabelsHeight + 2 * this.minimapSpec.margin);
                }
                this.textureX = (double)screenWidth - this.minimapWidth - (double)this.marginX;
                this.textureY = this.marginY;
                this.translateX = (double)screenWidth / 2.0 - halfWidth - (double)this.marginX;
                this.translateY = -((double)screenHeight / 2.0) + halfHeight + (double)this.marginY;
            }
        }
        this.minimapFrame.setPosition(this.textureX, this.textureY);
        this.centerPoint = new Point2D.Double(this.textureX + halfWidth, this.textureY + halfHeight);
        this.minimapCompassPoints = new ThemeCompassPoints(this.textureX, this.textureY, halfWidth, halfHeight, this.minimapSpec, miniMapProperties, this.minimapFrame.getCompassPoint(), compassLabelHeight);
        this.frameRotates = this.shape == Shape.Circle ? ((Theme.Minimap.MinimapCircle)this.minimapSpec).rotates : false;
        int centerX = (int)(this.textureX + this.minimapWidth / 2.0);
        int margin = this.minimapSpec.margin;
        if (topInfoLabelsHeight > 0) {
            startY = (int)(this.minimapSpec.labelTopInside ? this.textureY + (double)margin : this.textureY - (double)margin - (double)topInfoLabelsHeight);
            this.positionLabels(fontRenderer, centerX, startY, this.minimapSpec.labelTop, topLabels);
        }
        if (bottomInfoLabelsHeight > 0) {
            startY = (int)(this.textureY + this.minimapHeight);
            this.positionLabels(fontRenderer, centerX, startY += this.minimapSpec.labelBottomInside ? -margin - bottomInfoLabelsHeight : margin, this.minimapSpec.labelBottom, bottomLabels);
        }
        ThemeLabelSource.resetCaches();
    }

    public Shape getShape() {
        return this.shape;
    }

    public Tuple2<List<ThemeLabelSource.InfoSlot>, List<ThemeLabelSource.InfoSlot>> getInfoSlotLabels(MiniMapProperties miniMapProperties) {
        ArrayList topLabels = new ArrayList();
        ArrayList bottomLabels = new ArrayList();
        LinkedHashMap<String, InfoSlotDisplayEvent.Position> map = new LinkedHashMap<String, InfoSlotDisplayEvent.Position>();
        map.put(miniMapProperties.info1Label.get(), (InfoSlotDisplayEvent.Position)miniMapProperties.info1LabelPosition.get());
        map.put(miniMapProperties.info2Label.get(), (InfoSlotDisplayEvent.Position)miniMapProperties.info2LabelPosition.get());
        map.put(miniMapProperties.info3Label.get(), (InfoSlotDisplayEvent.Position)miniMapProperties.info3LabelPosition.get());
        map.put(miniMapProperties.info4Label.get(), (InfoSlotDisplayEvent.Position)miniMapProperties.info4LabelPosition.get());
        EventBus.post(new InfoSlotDisplayEvent(map));
        map.forEach((infoSlot, slotPos) -> {
            if (InfoSlotDisplayEvent.Position.Top == slotPos) {
                topLabels.add(ThemeLabelSource.values.get(infoSlot));
            }
            if (InfoSlotDisplayEvent.Position.Bottom == slotPos) {
                bottomLabels.add(ThemeLabelSource.values.get(infoSlot));
            }
        });
        return new Tuple2(topLabels, bottomLabels);
    }

    public int getInfoLabelAreaHeight(class_327 fontRenderer, Theme.LabelSpec labelSpec, List<ThemeLabelSource.InfoSlot> themeLabelSources) {
        int labelHeight = this.getInfoLabelHeight(fontRenderer, labelSpec);
        int areaHeight = 0;
        for (ThemeLabelSource.InfoSlot themeLabelSource : themeLabelSources) {
            areaHeight += themeLabelSource.isShown() ? labelHeight : 0;
        }
        return areaHeight;
    }

    private int getInfoLabelHeight(class_327 fontRenderer, Theme.LabelSpec labelSpec) {
        return (int)((double)(DrawUtil.getLabelHeight(fontRenderer, labelSpec.shadow) + labelSpec.margin) * this.infoSlotFontScale);
    }

    private void positionLabels(class_327 fontRenderer, int centerX, int startY, Theme.LabelSpec labelSpec, List<ThemeLabelSource.InfoSlot> themeLabelSources) {
        int labelHeight = this.getInfoLabelHeight(fontRenderer, labelSpec);
        int labelY = startY;
        for (ThemeLabelSource.InfoSlot themeLabelSource : themeLabelSources) {
            if (!themeLabelSource.isShown()) continue;
            LabelVars labelVars = new LabelVars(this, centerX, labelY, DrawUtil.HAlign.Center, DrawUtil.VAlign.Below, this.infoSlotFontScale, labelSpec);
            Tuple2 tuple = new Tuple2((Object)labelVars, (Object)themeLabelSource);
            this.labels.add((Tuple2<LabelVars, ThemeLabelSource.InfoSlot>)tuple);
            labelY += labelHeight;
        }
    }

    public void drawInfoLabels(class_332 graphics, long currentTimeMillis) {
        for (Tuple2<LabelVars, ThemeLabelSource.InfoSlot> label : this.labels) {
            ((LabelVars)label.a()).draw(graphics, ((ThemeLabelSource.InfoSlot)label.b()).getLabelText(currentTimeMillis));
        }
    }

    MapPresetStatus getMapPresetStatus(MapType mapType, int miniMapId) {
        if (this.mapPresetStatus == null || !mapType.equals(this.mapPresetStatus.mapType) || miniMapId != this.mapPresetStatus.miniMapId) {
            this.mapPresetStatus = new MapPresetStatus(this, mapType, miniMapId);
        }
        return this.mapPresetStatus;
    }

    MapTypeStatus getMapTypeStatus(MapType mapType) {
        if (this.mapTypeStatus == null || !mapType.equals(this.mapTypeStatus.mapType)) {
            this.mapTypeStatus = new MapTypeStatus(this, mapType);
        }
        return this.mapTypeStatus;
    }

    public Position getPosition() {
        return this.position;
    }

    public Orientation getOrientation() {
        return this.orientation;
    }

    public double getFontScale() {
        return this.fontScale;
    }

    public double getInfoSlotFontScale() {
        return this.infoSlotFontScale;
    }

    public int getDisplayWidth() {
        return this.displayWidth;
    }

    public int getDisplayHeight() {
        return this.displayHeight;
    }

    public float getTerrainAlpha() {
        return this.terrainAlpha;
    }

    public class_1041 getMainWindow() {
        return this.mainWindow;
    }

    public float getMinimapWidth() {
        return (float)this.minimapWidth;
    }

    public float getMinimapHeight() {
        return (float)this.minimapHeight;
    }

    public float getTextureX() {
        return (float)this.textureX;
    }

    public float getTextureY() {
        return (float)this.textureY;
    }

    public float getTranslateX() {
        return (float)this.translateX;
    }

    public float getTranslateY() {
        return (float)this.translateY;
    }

    public double getReticleSegmentLength() {
        return this.reticleSegmentLength;
    }

    public Point2D.Double getCenterPoint() {
        return this.centerPoint;
    }

    public boolean isShowCompass() {
        return this.showCompass;
    }

    public boolean isShowReticle() {
        return this.showReticle;
    }

    public List<Tuple2<LabelVars, ThemeLabelSource.InfoSlot>> getLabels() {
        return this.labels;
    }

    public Theme getTheme() {
        return this.theme;
    }

    public ThemeMinimapFrame getMinimapFrame() {
        return this.minimapFrame;
    }

    public ThemeCompassPoints getMinimapCompassPoints() {
        return this.minimapCompassPoints;
    }

    public Theme.Minimap.MinimapSpec getMinimapSpec() {
        return this.minimapSpec;
    }

    public LocationFormat.LocationFormatKeys getLocationFormatKeys() {
        return this.locationFormatKeys;
    }

    public boolean isLocationFormatVerbose() {
        return this.locationFormatVerbose;
    }

    public boolean isFrameRotates() {
        return this.frameRotates;
    }

    public int getMarginX() {
        return this.marginX;
    }

    public int getMarginY() {
        return this.marginY;
    }

    public MapTypeStatus getMapTypeStatus() {
        return this.mapTypeStatus;
    }

    public MapPresetStatus getMapPresetStatus() {
        return this.mapPresetStatus;
    }

    public float getPositionY() {
        return this.positionY;
    }

    public float getPositionX() {
        return this.positionX;
    }

    class MapPresetStatus {
        private int miniMapId;
        private int scale = 4;
        private MapType mapType;
        private String name;
        private Integer color;

        MapPresetStatus(DisplayVars this$0, MapType mapType, int miniMapId) {
            this.miniMapId = miniMapId;
            this.mapType = mapType;
            this.color = -1;
            this.name = Integer.toString(miniMapId);
        }

        void draw(class_332 graphics, Point2D.Double mapCenter, float alpha, double rotation) {
            DrawUtil.drawLabel(graphics, (class_2561)class_2561.method_43470((String)this.name), mapCenter.getX(), mapCenter.getY() + 8.0, DrawUtil.HAlign.Center, DrawUtil.VAlign.Below, -16777216, 0.0f, this.color, alpha, this.scale, true, rotation);
        }
    }

    class MapTypeStatus {
        private final MapType mapType;
        private final String name;
        private final class_2960 tex;
        private final Integer color;
        private final Integer opposite;
        private final float bgScale;
        private final float scaleHeightOffset;
        private final int height;
        private final int width;

        MapTypeStatus(DisplayVars this$0, MapType mapType) {
            this.mapType = mapType;
            this.name = mapType.isUnderground() ? "caves" : mapType.name();
            this.tex = TextureCache.getThemeTexture(this$0.theme, String.format("icon/%s.png", this.name));
            this.color = 0xFFFFFF;
            this.opposite = 0x404040;
            this.bgScale = 3.0f;
            this.height = ThemeLoader.getCurrentTheme().icon.height;
            this.width = ThemeLoader.getCurrentTheme().icon.width;
            this.scaleHeightOffset = (float)this.height * this.bgScale - (float)(this.height >> 1);
        }

        void draw(class_332 graphics, Point2D.Double mapCenter, float alpha, double rotation) {
            double x = mapCenter.getX();
            double y = mapCenter.getY() - (double)this.height + 20.0;
            DrawUtil.drawOnMapImageScaleCorrected(graphics, this.tex, this.opposite, alpha, x + 1.0, y + 1.0, this.width, this.height, this.bgScale, 0.0, true);
            DrawUtil.drawOnMapImageScaleCorrected(graphics, this.tex, this.color, alpha, x, y, this.width, this.height, this.bgScale, 0.0, true);
        }
    }
}

