/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.waypointmanager.notification;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import journeymap.client.Constants;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.ui.component.Slot;
import journeymap.client.ui.component.buttons.CheckBox;
import journeymap.client.ui.component.widgets.StringWidget;
import journeymap.client.ui.option.SlotMetadata;
import journeymap.client.ui.waypointmanager.ManagerSlot;
import journeymap.client.waypoint.ClientWaypointImpl;
import net.minecraft.class_124;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4185;
import net.minecraft.class_5481;
import net.minecraft.class_7843;
import net.minecraft.class_7847;
import net.minecraft.class_8021;
import net.minecraft.class_8030;
import net.minecraft.class_8133;
import net.minecraft.class_8667;
import org.jetbrains.annotations.NotNull;

public class WaypointNotificationSlot
extends ManagerSlot {
    private class_8667 layout = class_8667.method_52742();
    private final ClientWaypointImpl waypoint;
    private final String from;
    private CheckBox checkBox;
    private boolean checked = false;
    private ManagerSlot.ToolTipMeta tooltip;

    public WaypointNotificationSlot(ClientWaypointImpl waypoint, String from) {
        this.from = from;
        this.waypoint = waypoint;
    }

    @Override
    public void repositionElements() {
        this.layout.method_48222();
        class_7843.method_48634((class_8021)this.layout, (class_8030)this.method_48202());
    }

    @Override
    public void init() {
        class_327 font = class_310.method_1551().field_1772;
        this.tooltip = this.getToolTip();
        this.checkBox = (CheckBox)this.layout.method_52738((class_8021)new CheckBox("", false, this::checked), class_7847::method_46470);
        this.layout.method_52738((class_8021)new StringWidget((class_2561)class_2561.method_43470((String)this.waypoint.getName()), 120, font).alignLeft(), class_7847::method_46474);
        this.layout.method_52738((class_8021)new StringWidget((class_2561)class_2561.method_43470((String)this.from), 85, font).alignLeft(), class_7847::method_46474);
        this.repositionElements();
    }

    private ManagerSlot.ToolTipMeta getToolTip() {
        class_2338 pos = this.waypoint.getBlockPos();
        ArrayList<class_5481> list = new ArrayList<class_5481>();
        list.add(this.buildTooltip(Constants.getString("jm.common.waypoint.notification.name.label"), this.waypoint.getName()));
        list.add(this.buildTooltip(Constants.getString("jm.common.waypoint.notification.dim.label"), this.waypoint.getPrimaryDimension()));
        list.add(this.buildTooltip(Constants.getString("jm.common.waypoint.notification.block.label"), "[x:" + pos.method_10263() + ", y:" + pos.method_10264() + ", z:" + pos.method_10260() + "]"));
        list.add(this.buildTooltip(Constants.getString("jm.common.waypoint.notification.group.label"), this.waypoint.getGroupId()));
        list.add(this.buildTooltip(Constants.getString("jm.common.waypoint.notification.shared_by.label"), Constants.getString("jm.common.waypoint.notification.shared_by_from.label", this.from)));
        return new ManagerSlot.ToolTipMeta(list);
    }

    private class_5481 buildTooltip(String key, String value) {
        return class_5481.method_34909((class_5481[])new class_5481[]{class_5481.method_30747((String)key, (class_2583)class_2583.field_24360.method_27705(new class_124[]{class_124.field_1075, class_124.field_1073})), class_5481.method_30747((String)" ", (class_2583)class_2583.field_24360), class_5481.method_30747((String)value, (class_2583)class_2583.field_24360.method_27706(class_124.field_1060))});
    }

    @Override
    public class_8133 getLayout() {
        return this.layout;
    }

    public void method_25343(class_332 graphics, int mouseX, int mouseY, boolean hovered, float partialTicks) {
        int x = this.method_73380();
        int y = this.method_73382();
        int rowWidth = this.method_73387();
        int itemHeight = this.method_73384();
        this.layout.method_46421(x + 3);
        this.layout.method_46419(y + 3);
        DrawUtil.drawRectangle(graphics, x, y, rowWidth - 5, itemHeight, 0, 0.25f);
        this.outline(graphics, x, y, rowWidth - 5, itemHeight, 0xC0C0C0, 0.25f);
        this.layout.method_48206(widget -> widget.method_25394(graphics, mouseX, mouseY, partialTicks));
    }

    private void checked(class_4185 button) {
        this.setChecked(((CheckBox)button).getToggled());
    }

    public boolean isChecked() {
        return this.checked;
    }

    public ClientWaypointImpl getWaypoint() {
        return this.waypoint;
    }

    public void setChecked(boolean checked) {
        this.checked = checked;
        this.checkBox.setToggled(checked);
    }

    @Override
    public Collection<SlotMetadata> getMetadata() {
        return null;
    }

    @Override
    public List<? extends Slot> getChildSlots(int listWidth, int columnWidth) {
        return null;
    }

    @Override
    public SlotMetadata getLastPressed() {
        return null;
    }

    @Override
    public SlotMetadata getCurrentTooltip() {
        AtomicBoolean showTooltip = new AtomicBoolean(true);
        this.layout.method_48206(widget -> {
            class_4185 button;
            if (widget instanceof class_4185 && (button = (class_4185)widget).method_49606()) {
                showTooltip.set(false);
            }
        });
        return showTooltip.get() ? this.tooltip : null;
    }

    @Override
    public void setEnabled(boolean enabled) {
    }

    @Override
    public boolean contains(SlotMetadata slotMetadata) {
        return false;
    }

    @Override
    public int compareTo(@NotNull ManagerSlot o) {
        return 0;
    }
}

