/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.properties;

import journeymap.common.properties.ServerOption;
import journeymap.common.properties.ServerPropertiesBase;
import journeymap.common.properties.catagory.Category;
import journeymap.common.properties.config.BooleanField;
import journeymap.common.properties.config.EnumField;
import journeymap.common.properties.config.IntegerField;

public abstract class PermissionProperties
extends ServerPropertiesBase {
    public final BooleanField minimapEnabled = new BooleanField(Category.Inherit, "jm.server.enable.minimap", true, 45);
    public final BooleanField hideCoordinates = new BooleanField(Category.Inherit, "jm.server.hide.coordinates", false, 45);
    public final BooleanField teleportEnabled = new BooleanField(Category.Inherit, "jm.server.edit.chkbox.teleport", false, 45);
    public final BooleanField crossDimTeleport = new BooleanField(Category.Inherit, "jm.server.cross_dim_tp", true, 45);
    public final IntegerField surfaceRenderRange = new IntegerField(Category.Inherit, "jm.server.surface_render_range", 0, 32, 0, 120);
    public final IntegerField caveRenderRange = new IntegerField(Category.Inherit, "jm.server.cave_render_range", 0, 32, 0, 121);
    public final EnumField<ServerOption> surfaceMapping = new EnumField<ServerOption>(Category.Inherit, "jm.server.edit.mapping.toggle.surface", ServerOption.ALL, 50);
    public final EnumField<ServerOption> topoMapping = new EnumField<ServerOption>(Category.Inherit, "jm.server.edit.mapping.toggle.topo", ServerOption.ALL, 55);
    public final EnumField<ServerOption> biomeMapping = new EnumField<ServerOption>(Category.Inherit, "jm.server.edit.mapping.toggle.biome", ServerOption.ALL, 55);
    public final EnumField<ServerOption> caveMapping = new EnumField<ServerOption>(Category.Inherit, "jm.server.edit.mapping.toggle.cave", ServerOption.ALL, 60);
    public final EnumField<ServerOption> radarEnabled = new EnumField<ServerOption>(Category.Inherit, "jm.server.edit.radar", ServerOption.ALL, 80);
    public final BooleanField playerRadarEnabled = new BooleanField(Category.Inherit, "jm.server.edit.radar.chkbox.player", true, 81).setParent("radarEnabled", (Object)ServerOption.ALL);
    public final BooleanField playerRadarNamesEnabled = new BooleanField(Category.Inherit, "jm.server.edit.radar.player_names", true, 82);
    public final BooleanField villagerRadarEnabled = new BooleanField(Category.Inherit, "jm.server.edit.radar.chkbox.villager", true, 84).setParent("radarEnabled", (Object)ServerOption.ALL);
    public final BooleanField animalRadarEnabled = new BooleanField(Category.Inherit, "jm.server.edit.radar.chkbox.animal", true, 85).setParent("radarEnabled", (Object)ServerOption.ALL);
    public final BooleanField mobRadarEnabled = new BooleanField(Category.Inherit, "jm.server.edit.radar.chkbox.mob", true, 86).setParent("radarEnabled", (Object)ServerOption.ALL);

    protected PermissionProperties(String displayName, String description) {
        super(displayName, description);
    }

    @Override
    protected void postLoad(boolean isNew) {
        if (!isNew) {
            this.serverOptionFix(this.radarEnabled);
            this.serverOptionFix(this.surfaceMapping);
            this.serverOptionFix(this.topoMapping);
            this.serverOptionFix(this.caveMapping);
        }
        super.postLoad(isNew);
    }

    protected void serverOptionFix(EnumField<ServerOption> option) {
        if ("true".equals(option.get("value").toString()) || "false".equals(option.get("value").toString())) {
            option.set(Boolean.parseBoolean(option.get("value").toString()) ? ServerOption.ALL : ServerOption.NONE);
            this.save();
        }
    }
}

