/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client;

import journeymap.client.JourneymapClient;
import journeymap.client.event.ForgeEventHandlerManager;
import journeymap.client.event.ForgeKeyEvents;
import journeymap.client.event.handlers.HudOverlayHandler;
import journeymap.client.render.pip.PipRegistry;
import journeymap.common.Journeymap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.render.pip.PictureInPictureRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.event.AddGuiOverlayLayersEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.client.event.RegisterPictureInPictureRendererEvent;
import net.minecraftforge.eventbus.api.bus.BusGroup;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

public class JourneymapClientForge {
    private final ForgeKeyEvents keyEvents;
    private final JourneymapClient client;
    static JourneymapClientForge instance;

    public JourneymapClientForge(FMLJavaModLoadingContext context) {
        instance = this;
        this.client = new JourneymapClient();
        this.keyEvents = new ForgeKeyEvents();
        this.client.setKeyEvents(this.keyEvents);
        FMLCommonSetupEvent.getBus((BusGroup)context.getModBusGroup()).addListener(this::commonSetupEvent);
        FMLClientSetupEvent.getBus((BusGroup)context.getModBusGroup()).addListener(this::clientSetupEvent);
        FMLLoadCompleteEvent.getBus((BusGroup)context.getModBusGroup()).addListener(this::loadCompleteEvent);
        RegisterKeyMappingsEvent.getBus((BusGroup)context.getModBusGroup()).addListener(ForgeKeyEvents::onKeyRegisterEvent);
        RegisterPictureInPictureRendererEvent.BUS.addListener(this::registerTestPip);
        AddGuiOverlayLayersEvent.getBus((BusGroup)context.getModBusGroup()).addListener(this::onOverlayDraw);
    }

    private void registerTestPip(RegisterPictureInPictureRendererEvent event) {
        PipRegistry.getPipRenderers().values().forEach(pip -> {
            PictureInPictureRenderer renderer = (PictureInPictureRenderer)pip.apply(event.getBufferSource());
            event.register(renderer);
        });
    }

    public void onOverlayDraw(AddGuiOverlayLayersEvent event) {
        System.out.println("Adding overlay");
        event.getLayeredDraw().add(ResourceLocation.fromNamespaceAndPath((String)"journeymap", (String)"minimap"), (graphics, deltaTracker) -> {
            if (!Minecraft.getInstance().gui.getDebugOverlay().showDebugScreen()) {
                HudOverlayHandler.getInstance().onRenderOverlay(graphics);
            }
        });
    }

    private void commonSetupEvent(FMLCommonSetupEvent event) {
        this.client.commonSetup();
    }

    private void clientSetupEvent(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            Journeymap.getLogger().info("Journeymap Initializing");
            ForgeEventHandlerManager.registerHandlers();
            this.client.init();
        });
    }

    private void loadCompleteEvent(FMLLoadCompleteEvent event) {
        event.enqueueWork(() -> {
            Journeymap.getLogger().info("Journeymap PostInit");
            this.client.postInit();
        });
    }

    public static JourneymapClientForge getInstance() {
        return instance;
    }

    public ForgeKeyEvents getKeyEvents() {
        return this.keyEvents;
    }
}

