/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.component.dropdown;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import journeymap.api.v2.client.option.KeyedEnum;
import journeymap.client.Constants;
import journeymap.client.cartography.color.RGB;
import journeymap.client.ui.component.IConfigFieldHolder;
import journeymap.client.ui.component.dropdown.DropDownButton;
import journeymap.client.ui.component.dropdown.DropDownItem;
import journeymap.client.ui.component.dropdown.SelectableParent;
import journeymap.common.Journeymap;
import journeymap.common.log.LogFormatter;
import journeymap.common.properties.config.ConfigField;
import journeymap.common.properties.config.StringField;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;

public class PropertyDropdownButton<T>
extends DropDownButton
implements IConfigFieldHolder<ConfigField<T>> {
    protected final ConfigField<T> field;
    protected final String baseLabel;
    protected final String glyph = "\u21d5";
    protected final String labelPattern = "%1$s : %2$s %3$s %2$s";
    private final Collection<T> values;
    protected Button.OnPress pressable;

    public PropertyDropdownButton(Collection<T> values, String label, ConfigField<T> field, Button.OnPress pressable) {
        super("", pressable);
        this.pressable = pressable;
        this.field = field;
        this.baseLabel = label;
        this.values = values;
        this.setValue(field.get());
        this.disabledLabelColor = RGB.DARK_GRAY_RGBA;
        List<DropDownItem> items = this.setItems(values);
        super.setItems(items);
        this.setRenderDecorations(true);
        this.setRenderSolidBackground(true);
    }

    public PropertyDropdownButton(Collection<T> values, String label, ConfigField<T> field) {
        this(values, label, field, PropertyDropdownButton.emptyPressable());
    }

    protected List<DropDownItem> setItems(Collection<T> values) {
        ArrayList items = Lists.newArrayList();
        values.forEach(value -> {
            String label;
            String tooltip = null;
            if (value instanceof KeyedEnum) {
                String key = ((KeyedEnum)value).getKey();
                label = Constants.getString(key);
                String tooltipKey = key + ".tooltip";
                if (tooltipKey.equals(tooltip = Constants.getString(tooltipKey))) {
                    tooltip = null;
                }
            } else if (value instanceof String) {
                label = Constants.getString((String)value);
                Class<? extends StringField.ValuesProvider> valueProviderClass = ((StringField)this.field).getValuesProviderClass();
                try {
                    StringField.ValuesProvider valueProvider = valueProviderClass.newInstance();
                    tooltip = Constants.getString(valueProvider.getTooltip((String)value));
                }
                catch (Throwable t) {
                    Journeymap.getLogger().error(String.format("Couldn't use ValuesProvider %s: %s", valueProviderClass, LogFormatter.toString(t)));
                }
            } else {
                label = Constants.getString(value.toString());
            }
            if (tooltip == null) {
                items.add(new DropDownItem(this, value, label));
            } else {
                items.add(new DropDownItem((SelectableParent)this, value, label, tooltip));
            }
        });
        return items;
    }

    @Override
    public void setSelected(DropDownItem selected) {
        this.selected = selected;
        this.setValue(selected.getId());
        this.onPress.onPress((Button)selected);
    }

    public void setValue(T value) {
        if (!this.field.get().equals(value)) {
            this.field.set((Object)value);
            this.field.save();
        }
        String label = value instanceof KeyedEnum ? Constants.getString(((KeyedEnum)value).getKey()) : Constants.getString(value.toString());
        this.setMessage((Component)Constants.getStringTextComponent(this.getFormattedLabel(label)));
    }

    public ConfigField<T> getField() {
        return this.field;
    }

    @Override
    public int getFitWidth(Font fr) {
        int max = fr.width(this.getMessage().getString());
        for (DropDownItem item : this.items) {
            max = Math.max(max, fr.width(this.getFormattedLabel(item.getLabel())));
        }
        return max + this.buttonBuffer;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public void setWidth(int width) {
        if (this.paneScreen != null) {
            this.paneScreen.setPaneWidth(width);
        }
        super.setWidth(width);
    }

    @Override
    protected String getLabel(DropDownItem item) {
        return this.getFormattedLabel(item.getLabel());
    }

    protected String getFormattedLabel(String value) {
        return String.format("%1$s : %2$s %3$s %2$s", this.baseLabel, "\u21d5", value);
    }

    public String getBaseLabel() {
        return this.baseLabel;
    }

    @Override
    public void refresh() {
        this.setValue(this.field.get());
    }

    @Override
    public ConfigField<T> getConfigField() {
        return this.field;
    }
}

