/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.component.screens;

import java.util.List;
import journeymap.api.v2.client.ui.component.LayeredScreen;
import journeymap.client.ui.component.Removable;
import journeymap.client.ui.component.ScrollPane;
import journeymap.client.ui.component.buttons.Button;
import journeymap.client.ui.component.dropdown.DropDownItem;
import journeymap.common.mixin.client.AbstractScrollAreaAccessor;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.network.chat.Component;

public class ScrollPaneScreen
extends LayeredScreen {
    private static final int MAX_DISPLAY_SIZE = 6;
    protected ScrollPane scrollPane;
    protected Removable removable;
    private int paneWidth;
    private int paneHeight;
    public boolean visible = false;
    private int paneX;
    private int paneY;
    private List<DropDownItem> items;
    protected boolean renderDecorations = true;
    protected boolean renderSolidBackground = false;

    public ScrollPaneScreen(Removable parent, List<DropDownItem> items, int paneWidth, int paneHeight, int paneX, int paneY) {
        super((Component)Component.literal((String)""));
        this.removable = parent;
        this.paneWidth = paneWidth;
        this.paneHeight = paneHeight;
        this.paneX = paneX;
        this.paneY = paneY;
        this.items = items;
    }

    public boolean mouseClicked(MouseButtonEvent event, boolean doubleClick) {
        boolean paneClicked = this.scrollPane.mouseClicked(event, doubleClick);
        DropDownItem pressed = (DropDownItem)this.scrollPane.getClickedButton(event, doubleClick);
        ((AbstractScrollAreaAccessor)((Object)this.scrollPane)).setScrolling(false);
        boolean mouseOver = this.scrollPane.isMouseOver(event.x(), event.y());
        if (mouseOver) {
            this.scrollPane.updateScrolling(event);
            if (pressed != null) {
                this.onClick(pressed);
                return true;
            }
        } else {
            this.onClose();
            return false;
        }
        return super.mouseClicked(event, doubleClick);
    }

    public void renderPopupScreen(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        if (this.scrollPane != null) {
            this.scrollPane.setDimensions(this.paneWidth - 6, this.paneHeight + 1, 0, 0, this.paneX + 2, this.paneY);
            this.scrollPane.render(graphics, mouseX, mouseY, partialTicks);
            if (this.visible && this.scrollPane.isMouseOver(mouseX, mouseY)) {
                this.renderTooltip(graphics, mouseX, mouseY);
            }
            super.renderPopupScreen(graphics, mouseX, mouseY, partialTicks);
        }
    }

    private void renderTooltip(GuiGraphics graphics, int mouseX, int mouseY) {
        Button button = this.scrollPane.getButton(mouseX, mouseY);
        if (button != null) {
            graphics.setTooltipForNextFrame(this.font, button.getWrappedTooltip(), mouseX, mouseY);
        }
    }

    public void setRenderSolidBackground(boolean renderSolidBackground) {
        this.renderSolidBackground = renderSolidBackground;
    }

    public boolean mouseOverPane(double x, double y) {
        return this.scrollPane.isMouseOver(x, y);
    }

    public boolean mouseScrolled(double x, double y, double f, double scroll) {
        if (this.scrollPane.isMouseOver(x, y)) {
            return this.scrollPane.mouseScrolled(x, y, f, scroll);
        }
        return super.mouseScrolled(x, y, f, scroll);
    }

    public boolean mouseReleased(MouseButtonEvent event) {
        this.scrollPane.mouseReleased(event);
        return super.mouseReleased(event);
    }

    public boolean mouseDragged(MouseButtonEvent event, double mouseDX, double mouseDY) {
        this.scrollPane.mouseDragged(event, mouseDX, mouseDY);
        return super.mouseDragged(event, mouseDX, mouseDY);
    }

    public void mouseMoved(double mouseX, double mouseY) {
        this.scrollPane.mouseMoved(mouseX, mouseY);
        super.mouseMoved(mouseX, mouseY);
    }

    public boolean keyReleased(KeyEvent event) {
        this.scrollPane.keyReleased(event);
        return super.keyReleased(event);
    }

    public void setPaneWidth(int paneWidth) {
        this.paneWidth = paneWidth;
    }

    public void setPaneHeight(int paneHeight) {
        this.paneHeight = paneHeight;
    }

    public int getPaneWidth() {
        if (this.scrollPane != null) {
            return this.scrollPane.getWidth();
        }
        return this.paneWidth;
    }

    public int getPaneHeight() {
        return this.paneHeight;
    }

    public void setPaneX(int paneX) {
        this.paneX = paneX;
    }

    public void setPaneY(int paneY) {
        this.paneY = paneY;
    }

    public int getPaneX() {
        return this.paneX;
    }

    public int getPaneY() {
        return this.paneY;
    }

    public void setParent(Removable removable) {
        this.removable = removable;
    }

    public ScrollPane getScrollPane() {
        return this.scrollPane;
    }

    public boolean isPauseScreen() {
        return this.backgroundScreen.isPauseScreen();
    }

    public void setItems(List<DropDownItem> items) {
        this.items = items;
    }

    public void display() {
        this.scrollPane = new ScrollPane(null, Minecraft.getInstance(), 0, 0, this.items, this.items.get(0).getHeight(), 2);
        this.scrollPane.setDrawPartialScrollable(false);
        this.scrollPane.setRenderSelection(false);
        this.scrollPane.setRenderDecorations(this.renderDecorations);
        this.scrollPane.setRenderSolidBackground(this.renderSolidBackground);
        super.display();
        this.visible = true;
    }

    public void onClick(DropDownItem pressed) {
        this.onClose();
        pressed.select();
    }

    public void onClose() {
        this.visible = false;
        this.removable.onRemove();
        super.onClose();
    }

    public void setRenderDecorations(boolean renderDecorations) {
        this.renderDecorations = renderDecorations;
    }
}

