/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.waypointmanager.group;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Optional;
import java.util.function.Consumer;
import journeymap.client.ui.component.ScrollListLayoutPane;
import journeymap.client.ui.component.Slot;
import journeymap.client.ui.waypointmanager.WaypointManager;
import journeymap.client.ui.waypointmanager.group.GroupSlot;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ComponentPath;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.ContainerEventHandler;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.navigation.FocusNavigationEvent;
import net.minecraft.client.gui.navigation.ScreenDirection;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.client.input.MouseButtonInfo;

public class GroupPanel<T extends GroupSlot>
extends ScrollListLayoutPane<T> {
    private int lastIndex = -1;
    final WaypointManager manager;

    public GroupPanel(Minecraft mc, WaypointManager manager, int x, int y, int width, int height, int slotHeight) {
        super(mc, x, y, width, height, slotHeight);
        this.manager = manager;
    }

    @Override
    public boolean mouseReleased(MouseButtonEvent event) {
        this.getChildAt(event.x(), event.y());
        return super.mouseReleased(event);
    }

    @Override
    public void renderSelection(GuiGraphics guiGraphics, Slot<T> entry, int color) {
        int top = entry.getContentY();
        int i = this.getX() + (this.width - entry.getWidth()) / 2;
        int j = this.getX() + (this.width + entry.getWidth()) / 2 - 4;
        guiGraphics.fill(i, top - 2, j + 4, top + entry.getHeight() - 2, color);
        guiGraphics.fill(i + 1, top - 1, j + 3, top + entry.getHeight() - 3, -16777216);
    }

    @Override
    public void renderBackground(GuiGraphics graphics, PoseStack poseStack, int i, int j, float f) {
    }

    @Override
    public boolean mouseClicked(MouseButtonEvent event, boolean doubleClick) {
        if (this.isMouseOver(event.x(), event.y())) {
            this.getRootSlots().forEach(slot -> slot.getLayout().visitWidgets(widget -> widget.mouseClicked(event, doubleClick)));
            return super.mouseClicked(event, doubleClick);
        }
        return false;
    }

    @Override
    public ComponentPath nextFocusPath(FocusNavigationEvent event) {
        Slot focused = null;
        if (this.getItemCount() == 0) {
            return null;
        }
        if (event instanceof FocusNavigationEvent.ArrowNavigation) {
            ComponentPath path;
            FocusNavigationEvent.ArrowNavigation nav = (FocusNavigationEvent.ArrowNavigation)event;
            ScreenDirection direction = nav.direction();
            switch (direction) {
                case UP: 
                case DOWN: {
                    focused = (Slot)this.nextEntry(event.getVerticalDirectionForInitialFocus());
                    if (focused == null) break;
                    this.manager.updateSelectedGroup(focused);
                    break;
                }
                case RIGHT: {
                    this.lastIndex = this.children().indexOf(this.getFocused());
                    break;
                }
                case LEFT: {
                    focused = this.lastIndex > -1 ? this.getSlot(this.lastIndex) : this.getSlot(0);
                    this.manager.updateSelectedGroup(focused);
                }
            }
            do {
                if (focused != null) continue;
                return null;
            } while ((path = focused.children().isEmpty() ? ComponentPath.leaf((GuiEventListener)focused) : focused.focusPathAtIndex((FocusNavigationEvent)nav, this.lastIndex)) == null);
            return ComponentPath.path((ContainerEventHandler)this, (ComponentPath)path);
        }
        return super.nextFocusPath(event);
    }

    @Override
    public void visitSlots(Consumer<AbstractWidget> consumer) {
        this.getRootSlots().forEach(slot -> slot.getLayout().visitWidgets(consumer));
    }

    @Override
    public void initSlots() {
        this.getRootSlots().forEach(GroupSlot::init);
    }

    @Override
    public void repositionSlots() {
        this.getRootSlots().forEach(GroupSlot::repositionElements);
    }

    public void unselect() {
        this.getRootSlots().forEach(slot -> slot.setSelected(false));
    }

    public void select(String guid) {
        this.getRootSlots().stream().filter(slot -> guid.equals(slot.getGroup().getGuid())).findFirst().ifPresent(t -> {
            t.setSelected(true);
            t.setFocused(true);
            this.setSelected((AbstractSelectionList.Entry)t);
        });
    }

    protected boolean isValidClickButton(MouseButtonInfo event) {
        return event.button() == 0 || event.button() == 1;
    }

    public void setSelected(String lastSelected) {
        Optional<GroupSlot> group = this.getRootSlots().stream().filter(s -> lastSelected.equals(s.getGroup().getGuid())).findFirst();
        GroupSlot slot = group.orElseGet(() -> (GroupSlot)this.getRootSlots().getFirst());
        slot.setSelected(true);
        slot.setFocused(true);
        this.setSelected((AbstractSelectionList.Entry)slot);
    }
}

