/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.waypointmanager.notification;

import journeymap.client.render.draw.DrawUtil;
import journeymap.client.ui.component.ScrollListLayoutPane;
import journeymap.client.ui.component.Slot;
import journeymap.client.ui.waypointmanager.notification.WaypointNotificationSlot;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.input.MouseButtonEvent;

public class NotificationPanel<T extends WaypointNotificationSlot>
extends ScrollListLayoutPane<T> {
    final int offset = 1;

    public NotificationPanel(Minecraft mc, int width, int height, int slotHeight) {
        super(mc, 0, 0, width, height, slotHeight);
        this.hpad = 1;
    }

    @Override
    public void updateSize(int width, int height, int x, int y) {
        super.updateSizeAndPosition(width, height, x - 0, y);
        this.scrollbarX = this.width + x - 1;
        this.listWidth = this.width - 1;
    }

    @Override
    public void setListWidth(int width) {
        this.scrollbarX = (this.width + width) / 2 - 1;
        this.listWidth = width - 1;
    }

    @Override
    public boolean mouseClicked(MouseButtonEvent event, boolean doubleClick) {
        if (this.isMouseOver(event.x(), event.y())) {
            this.getRootSlots().forEach(slot -> slot.getLayout().visitWidgets(widget -> widget.mouseClicked(event, doubleClick)));
            return super.mouseClicked(event, doubleClick);
        }
        return false;
    }

    @Override
    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        super.renderWidget(graphics, mouseX, mouseY, partialTick);
        DrawUtil.drawRectangle(graphics, this.getX(), this.getY(), this.width + 4, 1.0, 0x404040, this.alpha);
        DrawUtil.drawRectangle(graphics, this.getX(), this.getY() + this.height, this.width + 4, 1.0, 0x404040, this.alpha);
        DrawUtil.drawRectangle(graphics, this.getX(), this.getY(), 1.0, this.height, 0x404040, this.alpha);
        DrawUtil.drawRectangle(graphics, this.getX() + this.width + 4, this.getY(), 1.0, this.height + 1, 0x404040, this.alpha);
    }

    @Override
    public void renderSelection(GuiGraphics p_283589_, Slot<T> p_440613_, int p_240142_) {
    }

    public void renderBackground(GuiGraphics graphics, int i, int j, float f) {
    }

    public void setX(int x) {
        super.setX(x);
        this.scrollbarX = this.width + x - 1;
    }
}

