/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.render.map;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.nio.FloatBuffer;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import journeymap.api.client.impl.ClientAPI;
import journeymap.api.client.impl.ClientEventManager;
import journeymap.api.services.EventBus;
import journeymap.api.v2.client.display.Context;
import journeymap.api.v2.client.event.DisplayUpdateEvent;
import journeymap.api.v2.client.util.UIState;
import journeymap.client.data.DataCache;
import journeymap.client.io.RegionImageHandler;
import journeymap.client.model.map.MapState;
import journeymap.client.model.map.MapType;
import journeymap.client.model.region.RegionCoord;
import journeymap.client.model.region.RegionImageCache;
import journeymap.client.render.RenderWrapper;
import journeymap.client.render.draw.DrawEntityStep;
import journeymap.client.render.draw.DrawStep;
import journeymap.client.render.map.GridLines;
import journeymap.client.render.map.RegionTile;
import journeymap.client.render.map.Renderer;
import journeymap.client.ui.UIManager;
import journeymap.client.ui.fullscreen.Fullscreen;
import journeymap.common.Journeymap;
import net.minecraft.class_1041;
import net.minecraft.class_156;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4597;
import org.apache.logging.log4j.Logger;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.lwjgl.BufferUtils;

public class MapRenderer
implements Renderer {
    protected static final int BLOCK_PAD = 32;
    protected int zoom;
    private static boolean enabled = true;
    private final Logger logger = Journeymap.getLogger();
    SortedMap<RegionCoord, RegionTile> regions = Collections.synchronizedSortedMap(new TreeMap(RegionCoord.getComparator(null).reversed()));
    Set<String> mapTypeImageFiles = new HashSet<String>();
    private File worldDir;
    protected MapType mapType;
    private class_238 blockBounds = null;
    private int gridSize;
    protected MapState state;
    protected int lastHeight = -1;
    protected int lastWidth = -1;
    private int glErrors = 0;
    private final int maxGlErrors = 20;
    protected Rectangle2D.Double viewPortBounds = null;
    protected Rectangle2D.Double screenBounds = null;
    protected Rectangle2D.Double regionBounds = null;
    protected UIState uiState;
    protected final Context.UI contextUi;
    private final Point2D.Double centerPixelOffset = new Point2D.Double();
    protected double centerBlockX;
    protected double centerBlockZ;
    protected RegionCoord centerRegion;
    protected RegionCoord sortingCenterRegion;
    protected final class_310 mc = class_310.method_1551();
    public int mouseX = 0;
    public int mouseY = 0;
    public Fullscreen fullscreen = null;
    private final FloatBuffer modelMatrixBuf;
    private final FloatBuffer projMatrixBuf;
    private final Vector3f windowPos;
    private final Vector3f objPose;
    private final int[] viewport;
    private final Matrix4f modelMatrix;
    private final Matrix4f projectionMatrix;
    private double currentRotation;
    protected final GridLines gridLines;
    private CompletableFuture<Set<String>> mapTypeFileFuture;
    private boolean renderReady = false;

    public MapRenderer(Context.UI contextUi) {
        this.contextUi = contextUi;
        this.gridLines = new GridLines(this);
        this.modelMatrixBuf = BufferUtils.createFloatBuffer((int)16);
        this.projMatrixBuf = BufferUtils.createFloatBuffer((int)16);
        this.windowPos = new Vector3f();
        this.objPose = new Vector3f();
        this.viewport = new int[4];
        this.modelMatrix = new Matrix4f(this.modelMatrixBuf);
        this.projectionMatrix = new Matrix4f(this.projMatrixBuf);
        this.centerBlockX = this.mc.field_1773.method_19418().method_19328().method_10263();
        this.centerBlockZ = this.mc.field_1773.method_19418().method_19328().method_10260();
        try {
            this.uiState = UIState.newInactive((Context.UI)contextUi, (class_310)class_310.method_1551());
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private void updateMapTypeImageFiles() {
        if (this.mapTypeFileFuture == null || this.mapTypeFileFuture.isDone()) {
            this.mapTypeFileFuture = CompletableFuture.supplyAsync(() -> RegionImageHandler.getImageFilesForMapType(class_310.method_1551(), this.mapType), class_156.method_18349());
            this.mapTypeFileFuture.whenCompleteAsync((set, throwable) -> {
                this.mapTypeImageFiles = set;
                this.updateGrid(this.centerRegion);
            }, (Executor)class_156.method_18349());
        }
    }

    private void loadInMemoryRegions() {
        List<RegionTile> regionsInMemory = RegionImageCache.INSTANCE.getRegionImageSets().stream().filter(set -> set.getExistingHolder(this.mapType) != null && set.getExistingHolder(this.mapType).hasTexture() && this.regions.get(set.getRegionCoord()) == null).map(set -> new RegionTile(set.getRegionCoord(), this.state)).toList();
        for (RegionTile tile : regionsInMemory) {
            this.regions.putIfAbsent(tile.getRegionCoord(), tile);
        }
    }

    private void sortRegions() {
        if (this.sortingCenterRegion != null && this.centerRegion != null && this.centerRegion.compareTo(this.sortingCenterRegion) == 0) {
            return;
        }
        this.sortingCenterRegion = this.centerRegion;
        SortedMap<RegionCoord, RegionTile> oldRegions = this.regions;
        this.regions = Collections.synchronizedSortedMap(new TreeMap(RegionCoord.getComparator(this.sortingCenterRegion).reversed()));
        this.regions.putAll(oldRegions);
    }

    public boolean setZoom(double zoom) {
        int minZoom = Context.UI.Fullscreen.equals((Object)this.contextUi) ? 2 : 256;
        this.zoom = (int)class_3532.method_15350((double)zoom, (double)minZoom, (double)16384.0);
        return true;
    }

    private void updateGrid(RegionCoord centerRegion) {
        this.sortRegions();
        this.gridSize = this.getCalculatedGridSize(this.zoom);
        int regionCount = this.gridSize / 2;
        this.loadInMemoryRegions();
        this.regionBounds = new Rectangle2D.Double(centerRegion.regionX - regionCount, centerRegion.regionZ - regionCount, this.gridSize, this.gridSize);
        for (int x = centerRegion.regionX - regionCount; x <= centerRegion.regionX + regionCount; ++x) {
            for (int z = centerRegion.regionZ - regionCount; z <= centerRegion.regionZ + regionCount; ++z) {
                if (this.mapTypeImageFiles.contains(x + "," + z + ".png")) {
                    RegionCoord rCoord = RegionCoord.fromRegionPos(this.worldDir, x, z, this.state.getDimension());
                    if (this.regions.get(rCoord) != null) continue;
                    this.regions.put(rCoord, new RegionTile(rCoord, this.state));
                    continue;
                }
                if (this.mc.method_1576() != null && !this.mc.method_1576().method_3724()) continue;
            }
        }
        this.renderReady = true;
    }

    public void setContext(MapState state) {
        this.worldDir = state.getWorldDir();
        this.mapType = state.getMapType();
        this.state = state;
    }

    public void render(class_332 graphics, class_4597.class_4598 buffers, double offsetX, double offsetZ, float alpha, boolean showGrid) {
        block8: {
            try {
                if (enabled) {
                    class_2338 cornerBlock = class_2338.method_49637((double)(this.centerBlockX - 256.0), (double)0.0, (double)(this.centerBlockZ - 256.0));
                    Point2D.Double cornerPixel = this.getBlockPixelInGrid(cornerBlock);
                    try {
                        if (this.renderReady) {
                            for (RegionTile region : this.regions.sequencedValues()) {
                                region.setPosition(this.centerRegion, cornerPixel, this.regionBounds, offsetX, offsetZ, this.zoom);
                                region.render(graphics, (class_4597)buffers, this.centerPixelOffset.x, this.centerPixelOffset.y, alpha);
                            }
                        }
                    }
                    catch (ConcurrentModificationException concurrentModificationException) {
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                        this.logger.error("Error drawing map tiles", t);
                    }
                    this.gridLines.draw(graphics, (class_4597)buffers, this.centerRegion, cornerPixel, this.regionBounds, this.centerPixelOffset.x, this.centerPixelOffset.y, offsetX, offsetZ, this.zoom, alpha, showGrid);
                    break block8;
                }
                this.regions.values().forEach(RegionTile::close);
                this.regions.clear();
            }
            catch (Throwable t) {
                this.logger.error("Error rendering map: ", t);
            }
        }
    }

    public void draw(class_332 graphics, class_4597.class_4598 buffers, List<? extends DrawStep> drawStepList, Fullscreen fullscreen, int mouseX, int mouseY, double xOffset, double yOffset, double fontScale, double rotation) {
        this.mouseX = mouseX;
        this.mouseY = mouseY;
        this.fullscreen = fullscreen;
        this.draw(graphics, buffers, drawStepList, xOffset, yOffset, fontScale, rotation);
    }

    public void draw(class_332 graphics, class_4597.class_4598 buffers, List<? extends DrawStep> drawStepList, double xOffset, double yOffset, double fontScale, double rotation) {
        if (!enabled || drawStepList == null || drawStepList.isEmpty()) {
            return;
        }
        this.draw(graphics, buffers, xOffset, yOffset, fontScale, rotation, drawStepList.toArray(new DrawStep[drawStepList.size()]));
    }

    public void draw(class_332 graphics, class_4597.class_4598 buffers, double xOffset, double yOffset, double fontScale, double rotation, DrawStep ... drawSteps) {
        if (enabled) {
            for (DrawStep.Pass pass : DrawStep.Pass.values()) {
                int zLevel = 0;
                for (DrawStep drawStep : drawSteps) {
                    boolean onScreen;
                    if (drawStep instanceof DrawEntityStep) {
                        Point2D.Double position = ((DrawEntityStep)drawStep).getPosition(0.0, 0.0, this, true);
                        onScreen = this.isOnScreen(position);
                    } else {
                        onScreen = true;
                    }
                    if (drawStep != null && onScreen) {
                        graphics.method_51448().method_22903();
                        graphics.method_51448().method_46416(0.0f, 0.0f, (float)(++zLevel));
                        drawStep.draw(graphics, (class_4597)buffers, pass, xOffset, yOffset, this, fontScale, rotation);
                        graphics.method_51448().method_22909();
                        continue;
                    }
                    if (onScreen || !(drawStep instanceof DrawEntityStep)) continue;
                    DrawEntityStep entityStep = (DrawEntityStep)drawStep;
                    Point2D.Double position = ((DrawEntityStep)drawStep).getPosition(0.0, 0.0, this, true);
                    this.ensureOnScreen(position);
                    entityStep.drawOffscreen(graphics, (class_4597)buffers, pass, position, this, rotation, true);
                }
                buffers.method_22993();
            }
        }
    }

    @Override
    public Point2D.Double getPixel(double blockX, double blockZ) {
        Point2D.Double pixel = this.getBlockPixelInGrid(blockX, blockZ);
        if (this.isOnScreen(pixel)) {
            return pixel;
        }
        return null;
    }

    private RegionCoord getCenterRegion(double blockX, double blockZ) {
        return RegionCoord.fromChunkPos(this.worldDir, this.mapType, (int)blockX >> 4, (int)blockZ >> 4);
    }

    private double roundToScreenPixel(double value) {
        double pixelSizeInBlocks = 512.0 / (double)this.zoom;
        return pixelSizeInBlocks * Math.floor(value / pixelSizeInBlocks);
    }

    @Override
    public Point2D.Double getBlockPixelInGrid(class_2338 pos) {
        return this.getBlockPixelInGrid(pos.method_10263(), pos.method_10260());
    }

    @Override
    public Point2D.Double getBlockPixelInGrid(double blockX, double blockZ) {
        double localBlockX = this.roundToScreenPixel(blockX) - this.centerBlockX;
        double localBlockZ = this.roundToScreenPixel(blockZ) - this.centerBlockZ;
        double blockSize = (double)this.zoom / 512.0;
        double pixelOffsetX = (double)(this.mc.method_22683().method_4480() / 2) + localBlockX * blockSize;
        double pixelOffsetZ = (double)(this.mc.method_22683().method_4507() / 2) + localBlockZ * blockSize;
        return new Point2D.Double(pixelOffsetX, pixelOffsetZ);
    }

    @Override
    public class_2338 getBlockAtPixel(Point2D.Double pixel) {
        double centerPixelX = (double)this.lastWidth / 2.0;
        double centerPixelZ = (double)this.lastHeight / 2.0;
        double deltaX = (centerPixelX - pixel.x) / ((double)this.zoom / 512.0);
        double deltaZ = (centerPixelZ - ((double)this.lastHeight - pixel.y)) / ((double)this.zoom / 512.0);
        double x = Math.floor(this.centerBlockX - deltaX);
        double z = Math.floor(this.centerBlockZ + deltaZ);
        int y = DataCache.getPlayer().underground != false ? class_3532.method_15357((double)DataCache.getPlayer().posY) : class_310.method_1551().field_1687.method_8615();
        return class_2338.method_49637((double)x, (double)y, (double)z);
    }

    protected void updateBounds() {
        int width = this.mc.method_22683().method_4480();
        int height = this.mc.method_22683().method_4507();
        if (this.screenBounds == null || this.lastWidth != width || this.lastHeight != height || this.blockBounds == null) {
            this.lastWidth = width;
            this.lastHeight = height;
            this.screenBounds = this.viewPortBounds == null ? new Rectangle2D.Double(-32.0, -32.0, width + 32, height + 32) : new Rectangle2D.Double(((double)width - this.viewPortBounds.width) / 2.0, ((double)height - this.viewPortBounds.height) / 2.0, this.viewPortBounds.width, this.viewPortBounds.height);
            ClientAPI.INSTANCE.flagOverlaysForRerender();
        }
    }

    public void updateUIState(boolean isActive) {
        if (isActive && this.screenBounds == null) {
            return;
        }
        UIState newState = null;
        if (isActive) {
            int worldHeight = class_310.method_1551().field_1687.method_8597().comp_653();
            class_2338 upperLeft = this.getBlockAtPixel(new Point2D.Double(this.screenBounds.getMinX(), this.screenBounds.getMinY()));
            class_2338 lowerRight = this.getBlockAtPixel(new Point2D.Double(this.screenBounds.getMaxX(), this.screenBounds.getMaxY()));
            this.blockBounds = class_238.method_54784((class_2338)upperLeft.method_10069(-32, 0, -32), (class_2338)lowerRight.method_10069(32, worldHeight, 32));
            try {
                newState = new UIState(this.contextUi, true, this.mapType.dimension, this.zoom, this.mapType.apiMapType, class_2338.method_49637((double)this.centerBlockX, (double)0.0, (double)this.centerBlockZ), this.mapType.vSlice, this.blockBounds, this.screenBounds);
            }
            catch (Exception e) {
                this.logger.error("Error Creating new UIState: ", (Throwable)e);
            }
        } else {
            newState = UIState.newInactive((UIState)this.uiState);
        }
        if (this.uiState == null && newState != null || newState != null && !newState.equals((Object)this.uiState)) {
            this.uiState = newState;
            ClientEventManager clientEventManager = ClientAPI.INSTANCE.getClientEventManager();
            DisplayUpdateEvent displayUpdateEvent = new DisplayUpdateEvent(this.uiState);
            if (EventBus.hasListeners(displayUpdateEvent)) {
                clientEventManager.queueDisplayUpdateEvent(displayUpdateEvent);
            }
        }
    }

    public void updateTiles(MapType mapType, int zoom, boolean fullUpdate) {
        this.mapType = mapType;
        this.zoom = zoom;
        this.updateBounds();
        RegionTile region = (RegionTile)this.regions.get(this.centerRegion);
        if (this.centerRegion == null || region == null || region != null && region.getZoom() != this.zoom) {
            this.centerRegion = this.getCenterRegion(this.centerBlockX, this.centerBlockZ);
            if (!fullUpdate) {
                CompletableFuture.runAsync(() -> this.updateGrid(this.centerRegion), class_156.method_18349());
            }
        }
        Point2D blockPixelOffset = this.blockPixelOffsetInRegion(this.centerRegion, this.centerBlockX, this.centerBlockZ);
        double blockSizeOffset = this.uiState.blockSize / 2.0;
        double displayOffsetX = 0.0;
        double displayOffsetY = 0.0;
        displayOffsetX = this.centerBlockX < 0.0 ? (displayOffsetX -= blockSizeOffset) : (displayOffsetX += blockSizeOffset);
        displayOffsetY = this.centerBlockZ < 0.0 ? (displayOffsetY -= blockSizeOffset) : (displayOffsetY += blockSizeOffset);
        this.centerPixelOffset.setLocation(displayOffsetX + blockPixelOffset.getX(), displayOffsetY + blockPixelOffset.getY());
        if (fullUpdate) {
            this.updateMapTypeImageFiles();
        }
    }

    public Point2D blockPixelOffsetInRegion(RegionCoord centerRegion, double centerBlockX, double centerBlockZ) {
        double blockSize = this.getUIState().blockSize;
        double localBlockX = (double)centerRegion.getMinChunkCoord().method_8326() - Math.floor(centerBlockX);
        double localBlockZ = (double)centerRegion.getMinChunkCoord().method_8328() - Math.floor(centerBlockZ);
        if (centerBlockX < 0.0) {
            localBlockX += 1.0;
        }
        if (centerBlockZ < 0.0) {
            localBlockZ += 1.0;
        }
        double pixelOffsetX = (double)(this.zoom >> 1) + localBlockX * blockSize - blockSize / 2.0;
        double pixelOffsetZ = (double)(this.zoom >> 1) + localBlockZ * blockSize - blockSize / 2.0;
        return new Point2D.Double(pixelOffsetX, pixelOffsetZ);
    }

    public boolean center() {
        return this.center(this.worldDir, this.mapType, this.centerBlockX, this.centerBlockZ, this.zoom);
    }

    public void move(double deltaBlockX, double deltaBlockZ) {
        this.center(this.worldDir, this.mapType, this.centerBlockX + deltaBlockX, this.centerBlockZ + deltaBlockZ, this.zoom);
    }

    public boolean center(File worldDir, MapType mapType, double blockX, double blockZ, int zoom) {
        boolean centerTileChanged;
        boolean mapTypeChanged;
        boolean bl = mapTypeChanged = !Objects.equals(worldDir, this.worldDir) || !Objects.equals(mapType, this.mapType);
        if (!Objects.equals(worldDir, this.worldDir)) {
            this.worldDir = worldDir;
        }
        blockX = this.roundToScreenPixel(blockX);
        blockZ = this.roundToScreenPixel(blockZ);
        if (blockX == this.centerBlockX && blockZ == this.centerBlockZ && zoom == this.zoom && !mapTypeChanged && !this.regions.isEmpty()) {
            if (!Objects.equals(mapType.apiMapType, this.uiState.mapType)) {
                this.updateUIState(true);
            }
            return false;
        }
        this.centerBlockX = blockX;
        this.centerBlockZ = blockZ;
        this.zoom = zoom;
        RegionCoord newCenterRegion = this.getCenterRegion(this.centerBlockX, this.centerBlockZ);
        boolean bl2 = centerTileChanged = !newCenterRegion.equals(this.centerRegion);
        if (mapTypeChanged || centerTileChanged) {
            this.centerRegion = newCenterRegion;
            CompletableFuture.runAsync(() -> this.updateGrid(this.centerRegion), class_156.method_18349());
        }
        this.updateUIState(true);
        return true;
    }

    @Override
    public boolean isOnScreen(Point2D.Double pixel) {
        return this.screenBounds.contains(pixel);
    }

    @Override
    public boolean isOnScreen(Rectangle2D.Double bounds) {
        return this.screenBounds.intersects(bounds);
    }

    public boolean isOnScreen(double x, double y) {
        return this.screenBounds.contains(x, y);
    }

    public boolean isOnScreen(double startX, double startY, int width, int height) {
        if (this.screenBounds == null) {
            return false;
        }
        return this.screenBounds.intersects(startX, startY, width, height);
    }

    public void clear() {
        if (this.mapTypeFileFuture != null) {
            this.mapTypeFileFuture.cancel(true);
            this.mapTypeFileFuture = null;
        }
        this.renderReady = false;
        this.regions.values().forEach(RegionTile::close);
        this.regions.clear();
    }

    @Override
    public UIState getUIState() {
        return this.uiState;
    }

    @Override
    public Fullscreen getFullscreen() {
        return this.fullscreen;
    }

    @Override
    public MapType getMapType() {
        return this.mapType;
    }

    public void clearGlErrors(boolean report) {
        int err;
        while ((err = RenderWrapper.getError()) != 0) {
            if (!report || this.glErrors > 20) continue;
            ++this.glErrors;
            if (this.glErrors < 20) {
                this.logger.warn("GL Error occurred during JourneyMap draw: " + err);
                continue;
            }
            this.logger.warn("GL Error reporting during JourneyMap will be suppressed after max errors: 20");
        }
    }

    public boolean hasUnloadedTile() {
        try {
            for (RegionTile tile : this.regions.values()) {
                if (this.mapTypeFileFuture == null || !this.mapTypeFileFuture.isDone()) {
                    return false;
                }
                if (!this.isOnScreen(tile.getX(), tile.getY()) || tile.getTexture() == null || !tile.getTexture().isDefunct() || !tile.shouldRender()) continue;
                return true;
            }
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            // empty catch block
        }
        return false;
    }

    @Override
    public void ensureOnScreen(Point2D pixel) {
        if (this.screenBounds == null) {
            return;
        }
        double x = pixel.getX();
        if (x <= 0.0) {
            x = 0.0;
        } else if (x > this.screenBounds.getMaxX()) {
            x = this.screenBounds.getMaxX();
        }
        double y = pixel.getY();
        if (y <= 0.0) {
            y = 0.0;
        } else if (y > this.screenBounds.getMaxY()) {
            y = this.screenBounds.getMaxY();
        }
        pixel.setLocation(x, y);
    }

    public void updateRotation(class_332 graphics, double rotation) {
        this.currentRotation = rotation;
        this.viewport[0] = 0;
        this.viewport[1] = 0;
        this.viewport[2] = class_310.method_1551().method_22683().method_4489();
        this.viewport[3] = class_310.method_1551().method_22683().method_4506();
        graphics.method_51448().method_23760().method_23761().get(this.modelMatrixBuf);
        RenderWrapper.getProjectionMatrix().get(this.projMatrixBuf);
        this.modelMatrix.set(this.modelMatrixBuf);
        this.projectionMatrix.set(this.projMatrixBuf).mul((Matrix4fc)this.modelMatrix);
    }

    @Override
    public Point2D shiftWindowPosition(double x, double y, int shiftX, int shiftY) {
        if (this.currentRotation % 360.0 == 0.0) {
            return new Point2D.Double(x + (double)shiftX, y + (double)shiftY);
        }
        this.projectionMatrix.project((float)x, (float)y, 0.0f, this.viewport, this.windowPos);
        this.projectionMatrix.unproject(this.windowPos.get(0) + (float)shiftX, this.windowPos.get(1) + (float)shiftY, 0.0f, this.viewport, this.objPose);
        return new Point2D.Float(this.objPose.get(0), this.objPose.get(1));
    }

    @Override
    public Point2D.Double getWindowPosition(Point2D.Double matrixPixel) {
        if (this.currentRotation % 360.0 == 0.0) {
            return matrixPixel;
        }
        this.projectionMatrix.project((float)matrixPixel.getX(), (float)matrixPixel.getY(), 0.0f, this.viewport, this.windowPos);
        return new Point2D.Double(this.windowPos.get(0), this.windowPos.get(1));
    }

    public void setViewPortBounds(Rectangle2D.Double viewPortBounds) {
        this.viewPortBounds = viewPortBounds;
        this.screenBounds = null;
        this.updateBounds();
    }

    @Override
    public int getZoom() {
        return this.zoom;
    }

    @Override
    public int getMouseX() {
        return this.mouseX;
    }

    @Override
    public int getMouseY() {
        return this.mouseY;
    }

    @Override
    public Context.UI getContext() {
        return this.contextUi;
    }

    @Override
    public int getWidth() {
        return this.lastWidth;
    }

    @Override
    public int getHeight() {
        return this.lastHeight;
    }

    @Override
    public int getGridSize() {
        return this.gridSize;
    }

    public int getCalculatedGridSize(int zoom) {
        class_1041 mainWindow = class_310.method_1551().method_22683();
        int width = Context.UI.Fullscreen.equals((Object)this.getUIState().ui) ? mainWindow.method_4489() : UIManager.INSTANCE.getMiniMap().getDisplayVars().minimapWidth;
        int gridSize = (int)Math.ceil((double)width / (double)zoom);
        if (++gridSize % 2 == 0) {
            ++gridSize;
        }
        return gridSize;
    }

    public static void setEnabled(boolean enabled) {
        MapRenderer.enabled = enabled;
    }
}

